<style>
    .dark-blue-color {
        color: #1c77d4 !important;
        font-weight: bold !important;
    }

    /* START CSS SALES SUMMARY */
    #div_row_summary {
        display: flex;
        flex-wrap: nowrap;
        white-space: nowrap;
    }

    .summary-card {
        border-radius: 10px;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
        flex: 0 0 auto;
    }

    .badge-count {
        background-color: #FFFFFF;
        padding: 5px 10px;
        border-radius: 10px;
    }

    /* END CSS SALES SUMMARY */

    /* START CSS TARGET VS REALISASI */
    .icon_target_realisasi {
        border-radius: 10px;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
        padding: 10px;
        flex: 0 0 auto;
        height: 50px;
        width: 50px;
    }

    .vertical-text {
        writing-mode: vertical-lr;
        transform: rotate(180deg);
        text-align: center;
        align-items: center;
        font-size: 14px;
        font-weight: bold;
    }

    /* END CSS TARGET VS REALISASI */

    #table_po_product th,
    #table_po_product td {
        padding-left: 0;
    }
</style>

<script>
    // DOCUMENT READY FUNCTION
    $(function() {
        dropdown_bulan();
        dropdown_tahun();
        dropdown_group_f_periode();
        dropdown_group_f_tahun();

        var periode = '<?= $periode ?>';
        var tahun = '<?= $tahun ?>';
        load_data_filter_periode(periode);
        load_data_filter_tahun(tahun);

        $("#btn_filter_periode").on("click", function() {
            var bulan = $(".filter_periode #periode").val();
            load_data_filter_periode(bulan, this);
        });

        $("#btn_filter_tahun").on("click", function() {
            var tahun = $(".filter_tahun #tahun").val();
            load_data_filter_tahun(tahun, this);
        });

        $("#filter_po_product").on("change", function() {
            var periode    = $(".filter_periode #periode").val();
            var id_group_m = !$(".filter_periode #id_group_m").val()?'all':$(".filter_periode #id_group_m").val();
            var by         = $(this).val();
            grafik_po_per_product(periode, id_group_m, by);
        });

        // $("#download-diagram").click(function() {
        //     downloadChartImage("PO Per Sales", ctxGrafikPoPerSales, this);
        // });
    });

    // Dropdown Bulan
    function dropdown_bulan() {
        $(".filter_periode #periode").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });

        $(".filter_periode #periode").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
            endDate: "today"
        });
    }

    // Dropdown Tahun
    function dropdown_tahun() {
        $(".filter_tahun #tahun").inputmask({
            'alias': 'datetime',
            'inputFormat': 'yyyy'
        });

        $(".filter_tahun #tahun").datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
            endDate: "today"
        });
    }

    // Dropdown Group for Periode
    function dropdown_group_f_periode(){
        var periode = $(".filter_periode #periode").val() ? $(".filter_periode #periode").val() : '0000';
        $(".filter_periode #id_group_m").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.dashboard.dropdown.group.area") ?>' + '?periode=' + periode + '&for=periode',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    // Dropdown Group for Tahun
    function dropdown_group_f_tahun(){
        var tahun = $(".filter_tahun #tahun").val() ? $(".filter_tahun #tahun").val() : '0000';
        $(".filter_tahun #id_group_m").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.dashboard.dropdown.group.area") ?>' + '?tahun=' + tahun + '&for=tahun',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_group_f_periode() {
        $(".filter_periode #id_group_m").val('').trigger('change');
        dropdown_group_f_periode();
    }

    function onchange_group_f_tahun() {
        $(".filter_tahun #id_group_m").val('').trigger('change');
        dropdown_group_f_tahun();
    }

    // Function Load Data Filter Bulan
    function load_data_filter_periode(periode, e = null) {
        var filter_po_product = $("#filter_po_product").val();
        var id_group_m        = !$(".filter_periode #id_group_m").val()?'all':$(".filter_periode #id_group_m").val();

        if (e != null) {
            var loading = Ladda.create(e);
            loading.start();

            $.when(
                grafik_sales_summary(periode, id_group_m),
                grafik_po_per_sales(periode, id_group_m),
                grafik_po_per_product(periode, id_group_m, filter_po_product),
                grafik_aktivitas(periode, id_group_m)
            ).done(function() {
                loading.stop();
            }).fail(function() {
                loading.stop();
            });
        } else {
            grafik_sales_summary(periode);
            grafik_po_per_sales(periode);
            grafik_po_per_product(periode, id_group_m, filter_po_product);
            grafik_aktivitas(periode);
        }

        screenUp(200);
    }

    // Function Load Data Filter Tahun
    function load_data_filter_tahun(tahun, e = null) {
        if (e != null) {
            var loading = Ladda.create(e);
            loading.start();

            $.when(grafik_target_realisasi(tahun)).done(function() {
                loading.stop();
            }).fail(function() {
                loading.stop();
            });
        } else {
            grafik_target_realisasi(tahun);
        }
    }

    function grafik_sales_summary(periode="00-000", id_group_m="all") {
        return $.get("<?= route('sales_activity.dashboard.data.sales.summary') ?>" + "?periode=" + periode + "&id_group_m=" + id_group_m, function(data) {
            $("#div_row_summary").html(data);
            set_width_col_summary();
        });
    }

    function grafik_po_per_sales(periode="00-000", id_group_m="all") {
        return $.get("<?= route('sales_activity.dashboard.data.po.per.sales') ?>" + "?periode=" + periode + "&id_group_m=" + id_group_m, function(data) {
            var result = JSON.parse(data);
            var result = result.po_per_sales;

            if(!$.isEmptyObject(result)){
                if (result.nama_karyawan.length > 50) {
                    var widthChart = result.nama_karyawan.length * 22;
                    $("#div_diagram_garis_po_per_sales").css("width", widthChart + "px");
                } else {
                    $("#div_diagram_garis_po_per_sales").css("width", "100%");
                }

                // Fill Graphic with Data
                grafikPoPerSales.data.labels = result.nama_karyawan;
                grafikPoPerSales.data.datasets[0].data = result.total_nominal;
                grafikPoPerSales.data.datasets[1].data = result.total_po;

                // Adjust Scale Total PO
                var totalPoNumbers = result.total_po.map(Number);
                var maxTotalPo = Math.max(...totalPoNumbers);
                if (maxTotalPo >= 10) {
                    grafikPoPerSales.options.scales.y2.steps = 0
                    grafikPoPerSales.options.scales.y2.max = 30
                    grafikPoPerSales.options.scales.y2.ticks.stepSize = 3
                } else {
                    grafikPoPerSales.options.scales.y2.steps = 0
                    grafikPoPerSales.options.scales.y2.max = 10
                    grafikPoPerSales.options.scales.y2.ticks.stepSize = 1
                }

                // Adjust Scale Nominal
                if(result.total_nominal > 0){
                    var totalNominalNumbers = result.total_nominal.map(Number);
                    var maxNominal = Math.max(...totalNominalNumbers);
                    var maxNominal = roundToMillion(maxNominal * 120 / 100);
                    grafikPoPerSales.options.scales.y.steps = 0;
                    grafikPoPerSales.options.scales.y.max = maxNominal;
                    grafikPoPerSales.options.scales.y.ticks.stepSize = maxNominal / 10;
                }

            }else{
                grafikPoPerSales.data.labels = [];
                grafikPoPerSales.data.datasets[0].data = [];
                grafikPoPerSales.data.datasets[1].data = [];
            }

            // UPDATE GRAFIK
            grafikPoPerSales.update();
        });
    }

    function grafik_po_per_product(periode="00-000", id_group_m="all", by = "product") {
        return $.get("<?= route('sales_activity.dashboard.data.po.per.product') ?>" + "?periode=" + periode + "&id_group_m=" + id_group_m + "&by=" + by, function(data) {
            $("#tbody_po_product").html(data);
        });
    }

    function grafik_aktivitas(periode="00-000", id_group_m="all") {
        return $.get("<?= route('sales_activity.dashboard.data.activity') ?>" + "?periode=" + periode + "&id_group_m=" + id_group_m, function(data) {
            var result = JSON.parse(data);
            var activity = result.activity;

            if (activity.total_semua_activity == 0) {
                grafikAktivitas.data.labels = ['Tidak Ada Aktivitas'];
                grafikAktivitas.data.datasets[0].data = ['1'];
                grafikAktivitas.data.datasets[0].backgroundColor = ["#FF5733"];
                res_activity.total_semua_activity = "0";
                grafikAktivitas.update();

                var html = result.html;
            } else {
                grafikAktivitas.data.labels = activity.jenis_activity;
                grafikAktivitas.data.datasets[0].data = activity.total_activity;
                grafikAktivitas.data.datasets[0].backgroundColor = activity.warna;
                res_activity.total_semua_activity = activity.total_semua_activity;
                grafikAktivitas.update();

                var html = result.html;
            }

            $("#div_row_activity").html(html);
        });
    }

    function grafik_target_realisasi(tahun = "0000") {
        var id_group_m = $(".filter_tahun #id_group_m").val() ? $(".filter_tahun #id_group_m").val() : "all";
        return $.get("<?= route('sales_activity.dashboard.data.target.realisasi') ?>" + "?tahun=" + tahun + "&id_group_m=" + id_group_m, function(data) {
            var result = JSON.parse(data);

            var result_t_tahunan = result.target_tahunan;
            var result_t_bulanan = result.target_bulanan;
            var result_t_kuartal = result.target_kuartal;
            var result_realisasi = result.realisasi;

            grafikTargetRealisasi.data.datasets[0].data = result_t_tahunan.data;
            grafikTargetRealisasi.data.datasets[1].data = result_t_kuartal.data;
            grafikTargetRealisasi.data.datasets[2].data = result_t_bulanan.data;
            grafikTargetRealisasi.data.datasets[3].data = result_realisasi.data;
            grafikTargetRealisasi.update();

            $(".tahun_target").html(tahun);
            $("#total_target_tahunan").html(result_t_tahunan.total);
            $("#total_target_kuartal").html(result_t_kuartal.total);
            $("#total_target_bulanan").html(result_t_bulanan.total);
            $("#total_realisasi").html(result_realisasi.total);
            $("#total_selisih_target").html(result.selisih);
        });
    }

    // function ukuran sales summary secara dinamis
    function set_width_col_summary() {
        var count_summary_card = [];
        $(".summary-card").each(function() {
            count_summary_card.push($(this).val());
        });

        if (count_summary_card.length > 0) {
            if (count_summary_card.length >= 5) {
                $("#div_row_summary").css('overflow-x', 'auto');

                var width_div_row_summary = $("#div_row_summary").width();
                var width_div_summary_card = width_div_row_summary / 5 * 90 / 100;
                $(".summary-card").css('width', width_div_summary_card);
            } else {
                var width_div_row_summary = $("#div_row_summary").width();
                var width_div_summary_card = width_div_row_summary / count_summary_card.length * 90 / 100;
                $(".summary-card").css('width', width_div_summary_card);
            }
        }
    }

    // function pembulatan angka jutaan keatas
    function roundToMillion(num) {
        return Math.ceil(num / 1000000) * 1000000;
    }

    // function ukuran lebar po per sales secara dinamis
    // function set_width_line_graph(length = 0){
    //     if(length > 4){
    //         var size = length * 120;
    //     }else{
    //         var size = 500;
    //     }
    //     $("#div_diagram_garis_po_per_sales").css("width", size+"px");
    // }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Dashboard Sales</h5>
    </div>
</div>
<hr>

<div class="filter_periode row mt-2">
    <div class="col-md-12 d-flex justify-content-end align-items-center">
        <label class="mr-1">
            <span class="font-weight-bold">BULAN</span>
            <input type="text" id="periode" class="form-control" style="width: 150px;" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('m-Y') ?>" onchange="onchange_group_f_periode()">
        </label>

        <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
            <label class="mr-1">
                <span class="font-weight-bold">GROUP/AREA</span><BR>
                <select class="form-control" id="id_group_m" style="width: 250px;"></select>
            </label>
        <?php endif; ?>

        <label class="align-self-end">
            <button type="button" id="btn_filter_periode" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </label>
    </div>
</div>

<div class="content-header">
    <div class="card card-rounded">
        <div class="card-content">
            <div class="card-header d-flex align-items-center pl-0">
                <h5 class="dark-blue-color text-center">Sales Summary</h5>
            </div>

            <div class="card-body">
                <div id="div_row_summary" class="row pb-1"></div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- PO Per Sales -->
    <div class="col-md-12">
        <div class="content-header pb-0">
            <div class="card card-rounded">
                <div class="card-content">
                    <div class="card-header d-flex align-items-center pl-0">
                        <h5 class="dark-blue-color">PO Per Sales</h5>
                    </div>
                </div>
                <!-- <div class="position-absolute pt-1 w-100 text-right" style="right: 15px;">
                    <button id="download-diagram" type="button" class="btn btn-primary ladda-button" data-style="expand-left">
                        <i class="fa fa-download"></i> Download
                    </button>
                </div> -->
                <div id="card_body_po_sales" class="card-body w-100 pl-0 pb-0 mb-1" style="overflow-x: auto;">
                    <div id="div_diagram_garis_po_per_sales" class="mb-2" style="height:450px">
                        <canvas id="diagram_garis_po_per_sales"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- PO Per Product -->
    <div class="col-md-6">
        <div class="content-header" style="height:480px">
            <div class="card card-rounded">
                <div class="card-content">
                    <div class="card-header d-flex justify-content-between align-items-center px-0">
                        <h5 class="dark-blue-color">PO by Popularity</h5>
                        <select name="filter_po_product" id="filter_po_product" class="form-control w-50">
                            <option value="product" selected>Product</option>
                            <option value="group_product">Group Product</option>
                        </select>
                    </div>
                </div>
                <div class="card-body px-0 pr-0 pt-0" style="height:335px; max-height:335px; overflow-y:auto; padding:0">
                    <table id="table_po_product" class="table mb-1">
                        <thead class="text-light">
                            <tr>
                                <th class="text-center" style="width: 10%">No</th>
                                <th class="text-left">Nama</th>
                                <th>Popularity</th>
                                <th class="text-center pr-0 pl-0" style="width: 10%">Presentase</th>
                            </tr>
                        </thead>
                        <tbody id="tbody_po_product">
                            <!-- TABEL -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Sales Activity -->
    <div class="col-md-6">
        <div class="content-header" style="height:480px">
            <div class="card card-rounded">
                <div class="card-content">
                    <div class="card-header d-flex align-items-center pl-0">
                        <h5 class="dark-blue-color">Sales Activity</h5>
                    </div>
                </div>
                <div class="card-body p-0" style="height:400px">
                    <div class="row h-100">
                        <div class="col-md-7 my-auto">
                            <canvas id="grafik_aktivitas" style="max-height:280px"></canvas>
                        </div>
                        <div class="col-md-5 my-auto" style="overflow-y: auto; max-height:320px;">
                            <div id="div_row_activity">
                                <!-- AKTIVITAS -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="filter_tahun row mt-2">
    <div class="col-md-12 d-flex justify-content-end align-items-center">
        <label class="mr-1">
            <span class="font-weight-bold text-uppercase"><?= $this->lang->line('tahun') ?></span>
            <input type="text" id="tahun" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('Y') ?>" onchange="onchange_group_f_tahun()">
        </label>

        <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
            <label class="mr-1">
                <span class="font-weight-bold">GROUP/AREA</span><BR>
                <select class="form-control" id="id_group_m" style="width: 250px;"></select>
            </label>
        <?php endif; ?>
        
        <label class="align-self-end">
            <button type="button" id="btn_filter_tahun" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </label>
    </div>
</div>

<div class="content-header">
    <div class="card card-rounded">
        <div class="card-content">
            <div class="card-header d-flex align-items-center pl-0">
                <h5 class="dark-blue-color">Target VS Realisasi</h5>
            </div>

            <div class="card-body">
                <?php
                $tahun_sekarang   = date('Y');
                ?>
                <div class="row">
                    <div class="col-md-9">
                        <div class="row">
                            <div class="mr-1 vertical-text">
                                <span class="tahun_target"><?= $tahun_sekarang ?></span>
                            </div>
                            <div class="col-md-11 p-0 m-0">
                                <canvas id="grafik_target_realisasi"></canvas>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 pr-0 pl-0">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="icon_target_realisasi" style="background-color:#007aff;">
                                    <img src="<?= base_url('assets/images/icon/target_icon.png') ?>" style="width:30px;height:30px">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <label>Total Target Tahunan
                                    <span class="tahun_target"><?= $tahun_sekarang ?></span>
                                </label><BR>
                                <span id="total_target_tahunan" class="font-weight-bold"></span>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-md-3">
                                <div class="icon_target_realisasi" style="background-color:#9ACD32;">
                                    <img src="<?= base_url('assets/images/icon/target_icon.png') ?>" style="width:30px;height:30px">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <label>Total Target Kuartal
                                    <span class="tahun_target"><?= $tahun_sekarang ?></span>
                                </label><BR>
                                <span id="total_target_kuartal" class="font-weight-bold"></span>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-md-3">
                                <div class="icon_target_realisasi" style="background-color:#ff9500;">
                                    <img src="<?= base_url('assets/images/icon/target_icon.png') ?>" style="width:30px;height:30px">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <label>Total Target Bulanan
                                    <span class="tahun_target"><?= $tahun_sekarang ?></span>
                                </label><BR>
                                <span id="total_target_bulanan" class="font-weight-bold"></span>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-md-3">
                                <div class="icon_target_realisasi" style="background-color:#00e096;">
                                    <img src="<?= base_url('assets/images/icon/total_icon.png') ?>" style="width:30px;height:30px">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <label>Total Realisasi
                                    <span class="tahun_target"><?= $tahun_sekarang ?></span>
                                </label><BR>
                                <span id="total_realisasi" class="font-weight-bold"></span>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-md-3">
                                <div class="icon_target_realisasi" style="background-color:#ff3b30;">
                                    <img src="<?= base_url('assets/images/icon/selisih_icon.png') ?>" style="width:30px;height:30px">
                                </div>
                            </div>
                            <div class="col-md-9">
                                <label>Selisih Target
                                    <span class="tahun_target"><?= $tahun_sekarang ?></span>
                                </label><BR>
                                <span id="total_selisih_target" class="font-weight-bold"></span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- START GRAFIK PO PER SALES -->
<script>
    var ctxGrafikPoPerSales = document.getElementById('diagram_garis_po_per_sales').getContext('2d');
    var grafikPoPerSales = new Chart(ctxGrafikPoPerSales, {
        type: 'bar',
        data: {
            labels: [],
            datasets: [{
                    label: "Nominal",
                    backgroundColor: "#34c759",
                    minBarLength: 10,
                    data: [],
                    yAxisID: 'y'
                },
                {
                    label: "Total PO",
                    backgroundColor: "#007aff",
                    minBarLength: 10,
                    data: [],
                    yAxisID: 'y2'
                },
            ],
        },
        options: {
            maintainAspectRatio: false,
            responsive: true,
            scales: {
                y: {
                    offset: true,
                    beginAtZero: true,
                    position: 'left',
                    grid: {
                        display: true
                    }
                },
                y2: {
                    offset: true,
                    beginAtZero: true,
                    position: 'right',
                    grid: {
                        display: false
                    }
                },
                x: {
                    ticks: {
                        autoSkip: false,
                        callback: function(value, index, values) {
                            var label = this.getLabelForValue(value);
                            if (values.length > 20) {
                                if (label.length > 25) {
                                    return label.substring(0, 22) + '...';
                                }
                            }
                            return label;
                        }
                    },
                    grid: {
                        display: false
                    },
                }
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'bottom',
                    // fillStyle: Color,
                }
            }
        },
    });
</script>
<!-- END GRAFIK PO PER SALES -->

<!-- START GRAFIK AKTIVITAS -->
<script>
    var res_activity = {};
    var ctxGrafikAktivitas = document.getElementById('grafik_aktivitas');
    var grafikAktivitas = new Chart(ctxGrafikAktivitas, {
        type: 'doughnut',
        data: {
            labels: [],
            datasets: [{
                label: "Total Activity",
                backgroundColor: [],
                data: []
            }, ],
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        display: false
                    },
                    grid: {
                        display: false
                    },
                    border: {
                        display: false,
                    },
                },
                x: {
                    ticks: {
                        display: false
                    },
                    grid: {
                        display: false,
                    },
                    border: {
                        display: false,
                    },
                },
            },
            plugins: {
                legend: {
                    display: false
                },
            },
        },
        plugins: [{
            id: 'text',
            beforeDraw: function(chart, a, b) {
                var width = chart.width,
                    height = chart.height,
                    ctx = chart.ctx;

                ctx.restore();
                var fontSize = (height / 200).toFixed(2);
                ctx.font = fontSize + "em Poppins Light";
                ctx.textBaseline = "middle";

                var text = res_activity.total_semua_activity + " Aktivitas",
                    textX = Math.round((width - ctx.measureText(text).width) / 2),
                    textY = height / 2;

                ctx.fillText(text, textX, textY);
                ctx.save();
            }
        }]
    });
</script>
<!-- END GRAFIK AKTIVITAS -->

<!-- START GRAFIK TARGET REALISASI -->
<script>
    var ctxGrafikTargetRealisasi = document.getElementById('grafik_target_realisasi');

    var grafikTargetRealisasi = new Chart(ctxGrafikTargetRealisasi, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agt', 'Sep', 'Okt', 'Nov', 'Des'],
            datasets: [
                {
                    label: "Target Tahunan",
                    borderColor: "#007aff",
                    backgroundColor: "rgba(0, 122, 255, 0.03)",
                    fill: true,
                    tension: 0.1,
                    data: [],
                },
                {
                    label: "Target Kuartal",
                    borderColor: "#9ACD32",
                    backgroundColor: "rgba(154, 205, 50, 0.03)",
                    fill: true,
                    tension: 0.1,
                    data: [],
                },
                {
                    label: "Target Bulanan",
                    borderColor: "#ff9500",
                    backgroundColor: "rgba(255, 149, 0, 0.03)",
                    fill: true,
                    tension: 0.1,
                    data: [],
                },
                {
                    label: "Realisasi",
                    borderColor: "#00e096",
                    backgroundColor: "rgba(0, 224, 150, 0.03)",
                    fill: true,
                    tension: 0.1,
                    data: [],
                }
            ],
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        display: false
                    },
                    grid: {
                        display: false
                    },
                },
                x: {
                    grid: {
                        display: false
                    },
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
</script>
<!-- END GRAFIK TARGET REALISASI -->
