<script type="text/javascript">
    $(function () {

        $('#filter_tahun').datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
        });

        // Set nilai default tahun ke tahun saat ini
        $('#filter_tahun').val(new Date().getFullYear());

        $('#btn_filter_tahun').on('click', function () {
            list_data.ajax.reload(); // Reload DataTables pertama
            list_data2.ajax.reload(); // Reload DataTables kedua
        });

        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function (e, settings, techNote, message) {
            if (confirm('<?= $this->lang->line('error_datatable') ?>')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': false,
            'paging': false,
            'lengthChange': true,
            'ordering': true,
            'info': false,
            'scrollX': false,
            "pageLength": 100,
            <?php if ($this->code_lang == 'id') {
                echo "
                'language': {
                    'url': '" . base_url("assets/plugins/datatables/dataTables-language-id.json") . "',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan'
                },";
            }
            ; ?> "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('history.cuti.listdata', ['jenis' => 'tambah', 'id_karyawan' => $this->route->param('id_karyawan')]) ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.tahun = $('#filter_tahun').val();
                },
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                "aTargets": "_all",
                "bSortable": false
            }, {
                "targets": [0, 2],
                "className": "text-center"
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //
                $('td:eq(0)', nRow).css({
                    'width': '100px'
                });

                $('td:eq(2)', nRow).css({
                    'width': '50px'
                });
            }
        });

        list_data2 = $('#list_data2').on('error.dt', function (e, settings, techNote, message) {
            if (confirm('<?= $this->lang->line('error_datatable') ?>')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': false,
            'paging': false,
            'lengthChange': true,
            'ordering': false,
            'info': false,
            'scrollX': false,
            "pageLength": 100,
            <?php if ($this->code_lang == 'id') {
                echo "
                'language': {
                    'url': '" . base_url("assets/plugins/datatables/dataTables-language-id.json") . "',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan'
                },";
            }
            ; ?> "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('history.cuti.listdata.terpakai', ['jenis' => 'kurang', 'id_karyawan' => $this->route->param('id_karyawan')]) ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.tahun = $('#filter_tahun').val();
                },
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                "targets": [0, 2], // Sesuaikan index kolom jika urutan berbeda
                "className": "text-center"
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //
                $('td:eq(0)', nRow).css({
                    'width': '100px'
                });

                $('td:eq(2)', nRow).css({
                    'width': '50px'
                });
            }
        });


        $(document).on("click", ".btn_tambah", function () {
            $('#tampil_form').load("<?= route('history.cuti.form.tambah') ?>", function () {
                $('#modal_form').modal('show');
                $("#modal_form .title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-biru");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on("click", "#btn_new_input", function () {
            $('#form_tambah :input').prop("disabled", false);
            $('#form_tambah #id_karyawan').val(null).trigger('change');
            $('#form_tambah #saldo').val('');
            $('#form_tambah #keterangan').val('');

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click", ".btn_save", function (e) {
            e.preventDefault();
            $('#modal_form #message').html("");
            const loading = Ladda.create(this);

            if (!$("#form_tambah #saldo").val()) {
                $('#modal_form #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jumlah_saldo') ?></font>");
                $('#form_tambah #saldo').focus();
                return false;
            }

            loading.start();

            let param = {};
            param.tambahSaldo = $("#form_tambah #tambahSaldo").is(":checked");
            param.kurangSaldo = $("#form_tambah #kurangSaldo").is(":checked");
            param.id_karyawan = "<?= $this->route->param('id_karyawan'); ?>";
            param.saldo = $("#form_tambah #saldo").val();
            param.keterangan = $("#form_tambah #keterangan").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('history.cuti.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function (result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_tambah :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }

                        list_data.ajax.reload();
                        list_data2.ajax.reload();

                    }
                    loading.stop();
                    $('#modal_form #message').show();
                    $('#modal_form #message').html(result.message);
                },
                error: function () {
                    loading.stop();
                    $('#modal_form #message').show();
                    $('#modal_form #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

    });
</script>
<style type="text/css">
    p {
        text-align: justify;
    }
</style>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> <?= strtoupper($this->lang->line('button_tambah_data')) ?>
                </button>
                <a href="<?= route('master.saldocuti.index') ?>" class="btn btn-secondary" title="KEMBALI">
                    <i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?>
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-4 font-weight-bold"><?= ucwords(strtolower($this->lang->line('nama'))) ?></div>
                        <div class="col-md-8">: <?= $karyawan->nama_lengkap ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 font-weight-bold"><?= $this->lang->line('nik') ?></div>
                        <div class="col-md-8">: <?= $karyawan->nik ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 font-weight-bold"><?= $this->lang->line('jabatan') ?></div>
                        <div class="col-md-8">: <?= $karyawan->nama_jabatan ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 font-weight-bold"><?= $this->lang->line('cabang') ?></div>
                        <div class="col-md-8">: <?= $karyawan->kode_cabang . ' - ' . $karyawan->nama_cabang ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 font-weight-bold"><?= $this->lang->line('departemen') ?></div>
                        <div class="col-md-8">: <?= $karyawan->kode_departemen . ' - ' . $karyawan->nama_departemen ?></div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-5 font-weight-bold"><?= $this->lang->line('saldo_cuti_saat_ini') ?></div>
                        <div class="col-md-7">: <?= $karyawan->jatah_cuti ?></div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 font-weight-bold"><?= $this->lang->line('saldo_cuti_carry_forward') ?></div>
                        <div class="col-md-7">: <?= $karyawan->carry_forward ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group row">
                        <label class="col-md-1 font-weight-bold text-uppercase">Tahun</label>
                        <div class="col-md-3">
                            <input type="text" id="filter_tahun" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <button type="button" id="btn_filter_tahun" class="btn btn-primary btn-block ladda-button" data-style="expand-left">FILTER</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-6">
                    <h4 style="text-align: center;">PENAMBAHAN SALDO CUTI</h4>
                    <div class="table-responsive">
                        <table id="list_data" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('tgl') ?></th>
                                    <th class="text-left text-uppercase"><?= $this->lang->line('keterangan') ?></th>
                                    <th class="text-center text-uppercase">JUMLAH</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="col-md-6">
                    <h4 style="text-align: center;">SALDO CUTI TERPAKAI</h4>
                    <div class="table-responsive">
                        <table id="list_data2" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= $this->lang->line('tgl') ?></th>
                                    <th class="text-left text-uppercase"><?= $this->lang->line('keterangan') ?></th>
                                    <th class="text-center text-uppercase">JUMLAH</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>