<div id="form_save" class="row">
  <input type="hidden" id="id_departemen" value="">
  <input type="hidden" id="kode_temp" value="">
  <input type="hidden" id="nama_temp" value="">
  <div class="form-group m-0 col-md-3 col-12 mb-1">
    <input type="text" class="form-control" placeholder="Kode Departemen (ex MKT)" id="kode">
  </div>
  <div class="form-group m-0 col-md-3 col-12 mb-1">
    <input type="text" class="form-control" placeholder="Nama Departemen (ex MARKETING)" id="nama">
  </div>
  <div id="btn_tambah_baru" class="form-group m-0 col-md-3 col-12 mb-1" style="display: none;">
    <button type="button" class="btn btn-primary mr-1 col-md-6 col-6" onclick="tambah_baru()"> Tambah Baru </button>
  </div>
  <div id="btn_save" class="form-group m-0 col-md-3 col-12 mb-1">
    <button type="button" id="tambah" class="btn btn-biru mr-1 ladda-button col-md-4 col-6" data-style="expand-left" onclick="save()"> Simpan </button>
    <button type="button" class="btn btn-outline-biru col-md-4 col-5" onclick="cancel()"> Batal </button>
  </div>
  <div id="btn_update" class="form-group m-0 col-md-3 col-12 mb-1" style="display: none;">
    <button type="button" id="update" class="btn btn-warning mr-1 ladda-button col-md-4 col-6" data-style="expand-left" onclick="update()"> Update </button>
    <button type="button" class="btn btn-outline-biru col-md-4 col-5" onclick="cancel_update()"> Batal </button>
  </div>
  <div id="btn_hapus" class="form-group m-0 col-md-3 col-12 mb-1" style="display: none;">
    <button type="button" id="hapus" class="btn btn-danger mr-1 ladda-button col-md-4 col-6" data-style="expand-left" onclick="delete_data()"> Hapus </button>
    <button type="button" class="btn btn-outline-biru col-md-4 col-5" onclick="cancel_hapus()"> Batal </button>
  </div>
</div>
<div class="row">
  <div class="col-md-6"></div>
  <div class="col-md-6">
    <div id="message"></div>
  </div>
</div>
<script type="text/javascript">
function save() {
  $('#message').html("");
  var loading = Ladda.create(document.querySelector('#tambah'));
  var kode    = $('#kode').val();
  var nama    = $('#nama').val();

  if(kode == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Kode departemen belum diisi</font>");
    $("#kode").focus();
    return false;
  } else if(nama == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama departemen belum diisi</font>");
    $("#nama").focus();
    return false;
  }

  loading.start();

  var param = {};
  param.kode = kode;
  param.nama = nama;

  $.ajax({
      type: 'POST',
      url: "<?= route('quick-setup.departemen.save') ?>",
      data: param,
      dataType:'JSON',
      success: function(result) {
          if(result.success == true) {
              if(result.type == 'save'){
                  $("#form_save input").prop("disabled", true);
                  $('#btn_save').hide();
                  $('#btn_tambah_baru').show();
              }
          }
          loading.stop();
          $('#message').show();
          $('#message').html(result.message);
      },
      error:function(){
          loading.stop();
          $('#message').show();
          $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
      }
  });
}

function update() {
  $('#message').html("");
  var loading       = Ladda.create(document.querySelector('#update'));
  var kode          = $('#kode').val();
  var nama          = $('#nama').val();
  var kode_temp     = $('#kode_temp').val();
  var nama_temp     = $('#nama_temp').val();
  var id_departemen = $('#id_departemen').val();

  if(kode == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Kode departemen belum diisi</font>");
    $("#cabang").focus();
    return false;
  } else if(nama == '') {
    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama departemen belum diisi</font>");
    $("#radius").focus();
    return false;
  }

  loading.start();

  var param           = {};
  param.kode          = kode;
  param.nama          = nama;
  param.id_departemen = id_departemen;
  param.kode_temp     = kode_temp;
  param.nama_temp     = nama_temp;

  $.ajax({
      type: 'POST',
      url: "<?= route('quick-setup.departemen.update') ?>",
      data: param,
      dataType:'JSON',
      success: function(result) {
          if(result.success == true){
              if(result.type == 'update'){
                  $("#form_save input").val('');
                  $('#btn_update').hide();
                  $('#btn_save').show();
              }

          }
          loading.stop();
          $('#message').show();
          $('#message').html(result.message);
      },
      error:function(){
          loading.stop();
          $('#message').show();
          $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
      }
  });
}

function delete_data() {
  $('#message').html("");
  var loading       = Ladda.create(document.querySelector('#hapus'));
  var id_departemen = $('#id_departemen').val();

  loading.start();

  var param           = {};
  param.id_departemen = id_departemen;

  $.ajax({
      type: 'POST',
      url: "<?= route('quick-setup.departemen.delete') ?>",
      data: param,
      dataType:'JSON',
      success: function(result) {
          if(result.success == true){
            $('#form_save input').prop('disabled', false);
            $('#btn_hapus').hide();
            $('#btn_save').show();
            cancel();
          }
          loading.stop();
          $('#message').show();
          $('#message').html(result.message);
      },
      error:function(){
          loading.stop();
          $('#message').show();
          $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
      }
  });
}

function edit(id_departemen) {
  detail(id_departemen);
  $('#form_save input').prop('disabled', false);
  $('#btn_save, #btn_tambah_baru, #btn_hapus').hide();
  $('#btn_update').show();
  $('#form_save').focus();
}

function hapus(id_departemen) {
  detail(id_departemen);
  $('#form_save').focus();
  $('#form_save input').prop('disabled', true);
  $('#btn_save, #btn_update, #btn_tambah_baru').hide();
  $('#btn_hapus').show();
}

function detail(id_departemen) {
  $('#message').html("");
  $('#id_departemen').val(id_departemen);

  $.get('<?= route("quick-setup.departemen.detail") ?>/'+id_departemen, function(result) {
    $('#kode').val(result.kode);
    $('#kode_temp').val(result.kode);
    $('#nama').val(result.nama);
    $('#nama_temp').val(result.nama);
  }, 'json');
}

function tambah_baru() {
  $("#form_save input").prop("disabled", false);
  cancel();
  $('#btn_tambah_baru').hide();
  $('#btn_save').show();
}

function cancel_update() {
  cancel();
  $('#btn_update').hide();
  $('#btn_save').show();
}

function cancel_hapus() {
  cancel();
  $('#form_save input').prop('disabled', false);
  $('#btn_hapus').hide();
  $('#btn_save').show();
}

function cancel() {
  $('#form_save input').val('');
}
</script>
