<script type="text/javascript">
    $(function() {
        $("#form_input #bulan").inputmask({
            'alias': 'datetime',
            'inputFormat': 'mm-yyyy'
        });
        $("#form_input #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true
        });

        $('#form_input #id_karyawan').select2({
            placeholder: 'Pilih Karyawan',
            ajax: {
                url: '<?= route("dropdown.karyawan.encrypt") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });

        // auto focus 'nominal gapok' when select 'karyawan'
        $('#id_karyawan').on('select2:select', function(e) {
            $('#nominal_gapok').focus();
            // set --
            $('#id_k').val(e.params.data.id);
        });

    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input" class="card-body" disabled>
    <input type="hidden" name="id_k" id="id_k" class="form-control" value="<?= ((isset($data)) ? md5($data->id_karyawan) : '') ?>">

    <?php
    $id_karyawan = ((isset($data->id_karyawan)) ? $data->id_karyawan : '');
    if (empty($id_karyawan)) {
    ?>
        <div class="form-group">
            <label>Nama Karyawan<i class="text-danger">*</i></label>
            <select id="id_karyawan" class="custom-select form-control" style="width:100%"></select>
        </div>
    <?php
    } else {
    ?>
        <div class="form-group">
            <label>Nama Karyawan</label><br>
            <label><b><?= ((isset($data)) ? $data->nik . " - " . $data->nm_karyawan : "") ?></b></label>
        </div>
    <?php
    }
    ?>

    <div class="form-group">
        <label>Nominal Gapok<i class="text-danger">*</i></label>
        <div class="input-group">
            <div class="input-group-prepend">
                <span class="input-group-text">Rp</span>
            </div>
            <input type="text" name="nominal_gapok" id="nominal_gapok" class="form-control" oninput="format_amount($(this))" value="<?= ((isset($data)) ? number_format($data->nominal, 0, ",", ".") : '') ?>">
        </div>
    </div>

    <div class="form-group mt-3">
        <h6 class="font-weight-bold" style="color: #1c77d4;">Diikutsertakan Hitungan</h6>
        <hr>
        <div class="row">
            <div class="col-md-5 my-auto">
                <label>Potongan Absensi<i class="text-danger">*</i></label>
            </div>
            <div class="col-md-3">
                <label>
                    <input type="radio" name="flag_pot_absensi" value="0" <?= ((isset($data) && $data->flag_pot_absensi == "0") ? "checked" : ((!isset($data)) ? "checked" : "")) ?>>
                    <span class="text">Tidak</span>
                </label>
            </div>
            <div class="col-md-4">
                <label>
                    <input type="radio" name="flag_pot_absensi" value="1" <?= ((isset($data) && $data->flag_pot_absensi == "1") ? "checked" : "") ?>>
                    <span class="text">Ya</span>
                </label>
            </div>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
