<?php

class Notif_kepegawaian_m extends CI_Model {
    
    # BEGIN DATA TABLE TABS
    function get_datatables($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $status="0", $jenis_kelamin,$id_karyawan="0", $order_by="default"){
        $this->_get_datatables_query($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan, $order_by);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $status="0", $jenis_kelamin,$id_karyawan="0", $order_by="default"){
        $this->_get_datatables_query($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan, $order_by);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $status="0", $jenis_kelamin,$id_karyawan="0", $order_by="default"){
        $this->_get_datatables_query($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan, $order_by);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($jenis=null, $id_cabang="0", $id_departemen="0", $id_jabatan="0", $status="0", $jenis_kelamin,$id_karyawan="0", $order_by="default"){

        if($status != "0"){
            $this->db->where("data_karyawan.status",$status);
        }

        if($id_karyawan != "0"){
            $this->db->where("data_karyawan.id_karyawan",$id_karyawan);
        }else{
            if($this->level_user == "7"){
                $this->db->group_start();
                $this->db->where("data_karyawan.supervisi",$this->id_karyawan);
                $this->db->or_where("data_karyawan.id_karyawan",$this->id_karyawan);
                $this->db->group_end();
            }
        }

        if($id_cabang != "0") {
            $this->db->where("data_karyawan.id_cabang",$id_cabang);
        }else{
            if($this->level_user == "5"){
                if($this->multi_cabang== true){
                    $this->db->where_in("data_karyawan.id_cabang",$this->id_cabang_arr);
                }else{
                    $this->db->where("data_karyawan.id_cabang",$this->id_cabang);
                }
            }else if($this->level_user == "2"){
                $this->db->where("data_karyawan.id_cabang",$this->id_cabang);
            }
        }

        if($id_departemen != "0") {
            $this->db->where("data_karyawan.id_departemen",$id_departemen);
        }else{
            if($this->level_user == "2"){
                if($this->multi_departemen == true){
                    $this->db->where_in("data_karyawan.id_departemen",$this->id_departemen_arr);
                }else{
                    $this->db->where_in("data_karyawan.id_departemen",$this->id_departemen);
                }
            }
        }

        if($id_jabatan != "0") {
            $this->db->where("data_karyawan.id_jabatan",$id_jabatan);
        }

        if($jenis_kelamin != "ALL") 
        {
            $this->db->where('data_karyawan.jenis_kelamin', $jenis_kelamin);
        }

        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nama_lengkap,
                            data_karyawan.nik,
							data_karyawan.foto,
                            data_karyawan.status,
                            master_cabang.nama as nama_cabang,
                            master_cabang.kode as kode_cabang,
                            master_departemen.nama as nama_departemen ,
                            master_departemen.kode as kode_departemen,
                            master_jabatan.nama as nama_jabatan,
                            master_jabatan.kode_jabatan as kode_jabatan,
                            master_jabatan.level_user,
                            data_karyawan.jatah_cuti,
                            data_karyawan.tgl_aktif_bekerja,
                            data_karyawan.tgl_berhenti_bekerja,
                            data_karyawan.jenis_kelamin,
                            data_karyawan.email,
                            data_karyawan.telepon,
                            data_karyawan.tempat_lahir,
                            data_karyawan.tgl_lahir,
                            data_karyawan.alamat_domisili,
                            data_karyawan.golongan_darah,
                            data_karyawan.agama");
        $this->db->from('data_karyawan');
        $this->db->join('notif_kepegawaian notif', 'notif.id_karyawan_pengajuan = data_karyawan.id_karyawan');
        $this->db->join('master_cabang', 'master_cabang.id_cabang = data_karyawan.id_cabang', 'LEFT');
        $this->db->join('master_departemen', 'master_departemen.id_departemen = data_karyawan.id_departemen', 'LEFT');
        $this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan', 'LEFT');
        $this->db->where('data_karyawan.id_company',$this->id_company);
        $this->db->where('notif.id_karyawan', $this->id_karyawan);
        $this->db->where('notif.jenis', 'pengajuan');
        $this->db->where('notif.flag_baca', '0');

        $column_search = array('master_cabang.nama','master_departemen.nama', 'data_karyawan.id_karyawan', 'data_karyawan.nama_lengkap');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','','data_karyawan.nama_lengkap','master_cabang.nama','master_departemen.nama','master_jabatan.nama', 'data_karyawan.status', 'data_karyawan.jenis_kelamin');
        $this->db->group_by('notif.id_karyawan_pengajuan');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            if($order_by == "default"){
                $order_by = array("data_karyawan.id_karyawan"=>"DESC");
                $this->db->order_by(key($order_by), $order_by[key($order_by)]);
            }else{
                $this->db->order_by("master_cabang.nama ASC, master_departemen.nama ASC, master_jabatan.nama ASC, data_karyawan.nik ASC");
            }
        }
    }
    # END DATA TABLE TABS

    function update_flag_baca($menu, $id_karyawan, $id_ref) 
    {
        $this->db->set('flag_baca', '1');
        $this->db->where('id_ref', $id_ref);
        $this->db->where('menu', $menu);
        $this->db->where('id_karyawan_pengajuan', $id_karyawan);
        $this->db->where('jenis', 'pengajuan');
        $this->db->where('flag_baca', '0');
        $this->db->update('notif_kepegawaian');
    }
}