<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pengaturan_lembur extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('pengaturan/approval/Pengaturan_lembur_m');
    }

	public function index(){
		$data['judul']   = $this->lang->line('pengaturan_approval_lembur');
		$data['aktif']   = 'pengaturan_lembur';
		$data['content'] = $this->load->view('pengaturan/approval/pengaturan_lembur/home', $data);
	}

	public function list_data(){
		$id_company = $this->session->userdata("id_company");
		$data['id'] = $id_company;
		if(!in_array($this->session->userdata('level_user'), array("1","4"))) {
			$id_cabang = $this->session->userdata("id_cabang");
			$this->db->where("id_cabang", $id_cabang);
		}

		$this->db->select("id_cabang")
				->from("p_approval_lembur")
				->where("id_company",$id_company)
				->group_by("id_cabang")
				->order_by("id_cabang ASC");

		$data['data'] = $this->db->get()->result();
		$this->load->view('pengaturan/approval/pengaturan_lembur/list_data', $data);
	}

	public function save(){
		$id           = $this->input->post('id_cabang');
		$company      = $this->session->userdata('id_company');
		$jumlah_level = $this->input->post("jumlah_level");
		
		for ($i = 1; $i <= $jumlah_level; $i++) {
			$level = $this->input->post('level_'.$id.'_'.$i.'-[]');
			$level_user = $this->input->post('level_user_'.$id.'_'.$i);
			$id_lembur = $this->input->post('id_'.$id.'_'.$i);

			if ($level == "" || $level == null) {
				$respons = array(
					'success'=>false,
					'message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>'.$this->lang->line('error_semua_diisi').'</font>'
				);

				echo json_encode($respons);
				exit;
			}

			$data_approv = implode(',', $level);
			// $nextIdLembur = $this->fungsi->getNextId('p_approval_lembur','id',$company,3);

			$data3 = array(
				'id_cabang'      => $id,
				'level_user'     => $level_user,
				'level_approval' => $data_approv,
				'id_company'     => $company,
				'tgl_update'     => date('Y-m-d h:i:s'),
				'user_update'    => $this->nik_karyawan." - ".$this->nm_karyawan
			);

			$this->db->where(array('id'=>$id_lembur, 'id_company'=>$this->id_company));
			$update = $this->db->update('p_approval_lembur', $data3);
			$this->logger->create_log('pengaturan_approval_lembur', 'edit', $this->db->last_query());
		}

		return  __response_update($update);
	}

	public function delete(){
		$id = $this->input->post("id");
		$this->Pengaturan_lembur_m->delete($id);
	}

}
