<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Master_komponen extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/Master_komponen_m', 'model');
    }

    public function index_pendapatan()
    {
        $data['judul']   = 'Master Komponen';
        $data['aktif']   = 'master_komponen';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/master_komponen/pendapatan', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function index_potongan()
    {
        $data['judul']   = 'Master Komponen';
        $data['aktif']   = 'master_komponen';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/master_komponen/potongan', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function index_kehadiran()
    {
        $data['judul']   = 'Master Komponen';
        $data['aktif']   = 'master_komponen';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/master_komponen/kehadiran', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($master = 'pendapatan')
    {
        $list = $this->model->get_datatables($master);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = '<i class="fa fa-sort" style="cursor: -webkit-grab; cursor: grab;" title="Tarik keatas / kebawah" data-key="' . $field->id_item . '"></i>';
            $row[] = $no;
            if ($master != 'kehadiran') {
                $row[] = $field->jenis_komponen;
            }
            $row[] = $field->nm_komponen;
            if ($field->jenis_komponen == 'tetap') {
                $row[] = ($field->flag_persentase_gapok == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
            } else {
                $row[] = '-';
            }
            $row[] = ($field->flag_persentase_gapok == '1') ? $field->gapok_persen . ' %' : '-';
            if ($master == 'kehadiran') {
                $row[] = ($field->flag_cuti == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                $row[] = ($field->flag_izin == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                $row[] = ($field->flag_sakit == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
            }
            if ($master != 'potongan') {
                if ($field->jenis_komponen == 'tetap') {
                    $row[] = ($field->flag_bpjs == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                    $row[] = ($field->flag_pph21 == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                    $row[] = ($field->flag_pot_absensi == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                    $row[] = ($field->flag_upah_lembur == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                } else {
                    $row[] = '-';
                    $row[] = ($field->flag_pph21 == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                    $row[] = ($field->flag_pot_absensi == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
                    $row[] = '-';
                }
            } else {
                $row[] = ($field->flag_pph21 == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
            }

            $btn_edit    = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_item) . '" class="btn_edit fa fa-edit (alias) "> </i></a>';
            $btn_hapus    = '<a href="javascript:void(0)" class="text-danger" title="HAPUS"><i id="' . md5($field->id_item) . '" class="btn_delete fa fa-trash"></i></a>';

            $row[]     = $btn_edit . ' ' . $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($master),
            "recordsFiltered" => $this->model->count_filtered($master),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($master = 'pendapatan', $id = null)
    {
        if ($id == null) {
            $data['master'] = $master;
            $this->load->view('payroll/master_komponen/form', $data);
        } else {
            $data['data'] = $this->model->getDataById($id, $master);
            $data['master'] = $master;
            $this->load->view('payroll/master_komponen/form', $data);
        }
    }

    public function save($master = 'pendapatan')
    {
        $flag_jenis       = $this->input->post('flag_jenis');
        $nm_komponen      = $this->input->post('nm_komponen');
        $flag_persentase  = $this->input->post('flag_persentase');
        $persentase       = $this->input->post('persentase');
        $flag_bpjs        = $this->input->post('flag_bpjs');
        $flag_pph21       = $this->input->post('flag_pph21');
        $flag_pot_absensi = $this->input->post('flag_pot_absensi');
        $flag_upah_lembur = $this->input->post('flag_upah_lembur');
        $flag_cuti        = $this->input->post('flag_cuti');
        $flag_izin        = $this->input->post('flag_izin');
        $flag_sakit       = $this->input->post('flag_sakit');

        $cek_nm_komponen = $this->db->where(['nm_komponen' => $nm_komponen, 'jenis_master' => $master, 'id_company' => $this->id_company])->get('payroll_komponen_m')->num_rows();
        if ($cek_nm_komponen > 0) {
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama komponen telah digunakan.</font>'];
            return __response_save(false, $message);
        }

        $data = array(
            'jenis_master'          => $master,
            'jenis_komponen'        => $flag_jenis,
            'nm_komponen'           => trim($nm_komponen),
            'flag_persentase_gapok' => $flag_persentase,
            'gapok_persen'          => $persentase,
            'flag_bpjs'             => ($master != 'potongan' && $flag_jenis == 'tetap') ? $flag_bpjs : '0',
            'flag_pph21'            => $flag_pph21 ?: '0',
            'flag_pot_absensi'      => ($master != 'potongan') ? $flag_pot_absensi : '0',
            'flag_upah_lembur'      => ($master != 'potongan' && $flag_jenis == 'tetap') ? $flag_upah_lembur : '0',
            'flag_cuti'             => ($master == 'kehadiran') ? $flag_cuti : '0',
            'flag_izin'             => ($master == 'kehadiran') ? $flag_izin : '0',
            'flag_sakit'            => ($master == 'kehadiran') ? $flag_sakit : '0',
            'no_urut'               => 0,
        );

        $this->model->save($data, $master);
    }

    public function update($master = 'pendapatan')
    {
        $jenis            = $this->input->post('jenis');             // tetap / tidak tetap
        $id_item          = $this->input->post('key');
        $flag_jenis       = $this->input->post('flag_jenis');
        $nm_komponen      = $this->input->post('nm_komponen');
        $last_nm_komponen = $this->input->post('last_nm_komponen');
        $flag_persentase  = $this->input->post('flag_persentase');
        $persentase       = $this->input->post('persentase');
        $flag_bpjs        = $this->input->post('flag_bpjs');
        $flag_pph21       = $this->input->post('flag_pph21');
        $flag_pot_absensi = $this->input->post('flag_pot_absensi');
        $flag_upah_lembur = $this->input->post('flag_upah_lembur');
        $flag_cuti        = $this->input->post('flag_cuti');
        $flag_izin        = $this->input->post('flag_izin');
        $flag_sakit       = $this->input->post('flag_sakit');

        $cek_nm_komponen = $this->db->where('MD5(id_item) !=', $id_item)
            ->where(['nm_komponen' => $nm_komponen, 'jenis_master' => $master, 'id_company' => $this->id_company])
            ->get('payroll_komponen_m')
            ->num_rows();

        if ($cek_nm_komponen > 0) {
            if ($nm_komponen != $last_nm_komponen) {
                $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama komponen telah digunakan.</font>'];
                return __response_save(false, $message);
            }
        }

        $data = array(
            'jenis_master'          => $master,
            'jenis_komponen'        => $flag_jenis,
            'nm_komponen'           => trim($nm_komponen),
            'flag_persentase_gapok' => $flag_persentase,
            'gapok_persen'          => $persentase,
            'flag_bpjs'             => ($master != 'potongan' && $flag_jenis == 'tetap') ? $flag_bpjs : '0',
            'flag_pph21'            => $flag_pph21 ?: '0',
            'flag_pot_absensi'      => ($master != 'potongan') ? $flag_pot_absensi : '0',
            'flag_upah_lembur'      => ($master != 'potongan' && $flag_jenis == 'tetap') ? $flag_upah_lembur : '0',
            'flag_cuti'             => ($master == 'kehadiran') ? $flag_cuti : '0',
            'flag_izin'             => ($master == 'kehadiran') ? $flag_izin : '0',
            'flag_sakit'            => ($master == 'kehadiran') ? $flag_sakit : '0',
        );

        $this->model->update($data, $master, $id_item, $jenis);
    }

    public function update_order()
    {
        $order = $this->input->post('order');

        $data = array();
        foreach ($order as $key) {
            $data[] = [
                'concat(id_item,id_company)' => $key['id_item'] . $this->id_company,
                'no_urut' => $key['no_urut']
            ];
        }
        $this->model->update_order($data);
    }

    public function delete($master = 'pendapatan', $bulan = null)
    {
        $id_item = $this->input->post('key');
        $this->model->delete($id_item, $master, $bulan);
    }
}
