<?php
defined('BASEPATH') or exit('No direct script access allowed');

class History_cuti extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('History_cuti_m', 'model');
    }

    public function index($id_karyawan = null)
    {
        $data['judul']       = $this->lang->line('title_history_cuti');
        $data['aktif']       = 'saldo_cuti';
        $data['karyawan']    = $this->model->getKaryawanByIdMd5($id_karyawan);
        $max_tgl_cuti        = $this->model->max_tgl_cuti_karyawan($id_karyawan);
        $data['max_periode'] = $max_tgl_cuti;
        $data['min_periode'] = $max_tgl_cuti - 10;
        $data['menu']        = $this->load->view('main_menu', $data, true);
        $data['content']     = $this->load->view('saldo_cuti/history_cuti/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($jenis = null, $id_karyawan = null)
    {
        $tahun = $this->input->get('tahun');
        $list = $this->model->get_datatables($tahun, $jenis, $id_karyawan);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $row[] = date('d-m-Y', strtotime($field->tgl_trx));
            $row[] = $field->keterangan;
            $row[] = $field->tambah;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($tahun, $jenis, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($tahun, $jenis, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function list_data_terpakai($jenis = null, $id_karyawan = null)
    {
        $tahun = $this->input->get('tahun');
        $list = $this->model->get_datatables($tahun, $jenis, $id_karyawan);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $row[] = date('d-m-Y', strtotime($field->tgl_trx));
            $row[] = $field->keterangan;
            $row[] = $field->kurang;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($tahun, $jenis, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($tahun, $jenis, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form()
    {
        $this->load->view('saldo_cuti/history_cuti/form');
    }

    public function save()
    {
        $tambahSaldo = $this->input->post('tambahSaldo');
        $kurangSaldo = $this->input->post('kurangSaldo');
        $saldo       = $this->input->post('saldo');
        $keterangan  = $this->input->post('keterangan');
        $id_karyawan = $this->input->post('id_karyawan');
        $tambah      = 0;
        $kurang      = 0;
        if ($tambahSaldo === 'true') {
            $tambah = $saldo;
        } else if ($kurangSaldo === 'true') {
            $kurang = $saldo;
        }

        // cek karyawan
        $validate = $this->db->select('id_karyawan')
            ->where('id_company', $this->id_company)
            ->where('md5(id_karyawan)', $id_karyawan)
            ->get('data_karyawan');

        if ($validate->num_rows() == 0) {
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_karyawan_ditemukan') . '</font>';
            return __response_save(false, $message);
        }

        $data = array(
            'tgl_trx'     => date('Y-m-d'),
            'tambah'      => $tambah,
            'kurang'      => $kurang,
            'keterangan'  => $keterangan,
            'id_karyawan' => $validate->row()->id_karyawan,
            'user_input'  => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            'id_company'  => $this->id_company
        );

        $this->model->save($data);
    }
}
