<style>
    .icon_target_realisasi {
        border-radius: 10px;
        box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
        padding: 7px;
        flex: 0 0 auto;
        height: 45px;
        width: 45px;
    }
</style>

<script type="text/javascript">
    $(function() {
        cek_maximal_data_sales();
        dropdown_filter_group_area();

        $("#btn_filter").on("click", function() {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function() {
                loading.stop();
            });
        });

        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan/atasan'
                <?php else : ?> 'searchPlaceholder': 'Employees/superior name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('sales_activity.pengaturan.approval.atasan.list.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                    d.id_group_m = $(".filter #id_group_m").val() ? $(".filter #id_group_m").val() : 'all';
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(2)', nRow).css({
                    'text-align': 'left',
                    'width': '400px'
                });
                $('td:eq(4)', nRow).css({
                    'text-align': 'center',
                    'width': '100px'
                });
                $('td:eq(-1)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
            }
        });
    });

    function dropdown_filter_group_area(){
        var opsi_all = "no";
        $(".filter #id_group_m").select2({
            placeholder: "Semua Group",
            allowClear: true,
            // width: 'resolve',
            ajax: {
                url: '<?= route("sales_activity.master.dropdown.group.area") ?>' + '/' + opsi_all,
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-3 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Pengaturan <?= $this->lang->line('data_sales') ?></h5>
    </div>
    <div class="content-header-middle col-md-7 col-12">
        <div class="row">
            <?php
                if($this->is_sales_admin == true && !in_array($this->sales_admin_group, ["all", ""])){
                    $label_sales_aktiv = "Sales Group Saya";
                    $col_row_jumlah    = "col-md-4";
                }else{
                    $label_sales_aktiv = "Jumlah Sales Aktif";
                    $col_row_jumlah    = "col-md-5";
                }
            ?>

            <div class="<?= $col_row_jumlah ?>">
                <div class="row">
                    <div class="col-md-3">
                        <div class="icon_target_realisasi" style="background-color:#007aff;">
                            <img src="<?= $this->config->item('dir_assets') ?>images/icon/sale_active_icon.png" style="width:30px;height:30px;">
                        </div>
                    </div>
                    <div class="col-md-8">
                        <label><?= $label_sales_aktiv ?></label><BR>
                        <label id="data_sales_jumlah_sales_aktiv" class="font-weight-bold">-</label>
                    </div>
                </div>
            </div>
            
            <?php 
                if($this->is_sales_admin == true && !in_array($this->sales_admin_group, ["all", ""])){ 
            ?>
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="icon_target_realisasi" style="background-color:#007aff;">
                                    <img src="<?= $this->config->item('dir_assets') ?>images/icon/sale_active_icon.png" style="width:30px;height:30px;">
                                </div>
                            </div>
                            <div class="col-md-8">
                                <label>Sales Group Lain</label><BR>
                                <label id="data_sales_jumlah_sales_group_lain" class="font-weight-bold">-</label>
                            </div>
                        </div>
                    </div>
            <?php 
                } 
            ?>

            <div class="<?= $col_row_jumlah ?>">
                <div class="row">
                    <div class="col-md-3 pl-0 pr-0">
                        <div class="icon_target_realisasi" style="background-color:#ff9500;">
                            <img src="<?= $this->config->item('dir_assets') ?>images/icon/max_sale_icon.png" style="width:30px;height:30px;">
                        </div>
                    </div>
                    <div class="col-md-8 pl-0 p">
                        <label>Max Jumlah Sales</label><BR>
                        <label id="data_sales_maximal_sales" class="font-weight-bold">-</label>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="content-header-right col-md-2 col-12">
        <div id="div_tambah"></div>
    </div>
</div>
<hr>

<?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
    <div class="filter mt-2">
        <div class="row">
            <div class="col-md-1 align-self-center">
                <label class="font-weight-bold"><?=$this->lang->line('group_area'); ?></label>
            </div>
            <div class="col-md-4">
                <select class="form-control" id="id_group_m" style="width: 100%"></select>
            </div>
            <div class="col-md-1">
                <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
            </div>
        </div>
    </div>
<?php endif; ?>

<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle" width="20">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_karyawan') ?></th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_atasan') ?></th>
                
                <?php if($this->fungsi->cek_adm_satu_grup() == false) : ?>
                    <th class="text-center align-middle text-uppercase"><?= $this->lang->line('group_area') ?></th>
                <?php endif; ?>
                
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('perlu_approval') ?></th>
                <th class="text-center align-middle text-uppercase" width="50"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
