<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Habis_masa_kerja_m extends CI_Model {
    var $table = 'pkwt_data';
    public function __construct(){
		parent::__construct();
	}

    function get_datatables($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
        if($id_cabang != "all"){
            $this->db->where("dk.id_cabang", $id_cabang);
        }

        if($id_departemen != "all"){
            $this->db->where("dk.id_departemen", $id_departemen);
        }

        if($id_karyawan != "all"){
            $this->db->where('dk.id_karyawan', $id_karyawan);
        }
        
        $this->db->select(" dk.id_karyawan,
                            dk.nik,
                            dk.nama_lengkap,
                            dk.tgl_berhenti_bekerja,
                            mj.nama AS nama_jabatan,
                            group.level AS level_user,
                            mc.kode AS kode_cabang,
                            mc.nama AS nama_cabang,
                            md.kode AS kode_departemen,
                            md.nama AS nama_departemen")
                    ->from('data_karyawan AS dk')
                    ->join('master_jabatan AS mj', 'mj.id_jabatan = dk.id_jabatan')
                    ->join('usergroup AS group', 'group.id = mj.level_user')
                    ->join('master_cabang AS mc', 'mc.id_cabang = dk.id_cabang')
                    ->join('master_departemen AS md', 'md.id_departemen = dk.id_departemen', 'LEFT')
                    ->where("dk.id_company",$this->id_company)
                    // ->where("dk.id_karyawan NOT IN (SELECT id_karyawan FROM pkwt_data WHERE id_company = '" . $this->id_company . "' AND status != '3')")
                    ->where('dk.status', '1')
                    ->where_not_in('mj.level_user',['1','6']);

        // $tgl_awal   = date('Y-m-d H:i:s');
        $tgl_akhir  = date('Y-m-d H:i:s', strtotime('+1 month'));
        $this->db->group_start();
        // $this->db->where('dk.tgl_berhenti_bekerja >=', $tgl_awal);
        $this->db->where('dk.tgl_berhenti_bekerja <=', $tgl_akhir);
        $this->db->group_end();

        $column_search = array('nik');
        $i = 0;

        foreach ($column_search as $item){
            if($_GET['search']['value']){

                if($i===0){
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','nik');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("dk.tgl_berhenti_bekerja"=>"ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id){
        $this->db->select(" dk.id_karyawan,
                            dk.nik,
                            dk.nama_lengkap,
                            dk.tempat_lahir,
                            dk.tgl_lahir,
                            dk.tgl_berhenti_bekerja,
                            dk.alamat_domisili,
                            mj.kode_jabatan,
                            mj.nama AS nama_jabatan,
                            usergroup.level AS nama_level_user,
                            mc.nama AS nama_cabang,
                            md.nama AS nama_departemen");
        $this->db->from("data_karyawan AS dk");
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->join("usergroup","usergroup.id = mj.level_user");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang");
        $this->db->join("master_departemen AS md","md.id_departemen = md.id_departemen", 'LEFT');
        $this->db->join("pkwt_gaji_m AS gaji","gaji.id_karyawan = dk.id_karyawan", 'LEFT');
        $this->db->where("MD5(dk.id_karyawan)",$id);
        $this->db->where("dk.id_company",$this->id_company);

        $query = $this->db->get();
        return $query->row();
    }
}