<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Master_lembur_karyawan_import_m extends CI_Model
{
    protected $table = 'payroll_lembur_m_temp';

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }

    private function _get_datatables_query()
    {
        $this->db->select('
            lm.id_lembur_m_temp,
            dk.id_karyawan,
            dk.nama_lengkap as nama,
            IF(dk.nik IS NULL, lm.id_karyawan, dk.nik) as nik,
            mc.nama as cabang,
            md.nama as departemen,
            lm.lembur_hari_kerja,
            lm.lembur_libur_off,
            lm.lembur_libur_nasional,
            lm.lembur_libur_khusus
        ')
            ->from($this->table . ' lm')
            ->join('data_karyawan dk', 'dk.id_karyawan = lm.id_karyawan', 'left')
            ->join('master_cabang mc', 'mc.id_cabang = dk.id_cabang', 'left')
            ->join('master_departemen md', 'md.id_departemen = dk.id_departemen', 'left')
            ->where('lm.id_company', $this->id_company)
            ->order_by('mc.kode ASC, md.kode ASC, dk.nik ASC');
    }

    public function getDataGagalImport(): array
    {
        $query = $this->db->select('id_karyawan')
            ->from($this->table)
            ->where('id_company', $this->id_company)
            ->where('LEFT(id_karyawan, 1) = "#"')
            ->get()
            ->result();
        $data = [];
        foreach ($query as $value) {
            $data[] = $value->id_karyawan;
        }
        return $data;
    }

    public function getMasterLembur($by_kode = false): array
    {
        $query = $this->db->select('id_lembur_p, kode, keterangan')
            ->from('payroll_lembur_p')
            ->where('id_company', $this->id_company)
            ->get()
            ->result();

        $data = [];
        foreach ($query as $value) {
            $data[($by_kode ? $value->kode : $value->id_lembur_p)] = [
                'id_lembur_p' => $value->id_lembur_p,
                'kode'        => $value->kode,
                'keterangan'  => $value->keterangan
            ];
        }

        return $data;
    }

    public function getNextId(string $tableName, string $fieldName, string $id_company, int $lengthNumber): string
    {
        $current_year = date('Y');
        $len_substring = -4 - $lengthNumber;
        $gedId = $this->db->query("SELECT
                                        MAX($fieldName) as id
                                    FROM $tableName
                                    WHERE
                                        id_company = '$id_company'
                                        AND SUBSTRING($fieldName,$len_substring,4) = '$current_year'
                                    FOR UPDATE");

        $nextId =  $id_company . $current_year . sprintf("%0" . $lengthNumber . "d", 1);
        if ($gedId->num_rows() > 0) {
            $current_id = substr($gedId->row()->id, "-" . $lengthNumber);
            $nextId =  $id_company . $current_year . sprintf("%0" . $lengthNumber . "d", ($current_id + 1));
        }

        return $nextId;
    }

    public function getDataKaryawan($id_cabang = 'all', $id_departemen = 'all')
    {
        if ($id_cabang != 'all') $this->db->where("data_karyawan.id_cabang", $id_cabang);
        if ($id_departemen != 'all') $this->db->where("data_karyawan.id_departemen", $id_departemen);

        $this->db->select('
            data_karyawan.id_karyawan,
            payroll_lembur_m.lembur_hari_kerja,
            payroll_lembur_m.lembur_libur_off,
            payroll_lembur_m.lembur_libur_nasional,
            payroll_lembur_m.lembur_libur_khusus,
            data_karyawan.nama_lengkap as nama,
            data_karyawan.nik,
            master_cabang.id_cabang,
            master_cabang.nama as cabang,
            master_departemen.id_departemen,
            master_departemen.nama as departemen
        ')
            ->from('data_karyawan')
            ->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan')
            ->join('master_cabang', 'master_cabang.id_cabang = data_karyawan.id_cabang')
            ->join('master_departemen', 'master_departemen.id_departemen = data_karyawan.id_departemen', 'left')
            ->join('payroll_lembur_m', 'payroll_lembur_m.id_karyawan = data_karyawan.id_karyawan', 'left')
            ->where('data_karyawan.id_company', $this->id_company)
            ->where_in('data_karyawan.status', ['1', '2', '3', '4'])
            ->where_not_in('master_jabatan.level_user', ['1', '6'])
            ->order_by('master_cabang.kode ASC, master_departemen.kode ASC, data_karyawan.nama_lengkap ASC, data_karyawan.nik ASC');
        $query = $this->db->get()->result();
        $data = [];
        foreach ($query as $value) {
            $data[$value->nik] = [
                'id_karyawan'           => $value->id_karyawan,
                'nik'                   => $value->nik,
                'nama'                  => $value->nama,
                'id_cabang'             => $value->id_cabang,
                'cabang'                => $value->cabang,
                'id_departemen'         => $value->id_departemen,
                'departemen'            => $value->departemen,
                'lembur_hari_kerja'     => $value->lembur_hari_kerja,
                'lembur_libur_off'      => $value->lembur_libur_off,
                'lembur_libur_nasional' => $value->lembur_libur_nasional,
                'lembur_libur_khusus'   => $value->lembur_libur_khusus
            ];
        }

        return $data;
    }
}
