<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jadwal_m extends CI_Model {
    var $table = 'patroli_jadwal';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables($cabang = null){
        $this->_get_datatables_query($cabang);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($cabang = null){
        $this->_get_datatables_query($cabang);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($cabang = null){
        $this->_get_datatables_query($cabang);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($cabang = null){
        $this->db->select("pj.id,
                            pj.id_cabang,
                            pj.nm_jadwal,
                            pj.min_absen, 
                            pj.max_absen, 
                            pj.id_company,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,")
                ->from($this->table. ' as pj')
                ->join("master_cabang","master_cabang.id_cabang = pj.id_cabang");
        $this->db->where('pj.id_company',$this->id_company);
        if($cabang != null) {
            $this->db->where("pj.id_cabang", $cabang);
        }

        $column_search = array('nm_jadwal');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('nama_cabang','nm_jadwal','min_absen','max_absen');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            // $order_by = array("pj.tgl_input"=>"DESC");
            // $this->db->order_by(key($order_by), $order_by[key($order_by)]);
            $this->db->order_by("pj.id_cabang, pj.min_absen ASC");
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT pj.id,
                                            pj.id_cabang,
                                            pj.nm_jadwal,
                                            pj.min_absen, 
                                            pj.max_absen, 
                                            pj.id_company,
                                            master_cabang.kode as kode_cabang,
                                            master_cabang.nama as nama_cabang
                                    FROM $this->table as pj
                                    JOIN master_cabang ON master_cabang.id_cabang = pj.id_cabang
                                    WHERE MD5(id) = '$id'
                                    AND pj.id_company = '".$this->id_company."'")->row();
        return $select;
    }

    public function save($data,$id = null){
        if($id != null){
            $min_absen = $data['min_absen'];
            $max_absen = $data['max_absen'];
            $id_cabang = $data['id_cabang'];


            $cek_min = $this->db->query("SELECT min_absen 
                                        FROM $this->table as pj
                                        WHERE id_company = '$this->id_company'
                                        AND id_cabang = '$id_cabang'
                                        AND min_absen = '$min_absen'
                                        AND md5(id) != '$id'");

            $cek_max = $this->db->query("SELECT max_absen 
                                        FROM $this->table as pj
                                        WHERE id_company = '$this->id_company'
                                        AND id_cabang = '$id_cabang'
                                        AND max_absen = '$max_absen'
                                        AND md5(id) != '$id'");


            if ($cek_min->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jam Mulai sudah digunakan</font>');
                return __response_save(false,$message);
            }else if($cek_max->num_rows() > 0){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jam Selesai sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $this->db->where(array('md5(id)'=>$id, 'id_company'=>$this->id_company));
                $data['user_update'] = $this->nik_karyawan." - ".$this->nm_karyawan;
                $data['tgl_update']  = date('Y-m-d H:i:s');
                $update = $this->db->update($this->table,$data);
                return  __response_update($update);
            }

        }else{
            $min_absen = $data['min_absen'];
            $max_absen = $data['max_absen'];
            $id_cabang = $data['id_cabang'];

            $cek_min = $this->db->query("SELECT min_absen 
                                        FROM $this->table as pj
                                        WHERE id_company = '$this->id_company'
                                        AND id_cabang = '$id_cabang'
                                        AND min_absen = '$min_absen'");

            $cek_max = $this->db->query("SELECT min_absen 
                                        FROM $this->table as pj
                                        WHERE id_company = '$this->id_company'
                                        AND id_cabang = '$id_cabang'
                                        AND max_absen = '$max_absen'");

            if ($cek_min->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jam Mulai sudah digunakan</font>');
                return __response_save(false,$message);
            }else if($cek_max->num_rows() > 0){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jam Selesai sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id',$this->id_company,3);
                $data['id'] = $nextId;
                $data['user_input'] = $this->nik_karyawan." - ".$this->nm_karyawan;
                $save = $this->db->insert($this->table, $data);
                return __response_save($save);
            }
        }

    }

    public function delete($id=null){
        $this->db->where(array('md5(id)'=>$id, 'id_company'=>$this->id_company));
        $delete =$this->db->delete($this->table);
        return  __response_delete($delete);

    }

}