<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payroll_m extends CI_Model {
    public function __construct(){
        parent::__construct();
        $this->id_company = $this->session->userdata('id_company');
        $this->nik        = $this->session->userdata('nik');
        $this->nama_user  = $this->session->userdata('nama_user');
    }

    public function get_data_diri_by_id($id_karyawan) {
        $this->db->select('
            nik,
            nama_lengkap,
            tanggungan,
            npwp,
            jml_anak,
            bank_atas_nama,
            bank_rek,
            bank_nama
        ');
        $this->db->from('data_karyawan');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row();
    }

    public function get_gapok_by_id($id_karyawan) {
        $this->db->select('nominal');
        $this->db->from('payroll_gapok_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->nominal;
    }

    public function get_tunj_tetap_by_id($id_karyawan) {
        $this->db->select('id_item, nm_tunjangan, flag_persentase_gapok, nominal_tunjangan');
        $this->db->from('payroll_tunj_tetap_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->order_by('no_urut', 'asc');
        return $this->db->get();
    }

    public function get_ttl_tunj_tetap_by_id($id_karyawan) {
        $this->db->select_sum('nominal_tunjangan');
        $this->db->from('payroll_tunj_tetap_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->nominal_tunjangan;
    }

    public function get_pot_bpjs_kes_by_id($id_karyawan) {
        $this->db->select('pot_kry_rp');
        $this->db->from('payroll_bpjs_kes_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->pot_kry_rp;
    }

    public function get_tunj_bpjs_kes_by_id($id_karyawan) {
        $this->db->select('tunj_perus_rp');
        $this->db->from('payroll_bpjs_kes_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->tunj_perus_rp;
    }

    public function get_pot_bpjs_tk_by_id($id_karyawan) {
        $this->db->select('
        pot_jht_kry_rp,
        flag_jht,
        pot_jp_kry_rp,
        flag_jp');
        $this->db->from('payroll_bpjs_tk_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row();
    }

    public function get_pot_tetap_by_id($id_karyawan) {
        $this->db->select('id_item, nm_potongan, flag_persentase_gapok, nominal_potongan');
        $this->db->from('payroll_pot_tetap_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->order_by('no_urut', 'asc');
        return $this->db->get();
    }

    public function get_ttl_pot_bpjs_tk_by_id($id_karyawan) {
        $this->db->select('(pot_jht_kry_rp+pot_jp_kry_rp) as total', FALSE);
        $this->db->from('payroll_bpjs_tk_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->total;
    }

    public function get_ttl_tunj_bpjs_tk_by_id($id_karyawan) {
        $this->db->select('(tunj_jht_perus_rp+tunj_jkk_rp+tunj_jp_perus_rp+tunj_jkm_rp) as total', FALSE);
        $this->db->from('payroll_bpjs_tk_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->total;
    }

    public function get_ttl_pot_tetap_by_id($id_karyawan) {
        $this->db->select_sum('nominal_potongan');
        $this->db->from('payroll_pot_tetap_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        $this->db->order_by('no_urut', 'asc');
        return $this->db->get()->row()->nominal_potongan;
    }

    public function get_data_by_data_karyawan($id, $id_karyawan) {
        $this->db->select($id);
        $this->db->from('data_karyawan');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->$id;
    }

    public function get_data_by_gapok($id, $id_karyawan) {
        $this->db->select('nominal');
        $this->db->from(id_map_table($id));
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row()->nominal;
    }

    public function get_data_by_tunj_pot($id, $id_karyawan, $id_item) {
        if($id == 'tunjtetap') {
            $this->db->select('nm_tunjangan, nominal_tunjangan');
        } else {
            $this->db->select('nm_potongan, nominal_potongan');
        }
        $this->db->from(id_map_table($id));
        $this->db->where('md5(id_item)', $id_item);
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get()->row();
    }

    public function save($name, $temp, $value, $id_karyawan) {
        if($value == '' or ($name == 'npwp' and strlen($value) < 19)) {
            return false;
        } else {
            if($temp == $value) {
                if($name == 'gapok') {
                    $this->db->trans_start();
                    $this->update_tunj_tetap($id_karyawan, $value);
                    $this->update_pot_tetap($id_karyawan, $value);
                    $this->db->trans_complete();
                    return $this->db->trans_status();
                } else {
                    return true;
                }
            } else {
                if(in_array($name, ['tanggungan', 'npwp', 'bank_atas_nama', 'bank_rek', 'bank_nama'])) {
                    return $this->update_data_karyawan($name, $temp, $value, $id_karyawan);
                } elseif($name == 'jml_anak') {
                    return $this->update_jml_anak($name, $temp, $value, $id_karyawan);
                } elseif($name == 'gapok') {
                    $cek_gapok = $this->cek_gapok($id_karyawan);
                    if($cek_gapok > 0) {
                        $this->db->trans_start();
                        $this->update_gapok($name, $temp, $value, $id_karyawan);
                        $this->update_gapok_log($temp, $value, $id_karyawan);
                        $this->update_tunj_tetap($id_karyawan, $value);
                        $this->update_pot_tetap($id_karyawan, $value);
                        $this->db->trans_complete();
                        return $this->db->trans_status();
                    } else {
                        $this->db->trans_start();
                        $this->insert_gapok($value, $id_karyawan);
                        $this->insert_gapok_log($value, $id_karyawan);
                        $this->db->trans_complete();
                        $status          = $this->db->trans_status();
                        $id_karyawan_dec = $this->fungsi->decrypt_idkaryawan($id_karyawan);
                        if($status) {
                            $CI =& get_instance();
                            $CI->load->model('Data_diri_m');
                            $CI->db->trans_start();
                            $CI->Data_diri_m->insert_tunj_tetap($id_karyawan_dec);
                            $CI->Data_diri_m->insert_pot_tetap($id_karyawan_dec);
                            $CI->db->trans_complete();
                            if($CI->db->trans_status() == FALSE) {
                                $this->db->trans_rollback();
                                return false;
                            } else {
                                $this->db->trans_commit();
                                return $this->db->trans_status();
                            }
                        }
                    }
                } else {
                    $temp_name = explode("_", $name);
                    $table     = $temp_name[0];
                    $id_item   = $temp_name[1];
                    return $this->update_tunj_pot($table, $value, $id_karyawan, $id_item);
                }
            }
        }
    }

    private function update_tunj_pot($table, $value, $id_karyawan, $id_item) {
        if($table == 'tunjtetap') {
            $this->db->set('nominal_tunjangan', $value);
        } else {
            $this->db->set('nominal_potongan', $value);
        }
        $this->db->set('user_update', $this->nik.'-'.$this->nama_user);
        $this->db->set('tgl_update', date('Y-m-d H:i:s'));
        $this->db->where('md5(id_item)', $id_item);
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);

        return $this->db->update(id_map_table($table));
    }

    private function update_jml_anak($name, $temp, $value, $id_karyawan) {
        $CI =& get_instance();
        $CI->load->model('payroll/bpjs/Bpjs_kes_m');

        $this->db->trans_start();
        $this->update_data_karyawan($name, $temp, $value, $id_karyawan);
        $cek_bpjs_kes = $CI->Bpjs_kes_m->cek_data($id_karyawan, TRUE);
        if($cek_bpjs_kes > 0) {
            $CI->db->trans_start();
            $CI->Bpjs_kes_m->hitung_bpjs_kes_pot_kry($id_karyawan, $value);
            $CI->Bpjs_kes_m->update_total_pot_kry($id_karyawan);
            $CI->db->trans_complete();
            if($CI->db->trans_status() == false) {
                $this->db->trans_rollback();
                return false;
            } else {
                $this->db->trans_commit();
                return $this->db->trans_status();
            }
        } else {
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
    }

    private function update_data_karyawan($name, $temp, $value, $id_karyawan) {
        $this->db->set($name, $value);
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->update('data_karyawan');
    }

    private function update_gapok($name, $temp, $value, $id_karyawan) {
        $this->db->set('nominal', $value);
        $this->db->set('user_update', $this->nik.'-'.$this->nama_user);
        $this->db->set('tgl_update', date('Y-m-d H:i:s'));
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->update('payroll_gapok_m');
    }

    public function cek_gapok($id_karyawan) {
        $this->db->from('payroll_gapok_m');
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->count_all_results();
    }

    public function insert_gapok($value, $id_karyawan) {
        $data = [
            'nominal'     => $value,
            'id_karyawan' => $this->fungsi->decrypt_idkaryawan($id_karyawan),
            'id_company'  => $this->id_company,
            'user_input'  => $this->nik.'-'.$this->nama_user
        ];
        $this->db->insert('payroll_gapok_m', $data);
    }

    public function insert_gapok_log($value, $id_karyawan) {
        $data = [
            'id_company'   => $this->id_company,
            'id_karyawan'  => $this->fungsi->decrypt_idkaryawan($id_karyawan),
            'action'	   => 'tambah',
            'nominal_lama' => '0',
            'nominal_baru' => $value,
            'user_input'   => $this->nik.'-'.$this->nama_user
        ];
        $this->db->insert('payroll_gapok_log', $data);
    }

    private function update_gapok_log($temp, $value, $id_karyawan) {
        $data = [
            'id_company'   => $this->id_company,
            'id_karyawan'  => $id_karyawan,
            'action'	   => 'edit',
            'nominal_lama' => $temp,
            'nominal_baru' => $value,
            'user_input'   => $this->nik.'-'.$this->nama_user
        ];
        $this->db->insert('payroll_gapok_log', $data);
    }

    private function update_tunj_tetap($id_karyawan, $value) {
        $CI =& get_instance();
        $CI->load->model('Data_diri_m');

        $id_karyawan_dec = $this->fungsi->decrypt_idkaryawan($id_karyawan);
        $cek_tunj_tetap  = $this->Data_diri_m->cek_tunj_tetap($id_karyawan_dec);
        if($cek_tunj_tetap > 0) {
            $this->db->set('nominal_tunjangan', $value.'*(gapok_persen/100)', FALSE);
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_karyawan', $id_karyawan_dec);
            $this->db->where('flag_persentase_gapok', '1');
            $this->db->update('payroll_tunj_tetap_m');
        } else {
            $CI->Data_diri_m->insert_tunj_tetap($id_karyawan_dec);
        }
    }

    private function update_pot_tetap($id_karyawan, $value) {
        $CI =& get_instance();
        $CI->load->model('Data_diri_m');

        $id_karyawan_dec = $this->fungsi->decrypt_idkaryawan($id_karyawan);
        $cek_pot_tetap   = $this->Data_diri_m->cek_pot_tetap($id_karyawan_dec);
        if($cek_pot_tetap > 0) {
            $this->db->set('nominal_potongan', $value.'*(gapok_persen/100)', FALSE);
            $this->db->where('id_company', $this->id_company);
            $this->db->where('id_karyawan', $id_karyawan_dec);
            $this->db->where('flag_persentase_gapok', '1');
            $this->db->update('payroll_pot_tetap_m');
        } else {
            $CI->Data_diri_m->insert_pot_tetap($id_karyawan_dec);
        }
    }
}
