<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Divisi_model extends CI_Model
{

    var $table = 'master_company';
    var $column_order = array('nama'); //set column field database for datatable orderable
    var $column_search = array('nama'); //set column field database for datatable searchable just firstname , lastname , address are searchable
    var $order = array('id_company' => 'asc'); // default order 

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    private function _get_datatables_query()
    {
        
        $this->db->select('id_company, nama, flag_cabang');		
        $this->db->from($this->table);
		$this->db->where('id_induk = "'.$this->session->userdata('id_company').'"');

        $i = 0;

        foreach ($this->column_search as $item) { // loop column 
            if ($_POST['search']['value']) { // if datatable send POST for search
                if ($i === 0) { // first loop
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                } else {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if (isset($_POST['order'])) { // here order processing
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }
	
	public function dd_lok()
    {
        $result = $this->db->order_by('nama_kantor ASC')->get_where('data_lok_kantor', array('id_company' => $this->session->userdata('id_company')));
        $status[''] = 'Pilih Lokasi Kantor';
        if ($result->num_rows() > 0) {
            foreach ($result->result() as $row) {
                $status[$row->id_lok] = $row->nama_kantor;
            }
        }
        return $status;
    }

    //pengecekan apakah admin pusat
    public function cek_admin_pusat() {
		//cek apakah admin pusat atau admin yang memiliki id karyawan
		$id_karyawan = $this->db->query("SELECT id_karyawan FROM user WHERE id = '".$this->session->userdata('id_user')."'");
		if(isset($id_karyawan->row()->id_karyawan)){
			$flag_cabang = $this->db->query("SELECT flag_cabang FROM master_company WHERE id_company = '".$this->session->userdata('id_company')."'");
			$jumlah_cabang = $this->db->query("SELECT id_induk FROM master_company WHERE id_induk = '".$this->session->userdata('id_company')."'")->num_rows();
			//jika cabang atau hanya satu cabang
			if($flag_cabang == '1' OR $jumlah_cabang == 1){
				$cek = 0;
			}else{
				$cek = 1;
			}
		}else{
			$cek = 1;
		}
        return $cek;
    }

    //get id_lok untuk admin lokal kantor lokal
    public function get_id_lok() {
        $this->db->select('id_lok');
        $this->db->from('user');
        $this->db->join('data_karyawan','user.id_karyawan = data_karyawan.id');
        $this->db->where('username', $this->session->userdata('username'));
        return $this->db->get()->row()->id_lok;
    }

    //get data lok kantor
    public function dataLokKantorUser() {
        $this->db->select('id_lok, nama_kantor, lat_asli, long_asli, jarak');
        $this->db->where('id_company', $this->session->userdata('id_company'));
        return $this->db->get('data_lok_kantor')->row();
    }
 }
