<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Detail extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('kpi/user/saya/home_m');
        $this->load->helper('kpi/kpi');
    }

    public function index($id)
    {
        $this->load->model('kpi/notif_m');

        $data['data'] = detailData($id);
        if($data['data']['terima']) {
            $this->notif_m->updateNotifApproval($data['data']);
        } else {
            $this->notif_m->updateNotifPublishTarget($data['data']);
        }
        $this->load->view('kpi/user/saya/detail/home', $data);
    }

    public function list_data()
    {
        $this->load->model('kpi/user/team/detail_m');
        $list   = $this->detail_m->get_datatables();
        $status = $this->detail_m->getDataTrx()->row()->status;

        $data       = array();
        $namaObject = '';
        $indek      = 0;
		foreach ($list as $field) {
			$row   = array();
			
            $row[]      = $field->nm_object == $namaObject ? '' : $field->nm_object;
            $namaObject = $field->nm_object != $namaObject ? $field->nm_object : $namaObject;

			$row[] = $field->nm_aspek_kinerja;
			$row[] = $field->target;
			$row[] = $field->bobot."%";
			$row[] = $field->poin_1;
			$row[] = $field->poin_2;
			$row[] = $field->poin_3;
			$row[] = $field->poin_4;
			$row[] = $field->poin_5;
			$row[] = $this->inputActual($field->actual_poin, $field->id_pi_trx, $indek, $status);
			$row[] = $this->inputBukti($field->actual_bukti, $status);

			$data[] = $row;
            $indek++;
		}

		$output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->detail_m->count_all(),
            "recordsFiltered" => $this->detail_m->count_filtered(),
            "data"            => $data
		);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    private function isIdUserInput() {
        return $this->id_karyawan == htmlentities($this->input->get('karyawan'));
    }

    private function isPeriodeInput($tahun = null, $bulan = null) {
        $periode     = $this->home_m->periodeActual($tahun, $bulan);
        $tglSekarang = date('Y-m-d');
        if($periode->num_rows() == 0) {
            return false;
        } else {
            if($periode->row()->periode_mulai <= $tglSekarang and $periode->row()->periode_selesai >= $tglSekarang) {
                return true;
            } else {
                return false;
            }
        }
    }

    private function inputBukti($bukti, $status) {
        if($this->isIdUserInput() and $this->isPeriodeInput() and $this->isStatusInput($status)) {
            return "<textarea class='form-control' name='bukti[]' rows='3'>$bukti</textarea>";
        } else {
            return $bukti;
        }
    }

    private function inputActual($poin, $id, $indek, $status) {
        if($this->isIdUserInput() and $this->isPeriodeInput() and $this->isStatusInput($status)) {
            return form_dropdown("actual[$indek]", selectActual(), $poin, "class='form-control text-center' style='width:70px !important' ").form_input(['name' => 'id[]', 'style' => 'display:none;'], $id);
        } else {
            return $poin == '0' ? '' : $poin;
        }
    }

    private function isStatusInput($status) {
        return in_array($status, ['6', '7']);
    }

    public function save($response = true) {
        $this->load->model('kpi/user/team/detail_m');
        
        $dataId     = $this->input->post('id');
        $dataActual = $this->input->post('actual');
        $dataBukti  = $this->input->post('bukti');

        $data = [];
        foreach($dataId as $key => $id) {
            $data[] = [
                'id_pi_trx'    => $id,
                'actual_poin'  => $dataActual[$key],
                'actual_bukti' => $dataBukti[$key]
            ];
        }
        $this->db->update_batch('kpi_aspek_kinerja_trx', $data, 'id_pi_trx');
        $status = $this->detail_m->getDataTrx()->row()->status;
        if($status == '6') {
            $this->home_m->setStatusDraft();
        }
        if($response) {
            __response_save(true);
        }
    }

    public function form() {
        $this->load->view('kpi/user/saya/detail/form');
    }

    public function form_terima() {
        $this->load->view('kpi/user/saya/detail/form_terima');
    }

    public function ajukan() {
        $this->load->model(['kpi/user/team/detail_m', 'kpi/notif_m']);
        $this->load->helper(['generateid', 'kpi/notif', 'kpi/response']);

        $id_atasan = $this->detail_m->getDataTrx()->row()->id_atasan;

        $this->db->trans_start();
        $this->save(false);

        $this->db->set('status', '1');
        $this->db->set('tgl_pengajuan', date('Y-m-d'));
        $this->db->set('time_pengajuan', date('H:i:s'));
        $this->db->set('user_update', "$this->nik_karyawan - $this->nm_karyawan");
        $this->db->set('tgl_update', date('Y-m-d H:i:s'));
        $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
        $this->db->where('tahun', htmlentities($this->input->post('tahun')));
        $this->db->where('bulan', htmlentities($this->input->post('bulan')));
        $this->db->update('kpi_trx');
        
        $this->notif_m->insertNotifAjukanActual($id_atasan);
        $this->db->trans_complete();
        $status = $this->db->trans_status();

        if($status) {
            ajukanActual($id_atasan);
        }
        __response_pengajuan($status);
    }

    public function button($tahun, $bulan, $karyawan, $jenis) 
    {
        $this->load->model('kpi/user/team/detail_m');

        $data['isPeriodeInput'] = $this->isPeriodeInput($tahun, $bulan);
        $data['status']         = $this->detail_m->getDataTrx($tahun, $bulan, $karyawan)->row()->status;
        $this->load->view('kpi/user/saya/detail/button/'.$jenis, $data);
    }

    public function terima() {
        $this->load->model(['kpi/notif_m', 'kpi/user/team/detail_m']);
        $this->load->helper(['generateid', 'kpi/notif', 'kpi/response']);

        $data = [
            'status'       => '9',
            'ctt_diterima' => $this->input->post('keterangan'),
            'tgl_update'   => date('Y-m-d H:i:s'),
            'user_update'  => "$this->nik_karyawan - $this->nm_karyawan"
        ];
        $id_atasan = $this->detail_m->getDataTrx()->row()->id_atasan;
        $this->db->trans_start();

        $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
        $this->db->where('tahun', htmlentities($this->input->post('tahun')));
        $this->db->where('bulan', htmlentities($this->input->post('bulan')));
        $this->db->update('kpi_trx', $data);

        $this->notif_m->insertNotifTerima($id_atasan);
        $this->db->trans_complete();
        $status = $this->db->trans_status();
        if($status) {
            terimaKpi($id_atasan);
        }
        __response_accept($status);
    }
}