<script>
    function validateForm() {
        var jumlah = document.forms["form"]["jarak"].value;
        var angka = /^[0-9]+$/;

        if (!jumlah.match(angka)) {
            alert("Inputan harus angka!");
            //from.no_hp.focus();
            return false;
        }
    }

    $(function() {
        $('#cabang').select2({
            placeholder: '<?= $this->lang->line('pilih_cabang') ?>',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    });
</script>

<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Master Data</a>
                        </li>
                        <li class="breadcrumb-item"><a href="#">Lokasi</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-lg-9">
                    <div id="map" style="width:100%; height:450px"></div>
                    <h5 style="color: red"><strong>*) Klik dua kali untuk memilih lokasi</strong></h5>
                    <script>
                        var theMarker = {};

                        var map = L.map('map').setView([<?= $data->lat_asli . ',' . $data->long_asli;  ?>], 10);

                        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                            attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
                        }).addTo(map);

                        theMarker = L.marker([<?= $data->lat_asli . ',' . $data->long_asli;  ?>]).addTo(map);

                        var searchControl = L.esri.Geocoding.geosearch().addTo(map);

                        var results = L.layerGroup().addTo(map);

                        searchControl.on('results', function(data) {
                            results.clearLayers();
                            for (var i = data.results.length - 1; i >= 0; i--) {
                                results.addLayer(L.marker(data.results[i].latlng));
                                map.removeLayer(results);
                            }
                        });

                        // get coordinate
                        map.on('dblclick',
                            function(e) {
                                var coord = e.latlng.toString().split(',');
                                var lat = coord[0].split('(');
                                var lng = coord[1].split(')');
                                if (theMarker != undefined || results != undefined) {
                                    map.removeLayer(theMarker);
                                    map.removeLayer(results);
                                };

                                //Add a marker to show where you clicked.
                                theMarker = L.marker([lat[1], lng[0]]).addTo(map);

                                document.getElementById("lat").value = lat[1];
                                document.getElementById("lng").value = lng[0];
                            });
                    </script>

                </div>

                <div class="col-lg-3">
                    <div class="form-group">
                        <label class="control-label" for="nama">Nama Lokasi</label>
                        <input type="text" name='kantor' id="kantor" class="form-control input-xlarge" value="<?php echo $data->nama_kantor ?>">
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="lat">Nama Cabang</label>
                        <select type="text" class="form-control select2" name="cabang" id="cabang">
                            <option value="<?= $data->id_cabang ?>" selected="selected"><?= $nama_cabang ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="lat">Latitude</label>
                        <input type="text" class="form-control gllpLatitude" name='lat' id='lat' onkeyup="this.value = this.value.replace(/[^0-9.-]/g, '')" value="<?php echo $data->lat_asli ?>">
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="lng">Longitude</label>
                        <input type="text" class="form-control gllpLongitude" name='lng' id='lng' onkeyup="this.value = this.value.replace(/[^0-9.]/g, '')" value="<?php echo $data->long_asli ?>">
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="lat">Radius</label>
                        <input type="text" class="form-control" name='jarak' id='jarak' onkeyup="this.value = this.value.replace(/[^0-9.]/g, '')" value="<?php echo $data->jarak ?>">
                        <small class="form-control-feedback">*) radius dalam meter</small>
                        <input type="hidden" name="flag" id="flag" value="<?= $data->flag ?>">
                        <input type="hidden" name='id_lok' id="id_lok" value="<?php echo $data->id_lokasi_kantor ?>">
                    </div>
                    <div class="form-group">
                        <div class="col-md-7 text-left">
                            <div id="message"></div>
                        </div>
                        <div class="input-control text-left">
                            <button class="btn btn-warning btn_save ladda-button" name='aksi' data-style="expand-left"><i class="fa fa-edit (alias)"></i> PERBARUI</button>
                            <a href="<?= site_url('master/lokasi') ?>" class="btn btn-secondary">KEMBALI</a>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).on("click", ".btn_save", function(e) {
        e.preventDefault();
        $('#message').html("");
        var loading = Ladda.create(this);

        if ($("#kantor").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama Lokasi belum diisi</font>");
            $("#kantor").focus();
            return false;
        } else if ($("#lat").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Latitude belum diiisi</font>");
            $('#lat').focus();
            return false;
        } else if ($("#lng").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Longitude belum diiisi</font>");
            $('#lng').focus();
            return false;
        } else if ($("#jarak").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Radius belum diiisi</font>");
            $('#jarak').focus();
            return false;
        }

        loading.start();

        var param = 'kantor=' + $("#kantor").val() +
            '&cabang=' + $("#cabang").val() +
            '&flag=' + $("#flag").val() +
            '&id_lok=' + $("#id_lok").val() +
            '&lat=' + $("#lat").val() +
            '&lng=' + $("#lng").val() +
            '&jarak=' + $("#jarak").val();

        $.ajax({
            type: 'POST',
            url: "<?= site_url('master/lokasi/update') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    });
</script>
