<script type="text/javascript">
    $(function() {
        // reconfigure();
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= site_url('master/cabang/list_data') ?>",
                "type": "GET"
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                }
                <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
                ?>, {
                        "aTargets": [4],
                        "bSortable": false
                    }

                <?php } ?>
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center'
                });
                $('td:eq(0)', nRow).css({
                    'width': '10px'
                });

                <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
                ?>

                    $('td:eq(4)', nRow).css({
                        'text-align': 'center'
                    });
                    $('td:eq(4)', nRow).css({
                        'width': '100px'
                    });

                <?php } ?>
            }

        });


        $(document).on('click', '.btn_tambah', function() {
            $('#tampil_form').load("<?= site_url('master/cabang/form/tambah') ?>", function() {

                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_edit', function() {
            $('#tampil_form').load("<?= site_url('master/cabang/form/edit/') ?>" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_perbarui') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_delete', function() {
            $('#tampil_form').load("<?php echo site_url('master/cabang/form/hapus/') ?>" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                $('#form_input input[type=text]').prop("disabled", true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click', '#btn_new_input', function() {
            $('#form_input input[type=text]').prop("disabled", false);
            $("#form_input input[type=text]").val('');

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click", ".btn_save", function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#kd_cabang").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_kode_cabang') ?></font>");
                $("#kd_cabang").focus();
                return false;
            } else if ($("#nm_cabang").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_cabang') ?></font>");
                $('#nm_cabang').focus();
                return false;
            }

            loading.start();

            var param = {};
            param.id_cabang = $("#id_cabang").val();
            param.flag = $("#flag").val();
            param.kd_cabang = $("#kd_cabang").val();
            param.nm_cabang = $("#nm_cabang").val();

            $.ajax({
                type: 'POST',
                url: "<?= site_url('master/cabang/save') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }

                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click', '.btn_hapus', function() {
            var loading = Ladda.create(this);
            loading.start();

            var param = {};
            param.id_cabang = $("#id_cabang").val();

            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('master/cabang/delete') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
            if (in_array($this->session->userdata('level_user'), array("1"))) {
            ?>
                <div class="float-md-right">
                    <button type="button" class="btn_tambah btn btn-biru">
                        <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
                    </button>
                </div>
            <?php
            }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left"><?= $this->lang->line('kode') ?></th>
                            <th class="text-left text-uppercase"><?= $this->lang->line('nama') ?></th>
                            <th class="text-left"><?= $this->lang->line('pusat_cabang') ?></th>
                            <?php
                            if (in_array($this->session->userdata('level_user'), array("1"))) {
                            ?>
                                <th class="text-center"><?= $this->lang->line('aksi') ?></th>
                            <?php
                            }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
