<?php

class Home_m extends CI_Model {

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $tahun    = htmlentities($this->input->get('tahun'));
        $bulan    = htmlentities($this->input->get('bulan'));
        $karyawan = htmlentities($this->input->get('karyawan'));
        $jenis    = htmlentities($this->input->get('jenis'));

        $this->db->select("kry.id_karyawan");
        $this->db->from('data_karyawan kry');
        $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan and trx.id_atasan = '".$this->id_karyawan."'");
        $this->db->where('trx.tahun', $tahun);
        $this->db->where('trx.bulan', $bulan);
        if($jenis == 'pengajuan') {
            $this->db->where_in('trx.status', ['1', '8']);
        } else {
            $this->db->where_in('trx.status', ['4', '9']);
        }
        $this->db->where("kry.id_company",$this->id_company);
        return $this->db->count_all_results();
    }
    
    private function _get_datatables_query() {
        $tahun    = htmlentities($this->input->get('tahun'));
        $bulan    = htmlentities($this->input->get('bulan'));
        $karyawan = htmlentities($this->input->get('karyawan'));
        $jenis    = htmlentities($this->input->get('jenis'));

        $this->db->select("kry.nama_lengkap, kry.nik, jab.nama as jabatan, trx.tahun, trx.bulan, trx.tgl_pengajuan, trx.status, kry.id_karyawan");
        $this->db->from('data_karyawan kry');
        $this->db->join('master_jabatan jab', 'kry.id_jabatan = jab.id_jabatan');
        $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan and trx.id_atasan = '".$this->id_karyawan."'");
        $this->db->where('trx.tahun', $tahun);
        $this->db->where('trx.bulan', $bulan);
        if($jenis == 'pengajuan') {
            $this->db->where_in('trx.status', ['1', '8']);
        } else {
            $this->db->where_in('trx.status', ['4', '9', '10']);
        }
        
        $this->db->where("kry.id_company",$this->id_company);
        if($karyawan != "") {
            $this->db->where('kry.id_karyawan', $karyawan);
        }

        $column_order = array(null,'kry.nama_lengkap','jab.nama');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("trx.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    function periodeApv($tahun = null, $bulan = null) {
        if($tahun == null) {
            $tahun = htmlentities($this->input->get('tahun'));
            $bulan = htmlentities($this->input->get('bulan'));
        }
        
        $this->db->select('tahun, bulan, periode_mulai, periode_selesai');
        $this->db->from('kpi_periode_approval_p');
        $this->db->where('bulan', $bulan);
        $this->db->where('tahun', $tahun);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get();
    }

    function setDraftApproval() {
        $status = $this->cekStatusTrx();
        if($status == '1') {
            // set draft
            $this->db->set('status', '8');
            $this->db->set('tgl_update', date('Y-m-d H:i:s'));
            $this->db->set('user_update', "$this->nik_karyawan - $this->nm_karyawan");
            $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
            $this->db->where('tahun', htmlentities($this->input->post('tahun')));
            $this->db->where('bulan', htmlentities($this->input->post('bulan')));
            $this->db->update('kpi_trx');
        }
    }

    private function cekStatusTrx() {
        $this->db->select('status');
        $this->db->from('kpi_trx');
        $this->db->where('id_karyawan', htmlentities($this->input->post('karyawan')));
        $this->db->where('tahun', htmlentities($this->input->post('tahun')));
        $this->db->where('bulan', htmlentities($this->input->post('bulan')));
        return $this->db->get()->row()->status;
    }

    public function setujui($id_karyawan, $tahun, $bulan) {
        $data = [
            'status'                 => '4',
            'tgl_approval'           => date('Y-m-d H:i:s'),
            'user_approval'          => $this->nik." - ".$this->nm_karyawan,
            'ctt_exiting_role'       => $this->input->post('existingRole'),
            'ctt_career_development' => $this->input->post('careerDev'),
            'tgl_update'             => date('Y-m-d H:i:s'),
            'user_update'            => "$this->nik_karyawan - $this->nm_karyawan",
        ];
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('tahun', $tahun);
        $this->db->where('bulan', $bulan);
        $this->db->update('kpi_trx', $data);
    }

}