<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Target_personil extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/pengaturan/Target_personil_m');
    }

    public function list_data(){
        $bulan      = $this->input->get('bulan');
        $id_group_m = $this->input->get('id_group_m');

        $list = $this->Target_personil_m->get_datatables($bulan, $id_group_m);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";

            if($this->fungsi->cek_adm_satu_grup() == false){
                $row[] = $field->nama_group . "<br><b>" . $field->kode_group . "</b>";
            }

            # ID
            if(empty($field->tahun) or empty($field->bulan)){
                $explode      = explode('-', $bulan);
                $field->bulan = $explode[0];
                $field->tahun = $explode[1];
            }
            $id = ($field->id_karyawan).($field->tahun).($field->bulan).($field->id_company);

            # NOMINAL VALUE & EDIT
            $edit_nominal = '<div id="' . MD5($id) . '" class="input-group nominal_edit pr-3 pl-3" style="display:none">
                                <input type="text" id="nominal_input" name="nominal" oninput="format_amount($(this))" class="form-control text-right" value="' . number_format($field->nominal, 0, ',', '.') . '">
                            </div>';
           
            $val_nominal = '<div id="' . MD5($id) . '" class="nominal_value">
                                <span>' . number_format($field->nominal, 0, ',', '.') . '</span>
                            </div>';

            $row[] = '<div class="div_nominal">' . $edit_nominal . $val_nominal . '</div>';
            
            # BUTTON ACTION
            $btn_action = ' <div class="div_action">
                                <a class="btn_edit"
                                    id="' . MD5($id) . '" 
                                    href="javascript:void(0)" 
                                    title="EDIT"
                                    onclick="edit(this)"> 
                                            <i  class="fa fa-edit (alias) text-warning"></i>
                                </a>
                                <a class="btn_save mr-1"
                                    id="' . MD5($id) . '" 
                                    data-status = "'.$field->action.'"
                                    data-id-karyawan = "'.$field->id_karyawan.'"
                                    data-tahun = "'.$field->tahun.'"
                                    data-bulan = "'.$field->bulan.'"
                                    data-id_group_m = "'.$field->id_group_m.'"
                                    href="javascript:void(0)"
                                    title="SAVE"
                                    style="display:none"
                                    onclick="save(this)"> 
                                            <i  class="fa fa-save (alias) text-primary"></i>
                                </a>
                                <a class="btn_batal"
                                    id="' . MD5($id) . '" 
                                    href="javascript:void(0)" 
                                    title="BATAL"
                                    style="display:none"
                                    onclick="batal(this)"> 
                                            <i  class="fa fa-close (alias) text-warning"></i>
                                </a>
                        </div>';

            $row[]  = $btn_action;
            $data[] = $row;
        }

        // TOTAL
        $target_bulanan        = $this->Target_personil_m->target_bulanan($bulan, $id_group_m);
        $total_target_personil = $this->Target_personil_m->total_target_personil($bulan, $id_group_m);
        $selisih               = $total_target_personil - $target_bulanan;

        $output = array(
            "target_bulanan"        => number_format($target_bulanan, 0, ", ", "."),
            "total_target_personil" => number_format($total_target_personil, 0, ", ", "."),
            "selisih"               => number_format($selisih, 0, ", ", "."),
            "draw"                  => $_GET['draw'],
            "recordsTotal"          => $this->Target_personil_m->count_all($bulan, $id_group_m),
            "recordsFiltered"       => $this->Target_personil_m->count_filtered($bulan, $id_group_m),
            "data"                  => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function save(){
        $id          = $this->input->post('id');
        $status      = $this->input->post('status');
        $id_karyawan = $this->input->post('id_karyawan');
        $tahun       = $this->input->post('tahun');
        $bulan       = $this->input->post('bulan');
        $nominal     = $this->input->post('nominal');
        $nominal     = str_replace('.', '', $nominal);
        $nominal     = preg_replace('/[^0-9]/', '', $nominal);

        $data = array(  
            'id_karyawan' => $id_karyawan,
            'bulan'       => $bulan,
            'tahun'       => $tahun,
            'nominal'     => $nominal,
            'id_company'  => $this->id_company
        );

        $this->Target_personil_m->save($data, $id, $status);
    }
}