<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TidakTetap extends MY_Controller{

	public function __construct(){
        parent::__construct();
        $this->load->model('payroll/tunjangan/TidakTetap_m');
    }

	public function index(){
		$data['judul'] 		= 'Tunjangan Tidak Tetap';
		$data['aktif'] 		= 'tunj_tdk_tetap';
        $data['menu'] 		= $this->load->view('main_menu', $data, true);
		$data['content'] 	= $this->load->view('payroll/tunjangan/tidak_tetap/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data($id_karyawan="all", $bulan="all"){
		$list = $this->TidakTetap_m->get_datatables($id_karyawan, $bulan);
		// echo $this->db->last_query();
		// exit;
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan."<br><b>".$field->nik."</b>";
			$row[] = $field->periode;
			$row[] = $field->nm_cabang."<br><b>".$field->kd_cabang."</b>";
			$row[] = $field->nm_jabatan."<br><b>".$field->kd_jabatan."</b>";
			$row[] = number_format($field->nominal,0,",",".");

			$btn_detail = ' <a href="' . route('payroll.tunjangan.tidak.tetap.detail') . "/" . md5($field->id_karyawan) . "/" . $field->periode . '" class="btn_detail text-primary" title="DETAIL">
								<i class="fa fa-info-circle (alias) "> </i>
							</a>';
			$row[] = $btn_detail;

			$data[] = $row;
		}

		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->TidakTetap_m->count_all($id_karyawan),
						"recordsFiltered" => $this->TidakTetap_m->count_filtered($id_karyawan),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		$this->load->view('payroll/tunjangan/tidak_tetap/form');
	}

	// BEGIN DETAIL STUB
	public function detail($id_karyawan="all", $bulan="all"){
		$data['judul'] 		= 'Detail';
		$data['aktif'] 		= 'tunj_tdk_tetap';
        $data['menu'] 		= $this->load->view('main_menu', $data, true);
		$data['detail_karyawan'] 	= $this->TidakTetap_m->get_datatables($id_karyawan, $bulan);
		if (empty($data['detail_karyawan'])) {
			$data['detail_karyawan'] 	= $this->TidakTetap_m->getDataKaryawan($id_karyawan);
		}
        $data['periode']    = $bulan;
		$data['content'] 	= $this->load->view('payroll/tunjangan/tidak_tetap/home_detail', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data_detail($id_karyawan=null, $bulan=null){
		$list = $this->TidakTetap_m->getItemTable($id_karyawan, $bulan);

		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nm_tunjangan;
			$row[] = ($field->flag_persentase_gapok == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
			$row[] = ($field->flag_persentase_gapok == '1') ? $field->gapok_persen.' %' : '-' ;
			$row[] = number_format($field->nominal,0,",",".");
			$row[] = ($field->flag_bpjs == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
			// $row[] = ($field->flag_pph21 == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
			$row[] = ($field->flag_pot_absensi == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';

			$btn_edit 	= '<a href="#" class="text-warning" title="EDIT"> <i id="'.md5($field->id_item).'" class="btn_edit fa fa-edit (alias) "> </i></a>';
			$btn_hapus 	= '<a href="#" class="text-danger" title="HAPUS"><i id="'.md5($field->id_item).'" class="btn_delete fa fa-trash"></i></a>';
			$row[] = $btn_edit . " " . $btn_hapus;

			$data[] = $row;
		}
        // print_r($data);
		// echo $this->db->last_query();
		// exit;
		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->TidakTetap_m->count_all($id_karyawan),
						"recordsFiltered" => $this->TidakTetap_m->count_filtered($id_karyawan),
						"data"            => (empty($data)) ? "" : $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form_detail($id=null){
		if(empty($id)){
			// tambah data
			$this->load->view('payroll/tunjangan/tidak_tetap/form_detail');
		}else{
			// edit data
			$data['data'] = $this->TidakTetap_m->getDataById($id);
			$this->load->view('payroll/tunjangan/tidak_tetap/form_detail', $data);
		}
	}

	public function save(){
        $id_karyawan = $this->input->post('id_karyawan');
		$data_karyawan = $this->TidakTetap_m->getDataKaryawan($id_karyawan);

		if(count($data_karyawan) > 0) {
			$nm_tunjangan = $this->input->post('nm_tunjangan');
            $flag_persentase = $this->input->post('flag_persentase');
            if ($flag_persentase == "1") {
                $persentase = $this->input->post('persentase');
                $gapok_rp = str_replace(".","",$this->input->post('gapok_rp'));
            }else{
                $persentase = '';
                $gapok_rp = '';
            }
            $nominal = $this->input->post('nominal');
            $flag_bpjs = $this->input->post('flag_bpjs');
            // $flag_pph21 = $this->input->post('flag_pph21');
            $flag_pot_absensi = $this->input->post('flag_pot_absensi');

			$data = array(
				'nm_tunjangan'	        => $nm_tunjangan,
				'flag_persentase_gapok'	=> $flag_persentase,
				'gapok_persen'	        => $persentase,
				'flag_bpjs'	            => $flag_bpjs,
				// 'flag_pph21'	        => $flag_pph21,
				'flag_pot_absensi'	    => $flag_pot_absensi,
				'gapok_rp'		        => $gapok_rp,
				'nominal_tunjangan'		=> str_replace(".","",$nominal)
			);

			$this->TidakTetap_m->save($data, $data_karyawan[0]->id_karyawan);
		}else{
			$message = "<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Karyawan tidak ditemukan</font>";
			return __response_save(false, array('message' => $message));
		}

	}

	public function delete(){
		$key = $this->input->post("key");
		$this->TidakTetap_m->delete($key);
	}
	// END DETAIL STUB

}
