<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Detail extends MY_Controller {
    public function __construct(){
		parent::__construct();
		$this->load->model('kpi/admin/master/kepribadian/Detail_m', 'model');
	}

    public function view_detail($id=""){
        $data['bobot']   = $this->model->getBobotById($id);
        $this->load->view('kpi/admin/master/kepribadian/detail/home', $data);
    }

    public function list_data()
    {
        $id_jabatan = $this->input->get('id_jabatan');
        $list       = $this->model->get_datatables($id_jabatan);

        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->personal_aspek;
            $row[] = $field->keterangan;
            $row[] = $field->bobot .' %';
            $row[] = $field->poin_1;
            $row[] = $field->poin_2;
            $row[] = $field->poin_3;
            $row[] = $field->poin_4;
            $row[] = $field->poin_5;

            if (in_array($this->level_user, array("1"))) {

                $row[] =    '<a href="javascript:void(0)" class="text-warning" title="EDIT">
                                <i id="'.md5($field->id_aspek_kepribadian_m).'"
                                    data-id_jabatan="'.$field->id_jabatan.'"
                                    data-nama_jabatan="'.$field->nama_jabatan.'" 
                                    class="btn_edit fa fa-edit (alias)"
                                    onclick="edit(this)">
                                </i>
                            </a>&nbsp;
                            <a href="javascript:void(0)" class="text-danger" title = "hapus" >
                                <i id="'.md5($field->id_aspek_kepribadian_m).'" 
                                    data-id_jabatan="'.$field->id_jabatan.'"
                                    data-nama_jabatan="'.$field->nama_jabatan.'" 
                                    class="btn_delete fa fa-trash"
                                    onclick="hapus_form(this)">
                                </i>
                            </a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($id_jabatan),
            "recordsFiltered" => $this->model->count_filtered($id_jabatan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        if ($id == null) {
            $this->load->view('kpi/admin/master/kepribadian/detail/form');
        } else {
            $data['data'] = $this->model->getDataById($id);
            $this->load->view('kpi/admin/master/kepribadian/detail/form', $data);
        }
    }

    public function save(){
        $id_kepribadian = $this->input->post('id_kepribadian');
        $personal_aspek = $this->input->post('personal_aspek');
        $keterangan     = $this->input->post('keterangan');
        $bobot          = $this->input->post('bobot');
        $id_jabatan     = $this->input->post('id_jabatan');

        $poin_1         = $this->input->post('poin_1');
        $poin_2         = $this->input->post('poin_2');
        $poin_3         = $this->input->post('poin_3');
        $poin_4         = $this->input->post('poin_4');
        $poin_5         = $this->input->post('poin_5');

        $data = array(
            'personal_aspek' => $personal_aspek,
            'keterangan'     => $keterangan,
            'bobot'          => $bobot,
            'id_jabatan'     => $id_jabatan,
            'poin_1'         => $poin_1,
            'poin_2'         => $poin_2,
            'poin_3'         => $poin_3,
            'poin_4'         => $poin_4,
            'poin_5'         => $poin_5,
            'id_company'     => $this->id_company
        );

        $this->model->save($data, $id_kepribadian);
    }

    public function delete(){
        $id = $this->input->post("id_kepribadian");
        $this->model->delete($id);
    }
}