<?php

class Notif_kepegawaian extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('notif_kepegawaian_m', 'model');
    }

    public function index()
    {
        $data['judul']   = 'Notif Kepegawaian';
        $data['aktif']   = 'kepegawaian';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('kepegawaian/notif/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($jenis = null, $id_cabang = "0", $id_departemen = "0", $id_jabatan = "0", $status = "0", $jenis_kelamin, $id_karyawan = "0")
    {
        $list = $this->model->get_datatables($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;">';
            $url = site_url('master/karyawan/detail/' . md5($field->id_karyawan));
            $row[] = '<a href="'.$url.'" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap .$notif_pengajuan. '</a>' . $field->nik;
            $row[] = isset($field->nama_cabang) ? $field->kode_cabang . " - " . $field->nama_cabang : "";
            $row[] = isset($field->nama_departemen) ? $field->kode_departemen . " - " . $field->nama_departemen : "-";
            $row[] = isset($field->nama_jabatan) ? $field->kode_jabatan . " - " . $field->nama_jabatan : "";
            $row[] = $this->fungsi->status_karyawan($field->status);
            $row[] = $this->fungsi->jkel($field->jenis_kelamin);

            $row[] = "<a href='$url' class='btn btn-primary' onclick='save_filter_session();'>Pilih</a>";

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }
}