<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('pengaturan.kepalacabang.data') ?>",
                                    "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        <?php
                                            if(in_array($this->session->userdata("level_user"),['1'])){
                                        ?>
                                                { "aTargets": [3], "bSortable": false }
                                        <?php
                                            }
                                        ?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            <?php
                                if(in_array($this->session->userdata("level_user"),['1'])){
                            ?>
                                    $('td:eq(3)', nRow).css({'text-align':'center','width':'20px'});
                            <?php
                                }
                            ?>
                    }
        
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= route('pengaturan.kepalacabang.form.edit') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);            
            loading.start();

            var id_karyawan = $("#id_karyawan").val();
            var arr = [];
            $.each($('#cabang option:selected'), function(i, v){
                if($(this).attr('locked') != 'locked'){
                    var cabang   = $(this).val();
                    arr.push({
                        cabang: cabang
                    });
                }
            });
        
            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.kepalacabang.update') ?>",
                data: {id_karyawan:id_karyawan,
                        data_cabang:arr},
                dataType:'JSON',
                success: function(result) {
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <!-- <div class="float-md-right">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </div> -->
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">NAMA KARYAWAN</th>
                            <th class="text-left">CABANG</th>
                            <?php
                                if(in_array($this->session->userdata("level_user"),['1'])){
                            ?>
                                    <th class="text-center">AKSI</th>
                            <?php
                                }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


