<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Data_absensi_m extends CI_Model
{
    var $table = 'r_absensi';
    public function __construct(){
		parent::__construct();

        $this->level_user           = $this->session->userdata('level_user');
        $this->id_company           = $this->session->userdata('id_company');
        $this->multi_cabang         = $this->session->userdata('multi_cabang');
        $this->id_cabang            = $this->session->userdata('id_cabang');
        $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
        $this->multi_departemen     = $this->session->userdata('multi_departemen');
        $this->id_departemen        = $this->session->userdata('id_departemen');
        $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
        $this->id_karyawan          = $this->session->userdata('id_karyawan');
	}

    function get_datatables($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0"){
        $limit = false;
        if(!empty($_POST['length']) && $_POST['length'] != -1) {
            $limit = true;
        }
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen, $limit);
        return $query->result();
    }

    function count_filtered($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0")
    {
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
        return $query->num_rows();
    }

    public function count_all($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0")
    {
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
        return $query->num_rows();
    }

    private function _get_datatables_query($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0", $limit=false)
    {

        $query_binding [] = $tanggal_mulai;
        $query_binding [] = $tanggal_selesai;

        $where_and = "";

        if($id_karyawan != "0"){
            $where_and = " AND dk.id_karyawan = ?";
            $query_binding[] = $id_karyawan;
        }else{
            if($this->level_user == "7"){
                $where_and = " AND (dk.supervisi = ? or dk.id_karyawan = ?) ";
                $query_binding[] = $this->id_karyawan;
                $query_binding[] = $this->id_karyawan;
            }
        }

        if($id_cabang != "0") {
            $where_and      .= " AND dk.id_cabang = ?";
            $query_binding[] = $id_cabang;
        }else{
            if($this->level_user == "5"){
                if($this->multi_cabang== true){
                    $where_and      .= " AND dk.id_cabang IN ?";
                    $query_binding[] = $this->id_cabang_arr;
                }else{
                    $where_and      .= " AND dk.id_cabang = ?";
                    $query_binding[] =$this->id_cabang;
                }
            }else if($this->level_user == "2"){
                $where_and      .= " AND dk.id_cabang = ?";
                $query_binding[] = $this->id_cabang;
            }
        }

        if($id_departemen != "0") {
            $where_and      .= " AND dk.id_departemen = ?";
            $query_binding[] = $id_departemen;
        }else{
            if($this->level_user == "2"){
                if($this->multi_departemen == true){
                    $where_and      .= " AND dk.id_departemen IN ?";
                    $query_binding[] = $this->id_departemen_arr;
                }else{
                    // $this->db->where('dk.id_departemen', $this->id_departemen);
                    $where_and      .= " AND dk.id_departemen = ?";
                    $query_binding[] = $this->id_departemen;
                }
            }
        }

        $where_search = "";
        $column_search = array('nama_karyawan','nik');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){  // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $where_search .= " AND (";
                    $where_search .= " nama_karyawan LIKE ? ";
                    $query_binding[] = "%".$_POST['search']['value']."%";
                }else{
                    $where_search .= " OR nik LIKE ? ";
                    $query_binding[] = "%".$_POST['search']['value']."%";
                }

                if(count($column_search) - 1 == $i){
                    $where_search .= " ) ";
                }
            }
            $i++;
        }

        if($limit){
            $where_limit = " LIMIT ".$_POST['start'].",".$_POST['length'];
        }else{
            $where_limit = " ";
        }

        $date_now = date('Y-m-d');

        if($tanggal_mulai == $date_now || $tanggal_selesai == $date_now){

            $sql = "SELECT *
            FROM (SELECT absensi_masuk.id_karyawan,
                        absensi_masuk.tgl_absen,
                        absensi_masuk.kode_absen as kode_absensi,
                        absensi_masuk.jam_absen as absen_masuk,
                        absensi_masuk.gmt as gmt_masuk,
                        absensi_masuk.lokasi_absen as lokasi_masuk,
                        absensi_masuk.keterangan as ket_absen_masuk,
                        istirahat_mulai.jam_absen as absen_ist_mulai,
                        istirahat_mulai.gmt as gmt_ist_mulai,
                        istirahat_mulai.lokasi_absen as lokasi_ist_mulai,
                        istirahat_mulai.keterangan as ket_ist_mulai,
                        istirahat_selesai.jam_absen as absen_ist_selesai,
                        istirahat_selesai.gmt as gmt_ist_selesai,
                        istirahat_selesai.lokasi_absen as lokasi_ist_selesai,
                        istirahat_selesai.keterangan as ket_ist_selesai,
                        absensi_pulang.jam_absen as absen_pulang,
                        absensi_pulang.gmt as gmt_pulang,
                        absensi_pulang.lokasi_absen as lokasi_pulang,
                        absensi_pulang.keterangan as ket_absen_pulang,
                        dk.nik,
                        dk.nama_lengkap as nama_karyawan,
                        master_cabang.kode as kode_cabang,
                        master_cabang.nama as nama_cabang,
                        master_departemen.kode as kode_departemen,
                        master_departemen.nama as nama_departemen,
                        master_jabatan.kode_jabatan,
                        master_jabatan.nama as nama_jabatan,
                        absensi_masuk.jenis_absen
                    FROM absensi_masuk
                    LEFT JOIN istirahat_mulai on istirahat_mulai.id_karyawan=absensi_masuk.id_karyawan AND istirahat_mulai.tgl_absen=absensi_masuk.tgl_absen
                    LEFT JOIN istirahat_selesai on istirahat_selesai.id_karyawan=absensi_masuk.id_karyawan AND istirahat_selesai.tgl_absen=absensi_masuk.tgl_absen
                    LEFT JOIN absensi_pulang on absensi_pulang.id_karyawan=absensi_masuk.id_karyawan AND absensi_pulang.tgl_absen=absensi_masuk.tgl_absen
                    LEFT JOIN data_karyawan  as dk on dk.id_karyawan=absensi_masuk.id_karyawan
                    LEFT JOIN master_cabang on master_cabang.id_cabang=dk.id_cabang
                    LEFT JOIN master_departemen on master_departemen.id_departemen=dk.id_departemen
                    LEFT JOIN master_jabatan on master_jabatan.id_jabatan=dk.id_jabatan
                    WHERE absensi_masuk.id_company = '$this->id_company'
                    AND absensi_masuk.tgl_absen = ? ".
                    $where_and.
                    " UNION ALL
                    SELECT dk.id_karyawan,
                        dk.tgl_absen,
                        dk.kode_absensi,
                        dk.absen_masuk,
                        dk.gmt_masuk,
                        dk.lokasi_masuk,
                        dk.ket_absen_masuk,
                        dk.absen_ist_mulai,
                        dk.gmt_ist_mulai,
                        dk.lokasi_ist_mulai,
                        dk.ket_ist_mulai,
                        dk.absen_ist_selesai,
                        dk.gmt_ist_selesai,
                        dk.lokasi_ist_selesai,
                        dk.ket_ist_selesai,
                        dk.absen_pulang,
                        dk.gmt_pulang,
                        dk.lokasi_pulang,
                        dk.ket_absen_pulang,
                        dk.nik,
                        dk.nama_karyawan,
                        dk.kode_cabang,
                        dk.nama_cabang,
                        dk.kode_departemen,
                        dk.nama_departemen,
                        dk.kode_jabatan,
                        dk.nama_jabatan,
                        dk.jenis_absen
                    FROM r_absensi as dk
                    WHERE dk.id_company = '$this->id_company'
                    AND dk.tgl_absen >= ?
                    AND dk.tgl_absen <= ? ".
                    $where_and.
                    " ) as absensi
            GROUP BY CONCAT(id_karyawan,tgl_absen)
            ORDER BY kode_cabang,kode_departemen,nik,tgl_absen ASC ".
            $where_limit;

            // echo $sql;
            // die();

            # MERGE ARRAY
            $binding = array_merge($query_binding,$query_binding);
            # HAPUS ARRAY PERTAMA
            unset($binding[0]);

            $query = $this->db->query($sql,$binding);
        }else{

            $sql = "SELECT dk.id_karyawan,
                            dk.tgl_absen,
                            dk.kode_absensi,
                            dk.absen_masuk,
                            dk.lokasi_masuk,
                            dk.ket_absen_masuk,
                            dk.absen_ist_mulai,
                            dk.lokasi_ist_mulai,
                            dk.ket_ist_mulai,
                            dk.absen_ist_selesai,
                            dk.lokasi_ist_selesai,
                            dk.ket_ist_selesai,
                            dk.absen_pulang,
                            dk.lokasi_pulang,
                            dk.ket_absen_pulang,
                            dk.nik,
                            dk.nama_karyawan,
                            dk.kode_cabang,
                            dk.nama_cabang,
                            dk.kode_departemen,
                            dk.nama_departemen,
                            dk.kode_jabatan,
                            dk.nama_jabatan,
                            dk.jenis_absen
                        FROM r_absensi as dk
                        WHERE dk.id_company = '$this->id_company'
                        AND dk.tgl_absen >= ?
                        AND dk.tgl_absen <= ? ".
                        $where_and.
                    " GROUP BY CONCAT(dk.id_karyawan, dk.tgl_absen)
                    ORDER BY dk.kode_cabang, dk.kode_departemen, dk.nik, dk.tgl_absen ASC ".
                    $where_limit;

                    $query = $this->db->query($sql, $query_binding);
        }
        return $query;
    }

    //download
    function download($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0"){
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
        $result = $query->result();

        $array = [];
        if ($result != null) {
            foreach ($result as $key => $value) {
                if (!isset($array[$value->id_karyawan])) {
                    $d['id_karyawan']       = $value->id_karyawan;
                    $d['nik']               = $value->nik;
                    $d['nama_karyawan']     = $value->nama_karyawan;
                    $d['kode_cabang']       = $value->kode_cabang;
                    $d['nama_cabang']       = $value->nama_cabang;
                    $d['kode_departemen']   = $value->kode_departemen;
                    $d['nama_departemen']   = $value->nama_departemen;
                    $d['kode_jabatan']      = $value->kode_jabatan;
                    $d['nama_jabatan']      = $value->nama_jabatan;

                    // $karyawan['data_karyawan'] = $d;
                    $array[$value->id_karyawan] = ['data_karyawan' => $d];
                }

                if (!isset($array[$value->id_karyawan]['data_absen'][$value->tgl_absen])) {
                    $a['tgl_absen']             = date('d-m-Y', strtotime($value->tgl_absen));
                    $a['kode_absensi']          = $value->kode_absensi;
                    $a['jenis_absen']           = $value->jenis_absen;

                    $a['absen_masuk']           = $this->validate($value->absen_masuk, 'jam', $value->jenis_absen);
                    $a['lokasi_masuk']          = $this->validate($value->lokasi_masuk);
                    $a['ket_absen_masuk']       = $this->validate($value->ket_absen_masuk);

                    $a['absen_ist_mulai']       = $this->validate($value->absen_ist_mulai, 'jam');
                    $a['lokasi_ist_mulai']      = $this->validate($value->lokasi_ist_mulai);
                    $a['ket_absen_ist_mulai']   = $this->validate($value->ket_absen_ist_mulai);

                    $a['absen_ist_selesai']     = $this->validate($value->absen_ist_selesai, 'jam');
                    $a['lokasi_ist_selesai']    = $this->validate($value->lokasi_ist_selesai);
                    $a['ket_absen_ist_selesai'] = $this->validate($value->ket_absen_ist_selesai);

                    $a['absen_pulang']          = $this->validate($value->absen_pulang, 'jam', $value->jenis_absen);
                    $a['lokasi_pulang']         = $this->validate($value->lokasi_pulang);
                    $a['ket_absen_pulang']      = $this->validate($value->ket_absen_pulang);
                    $array[$value->id_karyawan]['data_absen'][$value->tgl_absen] = $a;
                }
            }
        }

        // echo '<pre>' . var_export('jml karyawan : '.count($array), true) . '</pre>';
        // echo '<pre>' . var_export($array, true) . '</pre>';
        // exit;
        if (count($array) > 0) {
            $res = $array;
        } else {
            $res = null;
        }

        return $res;
    }

    private function validate($val, $tp = '', $oparam = '')
    {
        if (!empty($val) && $val !=='0000-00-00 00:00:00') {
            if ($tp == 'jam') {
                $jam = date('H:i:s', strtotime($val));
                if ($jam == '00:00') {
                    if ($oparam == 'reguler' || $oparam == 'shift') {
                        return $jam;
                    } else {
                        return '-';
                    }
                } else {
                    return $jam;
                }
            } else {
                return $val;
            }
        } else {
            return '-';
        }
    }

    public function getDataById($id_karyawan = null, $tgl_absensi = null){
        $date_now = date("Y-m-d");
        if($tgl_absensi == $date_now){
            $this->db->select("dk.nama_lengkap AS nama_karyawan,
                                am.tgl_absen,
                                am.jam_absen AS absen_masuk,
                                ap.jam_absen AS absen_pulang,
                                im.jam_absen AS absen_ist_mulai,
                                iss.jam_absen AS absen_ist_selesai,
                                dk.id_karyawan,
                                dk.id_cabang,
                                dk.id_departemen,
                                dk.id_jabatan,
                                dk.id_company,
                                am.jenis_absen,
                                am.kode_absen AS kode_absensi,
                                am.ket_kode");
            $this->db->join("data_karyawan AS dk","dk.id_karyawan = am.id_karyawan","LEFT");
            $this->db->join("istirahat_mulai AS im","im.id_karyawan = am.id_karyawan AND im.tgl_absen = am.tgl_absen","LEFT");
            $this->db->join("istirahat_selesai AS iss","iss.id_karyawan = am.id_karyawan AND iss.tgl_absen = am.tgl_absen","LEFT");
            $this->db->join("absensi_pulang AS ap","ap.id_karyawan = am.id_karyawan AND ap.tgl_absen = am.tgl_absen","LEFT");
            $this->db->where("am.tgl_absen",$tgl_absensi);
            $this->db->where("am.id_karyawan",$id_karyawan);
            $this->db->where("am.id_company",$this->id_company);
            $select = $this->db->get("absensi_masuk AS am");
        }else{
            $select = $this->db->select('nama_karyawan,
                                            tgl_absen,
                                            absen_masuk,
                                            absen_pulang,
                                            absen_ist_mulai,
                                            absen_ist_selesai,
                                            id_karyawan,
                                            id_cabang,
                                            id_departemen,
                                            id_jabatan,
                                            id_company,
                                            jenis_absen,
                                            kode_absensi,
                                            ket_kode')
                            ->where('id_karyawan', $id_karyawan)
                            ->where('tgl_absen', $tgl_absensi)
                            ->where('id_company', $this->id_company)
                            ->get('r_absensi');
        }
        $query = $select->row();
        return $query;
    }

    public function save($kode_absen, $id)
    {
        $data = array(
            'kode_absen' => $kode_absen
        );
        if ($kode_absen == 'A') {
            $data['bkd'] = '1';
        }
        $this->db->where('id_absensi_masuk', $id);
        $update = $this->db->update('absensi_masuk', $data);
        return  __response_update($update);
    }

    function list_karyawan($search = null){

        $this->db->select('data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            data_karyawan.id_company,
                            data_karyawan.id_cabang,
                            data_karyawan.id_departemen');
        $this->db->where('data_karyawan.id_company', $this->id_company);
        // $this->db->where_in('data_karyawan.status',['1','2','3','4']);

        // if($id_cabang != 0){
        //     $this->db->where('data_karyawan.id_cabang', $id_cabang);
        // }

        if($this->level_user == "5"){ # KEPALA CABANG
            if($this->multi_cabang == true){
                $this->db->where_in('data_karyawan.id_cabang', $this->id_cabang_arr);
            }else{
                $this->db->where('data_karyawan.id_cabang', $this->id_cabang);
            }
        }else if($this->level_user == "2"){ # KEPALA DEPARTEMEN
            if($this->multi_departemen == true){
                $this->db->where_in('data_karyawan.id_departemen', $this->id_departemen_arr);
            }else{
                $this->db->where('data_karyawan.id_departemen', $this->id_departemen);
            }
        }else if($this->level_user == "7"){ # SUPERVISI
            $this->db->where('data_karyawan.supervisi', $this->id_karyawan);
        }else if($this->level_user == "3"){ # STAFF
            $this->db->where('data_karyawan.id_karyawan', $this->id_karyawan);
        }

        $this->db->group_start();
        $this->db->like('data_karyawan.nama_lengkap', $search);
        $this->db->or_like('data_karyawan.nik', $search);
        $this->db->group_end();
        $this->db->order_by('data_karyawan.nama_lengkap', 'ASC');

        $result = $this->db->get('data_karyawan')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_karyawan,
                        'idcompany'=>$rows->id_company,
                        'idcabang'=>$rows->id_cabang,
                        'iddepartemen'=>$rows->id_departemen,
                        'text'=>$rows->nik." - ".$rows->nama_lengkap];
        }
        echo json_encode($json);
    }

    public function list_cabang($id = null, $search = null){

        $where = " id_company='$this->id_company' ";

        if($this->level_user == "5"){
            if($this->multi_cabang == true){
                $id_cabang = implode("','",$this->id_cabang_arr);
            }else{
                $id_cabang = $this->id_cabang;
            }

            $where .= " AND id_cabang IN('".$id_cabang."') ";
        }


        $select = "SELECT CONCAT(kode_cabang,' - ',nama_cabang) AS kode, id_cabang
                                    FROM (SELECT kode AS kode_cabang, nama AS nama_cabang, id_cabang
                                        FROM master_cabang
                                        WHERE ".
                                        $where.
                                        " AND (nama LIKE ? OR kode LIKE ?)
                                        UNION ALL
                                        SELECT kode_cabang,nama_cabang, id_cabang
                                        FROM r_absensi
                                        WHERE ".
                                        $where.
                                        " AND (nama_cabang LIKE ? OR kode_cabang LIKE ?)
                                        GROUP BY CONCAT(kode_cabang,' - ',nama_cabang)
                                        ) AS a
                                    GROUP BY kode
                                    ORDER BY nama_cabang ASC";

        $result = $this->db->query($select, array('%' . $search . '%', '%' . $search . '%', '%' . $search . '%', '%' . $search . '%'))->result();


        $json = [];
        //$json[] = ['id'=> 0, 'text'=>'Semua Cabang'];
        foreach ($result as $rows) {
            $json[] = ['id' => $rows->id_cabang, 'text' => $rows->kode];
        }
        echo json_encode($json);
    }

    public function list_departemen($id_cabang = null, $search = null){
        $where = " ";
        if(in_array($this->level_user, array("2"))){ # KEPALA DEPARTEMEN
            if($this->multi_departemen == true){
                $id_departemen = implode("','",$this->id_departemen_arr);
            }else{
                $id_departemen = $this->id_departemen;
            }

            $where = " AND dk.id_cabang = '".$this->id_cabang."' AND dk.id_departemen IN ('".$id_departemen."')";

        }else if(in_array($this->level_user, array("7"))){ # SUPERVISI
            $this->load->model('Db_model', 'db_model');
            $karyawan = $this->db_model->get("data_karyawan", "id_karyawan", ['supervisi' => $this->session->userdata('id_karyawan')])->result();

            $target_name_arr = array();
            foreach ($karyawan as $dat) {
                $target_name_arr[] = $dat->id_karyawan;
            }
            $target_id = implode("','", $target_name_arr);

            $where = " AND id_cabang = '".$this->id_cabang."' AND id_departemen = '".$this->id_departemen."' AND id_karyawan IN ('".$target_id."')";

        }else{
            $where = " AND id_cabang = '".$id_cabang."'";
        }
        $select = "SELECT CONCAT(kode_departemen,' - ',nama_departemen) AS kode, id_departemen, kode_departemen, nama_departemen
                                FROM (SELECT md.id_departemen, md.kode as kode_departemen, md.nama as nama_departemen
                                    FROM master_departemen as md
                                    JOIN data_karyawan as dk ON dk.id_departemen = md.id_departemen
                                    JOIN master_jabatan AS mj ON mj.id_jabatan = dk.id_jabatan
                                    WHERE md.id_company = '".$this->id_company."'
                                    AND mj.level_user NOT IN ('1','6') ".
                                    $where.
                                    " AND (md.kode LIKE ? OR md.nama LIKE ?)
                                    UNION ALL
                                    SELECT dk.id_departemen, dk.kode_departemen, dk.nama_departemen
                                    FROM r_absensi as dk
                                    WHERE dk.id_company = '".$this->id_company."' ".
                                    $where.
                                    " AND (dk.kode_departemen LIKE ? OR dk.nama_departemen LIKE ?)
                                    GROUP BY CONCAT(dk.kode_departemen,' - ',dk.nama_departemen)
                                    ) AS a
                                GROUP BY kode
                                ORDER BY kode_departemen ASC";

        $query = $this->db->query($select, array("%".$search."%", "%".$search."%", "%".$search."%", "%".$search."%"))->result();

        $json = [];
        foreach ($query as $rows) {
            $json[] = ['id' => $rows->id_departemen, 'text' => $rows->kode_departemen . ' - ' . $rows->nama_departemen];
        }

        echo json_encode($json);
    }

    function lokasi($jenis, $tanggal, $id_karyawan){
        $id_company = $_SESSION['id_company'];
        $date_now = date('Y-m-d');
        $ok = true;
        if($date_now == $tanggal){
            if($jenis == "masuk") {
                $this->db->select('DATE_FORMAT(absensi_masuk.tgl_absen, "%d-%m-%Y") as tanggal,
                                                absensi_masuk.jam_absen as jam_absen,
                                                absensi_masuk.lokasi_absen as lokasi_absen,
                                                absensi_masuk.timezone as timezone,
                                                absensi_masuk.gmt as gmt,
                                                absensi_masuk.keterangan as keterangan,
                                                absensi_masuk.latitude as latitude,
                                                absensi_masuk.longitude as longitude,
                                                absensi_masuk.foto as foto,
                                                data_karyawan.nama_lengkap as nama');
                $this->db->join('data_karyawan', 'absensi_masuk.id_karyawan = data_karyawan.id_karyawan');
                $this->db->where("absensi_masuk.tgl_absen", $tanggal);
                $this->db->where("absensi_masuk.id_karyawan", $id_karyawan);
                $this->db->where("absensi_masuk.id_company", $id_company);
                return $this->db->get("absensi_masuk")->row();

            }elseif ($jenis == "pulang") {
                $this->db->select('DATE_FORMAT(absensi_pulang.tgl_absen, "%d-%m-%Y") as tanggal,
                                                absensi_pulang.jam_absen as jam_absen,
                                                absensi_pulang.lokasi_absen as lokasi_absen,
                                                absensi_pulang.timezone as timezone,
                                                absensi_pulang.gmt as gmt,
                                                absensi_pulang.keterangan as keterangan,
                                                absensi_pulang.latitude as latitude,
                                                absensi_pulang.longitude as longitude,
                                                absensi_pulang.foto as foto,
                                                data_karyawan.nama_lengkap as nama');
                $this->db->join('data_karyawan', 'absensi_pulang.id_karyawan = data_karyawan.id_karyawan');
                $this->db->where("absensi_pulang.tgl_absen", $tanggal);
                $this->db->where("absensi_pulang.id_karyawan", $id_karyawan);
                $this->db->where("absensi_pulang.id_company", $id_company);
                return $this->db->get("absensi_pulang")->row();
            }elseif ($jenis == "istirahat_mulai") {
                $this->db->select('DATE_FORMAT(istirahat_mulai.tgl_absen, "%d-%m-%Y") as tanggal,
                                                istirahat_mulai.jam_absen as jam_absen,
                                                istirahat_mulai.lokasi_absen as lokasi_absen,
                                                istirahat_mulai.timezone as timezone,
                                                istirahat_mulai.gmt as gmt,
                                                istirahat_mulai.keterangan as keterangan,
                                                istirahat_mulai.latitude as latitude,
                                                istirahat_mulai.longitude as longitude,
                                                istirahat_mulai.foto as foto,
                                                data_karyawan.nama_lengkap as nama');
                $this->db->join('data_karyawan', 'istirahat_mulai.id_karyawan = data_karyawan.id_karyawan');
                $this->db->where("istirahat_mulai.tgl_absen", $tanggal);
                $this->db->where("istirahat_mulai.id_karyawan", $id_karyawan);
                $this->db->where("istirahat_mulai.id_company", $id_company);
                return $this->db->get("istirahat_mulai")->row();
            }elseif ($jenis == "istirahat_selesai") {
                $this->db->select('DATE_FORMAT(istirahat_selesai.tgl_absen, "%d-%m-%Y") as tanggal,
                                                istirahat_selesai.jam_absen as jam_absen,
                                                istirahat_selesai.lokasi_absen as lokasi_absen,
                                                istirahat_selesai.timezone as timezone,
                                                istirahat_selesai.gmt as gmt,
                                                istirahat_selesai.keterangan as keterangan,
                                                istirahat_selesai.latitude as latitude,
                                                istirahat_selesai.longitude as longitude,
                                                istirahat_selesai.foto as foto,
                                                data_karyawan.nama_lengkap as nama');
                $this->db->join('data_karyawan', 'istirahat_selesai.id_karyawan = data_karyawan.id_karyawan');
                $this->db->where("istirahat_selesai.tgl_absen", $tanggal);
                $this->db->where("istirahat_selesai.id_karyawan", $id_karyawan);
                $this->db->where("istirahat_selesai.id_company", $id_company);
                return $this->db->get("istirahat_selesai")->row();
            }else {
                $ok = false;
            }

        }else{
            if($jenis == "masuk") {
                $this->db->select('DATE_FORMAT(r_absensi.tgl_absen, "%d/%m/%Y") as tanggal, r_absensi.absen_masuk as jam_absen, r_absensi.lokasi_masuk as lokasi_absen, r_absensi.timezone_masuk as timezone, r_absensi.gmt_masuk as gmt, r_absensi.ket_absen_masuk as keterangan, r_absensi.lat_masuk as latitude, r_absensi.long_masuk as longitude, r_absensi.foto_masuk as foto, data_karyawan.nama_lengkap as nama');
            }elseif ($jenis == "pulang") {
                $this->db->select('DATE_FORMAT(r_absensi.tgl_absen, "%d/%m/%Y") as tanggal, r_absensi.absen_pulang as jam_absen, r_absensi.lokasi_pulang as lokasi_absen, r_absensi.timezone_pulang as timezone, r_absensi.gmt_pulang as gmt, r_absensi.ket_absen_pulang as keterangan, r_absensi.lat_pulang as latitude, r_absensi.long_pulang as longitude, r_absensi.foto_absen_pulang as foto, data_karyawan.nama_lengkap as nama');
            }elseif ($jenis == "istirahat_mulai") {
                $this->db->select('DATE_FORMAT(r_absensi.tgl_absen, "%d/%m/%Y") as tanggal, r_absensi.absen_ist_mulai as jam_absen, r_absensi.lokasi_ist_mulai as lokasi_absen, r_absensi.timezone_ist_mulai as timezone, r_absensi.gmt_ist_mulai as gmt, r_absensi.ket_ist_mulai as keterangan, r_absensi.lat_ist_mulai as latitude, r_absensi.long_ist_mulai as longitude, r_absensi.foto_ist_mulai as foto, data_karyawan.nama_lengkap as nama');
            }elseif ($jenis == "istirahat_selesai") {
                $this->db->select('DATE_FORMAT(r_absensi.tgl_absen, "%d/%m/%Y") as tanggal, r_absensi.absen_ist_selesai as jam_absen, r_absensi.lokasi_ist_selesai as lokasi_absen, r_absensi.timezone_ist_selesai as timezone, r_absensi.gmt_ist_selesai as gmt, r_absensi.ket_ist_selesai as keterangan, r_absensi.lat_ist_selesai as latitude, r_absensi.long_ist_selesai as longitude, r_absensi.foto_ist_selesai as foto, data_karyawan.nama_lengkap as nama');
            }else {
                $ok = false;
            }

            if ($ok) {
                $this->db->join('data_karyawan', 'r_absensi.id_karyawan = data_karyawan.id_karyawan');
                $this->db->where("r_absensi.tgl_absen", $tanggal);
                $this->db->where("r_absensi.id_karyawan", $id_karyawan);
                $this->db->where("r_absensi.id_company", $id_company);
                return $this->db->get("r_absensi")->row();
            } else {
                return null;
            }
        }

    }

    function update_r_absensi($kode_absen, $id)
    {
        $this->db->set('kode_absensi', $kode_absen);
        $this->db->where('id_absensi_masuk', $id);
        $this->db->update('r_absensi');
    }

    function nama_karyawan($id_karyawan)
    {
        return $this->db->select('nama_lengkap')
            ->where('id_karyawan', $id_karyawan)
            ->get('data_karyawan')->row()->nama_lengkap;
    }

    function nama_cabang($id_cabang)
    {
        return $this->db->select('nama')
            ->where('id_cabang', $id_cabang)
            ->get('master_cabang')->row()->nama;
    }

    function nama_departemen($id_departemen)
    {
        return $this->db->select('nama')
            ->where('id_departemen', $id_departemen)
            ->get('master_departemen')->row()->nama;
    }

    function cek_absensi_rekap($id_karyawan, $tanggal) {
		$this->db->select('r_absensi.id_karyawan');
		$this->db->from('r_absensi');
		$this->db->where('r_absensi.id_karyawan', $id_karyawan);
		$this->db->where('r_absensi.tgl_absen', $tanggal);
		return $this->db->get()->num_rows();
	}

	function cek_absensi_masuk($id_karyawan, $tanggal) {
		$this->db->select('absensi_masuk.id_karyawan');
		$this->db->from('absensi_masuk');
		$this->db->where('absensi_masuk.id_karyawan', $id_karyawan);
		$this->db->where('absensi_masuk.tgl_absen', $tanggal);
		return $this->db->get()->num_rows();
	}

	function cek_absensi_pulang($id_karyawan, $tanggal) {
		$this->db->select('id_karyawan');
		$this->db->from('absensi_pulang');
		$this->db->where('id_karyawan', $id_karyawan);
		$this->db->where('tgl_absen', $tanggal);
		return $this->db->get()->num_rows();
	}

	function cek_istirahat_mulai($id_karyawan, $tanggal) {
		$this->db->select('id_karyawan');
		$this->db->from('istirahat_mulai');
		$this->db->where('id_karyawan', $id_karyawan);
		$this->db->where('tgl_absen', $tanggal);
		return $this->db->get()->num_rows();
	}

	function cek_istirahat_selesai($id_karyawan, $tanggal) {
		$this->db->select('id_karyawan');
		$this->db->from('istirahat_selesai');
		$this->db->where('id_karyawan', $id_karyawan);
		$this->db->where('tgl_absen', $tanggal);
		return $this->db->get()->num_rows();
	}

	function update_absensi_masuk($data, $id_karyawan, $tanggal) {
		$this->db->where('absensi_masuk.id_karyawan', $id_karyawan);
		$this->db->where('absensi_masuk.tgl_absen', $tanggal);
		return $this->db->update('absensi_masuk', $data);
	}

	function insert_absensi_masuk($data) {
		return $this->db->insert('absensi_masuk', $data);
	}

	function update_absensi_pulang($data, $id_karyawan, $tanggal) {
		$this->db->where('absensi_pulang.id_karyawan', $id_karyawan);
		$this->db->where('absensi_pulang.tgl_absen', $tanggal);
		return $this->db->update('absensi_pulang', $data);
	}

	function insert_absensi_pulang($data) {
		return $this->db->insert('absensi_pulang', $data);
	}

	function insert_istirahat_mulai($data) {
		return $this->db->insert('istirahat_mulai', $data);
	}

	function insert_istirahat_selesai($data) {
		return $this->db->insert('istirahat_selesai', $data);
	}

	function update_istirahat_mulai($data, $id_karyawan, $tanggal) {
		$this->db->where('id_karyawan', $id_karyawan);
		$this->db->where('tgl_absen', $tanggal);
		return $this->db->update('istirahat_mulai', $data);
	}

	function update_istirahat_selesai($data, $id_karyawan, $tanggal) {
		$this->db->where('id_karyawan', $id_karyawan);
		$this->db->where('tgl_absen', $tanggal);
		return $this->db->update('istirahat_selesai', $data);
	}
}
