<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pengaturan_izin extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Pengaturan_izin_m');
        check_login();
    }

	public function index(){
		$data['judul'] = 'Pengaturan Approval Izin';
		$data['aktif'] = 'pengaturan_ijin';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan/pengaturan_izin/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$id_company = $this->session->userdata("id_company");
		$data['id'] = $id_company;
		if(!in_array($this->session->userdata('level_user'), array("1","4"))) {
			$id_cabang = $this->session->userdata("id_cabang");
			$this->db->where("id_cabang", $id_cabang);
		}

		$this->db->select("id_cabang")
				->from("p_approval_izin")
				->where("id_company", $id_company)
				->group_by("id_cabang");

		$data['data'] = $this->db->get()->result();

		$this->load->view('pengaturan/pengaturan_izin/list_data', $data); 
	}

	public function save(){
		$id = $this->input->post('id_cabang');
		$company = $this->session->userdata('id_company');

		$jumlah_level = $this->input->post("jumlah_level");
		
		for ($i = 1; $i <= $jumlah_level; $i++) { 

			$level = $this->input->post('level_'.$id.'_'.$i.'-[]');
			$level_user = $this->input->post('level_user_'.$id.'_'.$i);
			$id_ijin = $this->input->post('id_'.$id.'_'.$i);

			if ($level == "" || $level == null) {
				$respons = array('success'=>false,
								'message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, semua data harus diisi</font>');
				echo json_encode($respons);
				exit;
			}

			$data_approv = implode(',', $level);

			$nextIdIjin = $this->fungsi->getNextId('p_approval_izin','id',$company,3);

			$data3 = array(
                        'id_cabang' => $id,
                        'level_user' => $level_user,
                        'level_approval' => $data_approv,
                        'id_company' => $company);

			$this->db->where(array('id'=>$id_ijin, 'id_company'=>$_SESSION['id_company']));
			$update = $this->db->update('p_approval_izin', $data3);
		}

		return  __response_update($update);
	}

	public function delete(){
		$id = $this->input->post("id");
		$this->Pengaturan_izin_m->delete($id);
	}

}
