<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Jadwal_kerja extends MY_Controller
{

    public function __construct(){
        parent::__construct();
        $this->load->model('Cabang_m');

        $this->level_user = $this->session->userdata('level_user');
        $this->id_company = $this->session->userdata('id_company');
    }

    public function index(){
		$data['judul'] = 'Jam Kerja';
		$data['aktif'] = 'jam_kerja';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('jadwal_kerja/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Cabang_m->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->kode;
			$row[] = $field->nama;
			$row[] = (($field->flag == '1')?"PUSAT":"CABANG");
			$row[] = '<a href="'.route('pengaturan.jamkerja.detail').'/'.md5($field->id_cabang).'" class="text-primary" title="DETAIL">
							<i class="btn_edit fa fa-info-circle"> </i></a>
						</a>';
			$data[] = $row;
		}

        $output = array("draw"            => $_POST['draw'],
                        "recordsTotal"    => $this->Cabang_m->count_all(),
                        "recordsFiltered" => $this->Cabang_m->count_filtered(),
                        "data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

    public function detail($id_cabang = null){
        $company = $this->session->userdata('id_company');

        $data['judul'] = 'Jam Kerja';
		$data['aktif'] = 'jam_kerja';
        $data['id_cabang'] = $id_cabang;
        $data['nama_cabang'] = $this->fungsi->namaCabang($id_cabang);
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('jadwal_kerja/detail', $data, true);

        $this->load->view('main_template', $data, false);
    }

    public function jam_kerja(){
        $id_company = $this->session->userdata('id_company');
        $id_cabang = $this->input->post("id_cabang");

        $this->db->select("id_jam_kerja,
                            libur,
                            hari,
                            DATE_FORMAT(masuk,'%H:%i') AS masuk,
                            DATE_FORMAT(pulang,'%H:%i') AS pulang,
                            DATE_FORMAT(start_absen_masuk,'%H:%i') AS start_absen_masuk,
                            DATE_FORMAT(batas_absen_pulang,'%H:%i') AS batas_absen_pulang,
                            hari.nama");
        $this->db->from('jam_kerja');
        $this->db->join('hari', 'jam_kerja.hari=hari.id', 'LEFT');
        $this->db->order_by('hari.id', 'ASC');
        $this->db->where("md5(jam_kerja.id_cabang)", $id_cabang);
        $this->db->where("jam_kerja.id_company", $id_company);
        $data = $this->db->get()->result();

        $output = array("success"=>true,
                        "data"=> $data,);

        $output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    public function update(){
        if ($this->input->post("hidden_id")) {
            $id = $this->input->post("hidden_id");
            $masuk = $this->input->post("masuk");
            $pulang = $this->input->post("pulang");
            $start_absensi_masuk = $this->input->post("start_absen_masuk");
            $batas_absensi_pulang = $this->input->post("batas_absen_pulang");
            $libur = $this->input->post("libur");
			$success = 0;

            $data = array();
            for ($i = 0; $i < count($id); $i++) {
                if ($masuk[$i] != '00:00' && $pulang[$i] != '00:00' && $start_absensi_masuk[$i] != '00:00' && $batas_absensi_pulang[$i] != '00:00'){
                    $libur[$i] = 0;
                }

                $hari = date('Y-m-d');
                $awal  = strtotime($hari.' '.$masuk[$i]);
				$akhir = strtotime($hari.' '.$pulang[$i]);
				$diff  = $akhir - $awal;
				$jam   = floor($diff / (60 * 60));

                $data[] = array('masuk' => $masuk[$i],
                                'pulang' => $pulang[$i],
                                'start_absen_masuk' => $start_absensi_masuk[$i],
                                'batas_absen_pulang' => $batas_absensi_pulang[$i],
                                'libur' => $libur[$i],
                                'jml_jamkerja' => $jam-1,
                                'id_jam_kerja' => $id[$i]);
            }
            $this->db->where('id_company',$this->id_company);
            $update = $this->db->update_batch('jam_kerja', $data, 'id_jam_kerja');
            return  __response_update(1);
        }
    }

}
