<div class="position-relative pull-right" style="top: -2.5em;">
    <button id="view-diagram" type="button" class="ml-1 btn btn-warning ladda-button" data-style="expand-left">
        <i class="fa fa-bar-chart"></i> View Diagram
    </button>
</div>

<div class="table-responsive mt-2">
    <div id="data-actions" class="pull-right ml-1">
        <button id="download" type="button" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center align-middle" width="20">NO</th>
                <th rowspan="2" class="text-center align-middle">NAMA</th>

                <?php
                if (COUNT($header) > 0) {
                    foreach ($header as $row) {
                        echo '<th colspan="2" class="text-center text-uppercase">' . $row . '</th>';
                    }
                } else {
                    echo '<th colspan="2" class="text-center text-uppercase">-</th>';
                }
                ?>

                <th colspan="2" class="text-center align-middle">TOTAL POIN</th>
            </tr>
            <tr>
                <?php
                if (COUNT($header) > 0) {
                    for ($x = 1; $x <= count($header) + 1; $x++) {
                        echo '<th class="text-center">TARGET</th>';
                        echo '<th class="text-center">REALISASI</th>';
                    }
                } else {
                    echo '<th class="text-center">TARGET</th>';
                    echo '<th class="text-center">REALISASI</th>';
                    echo '<th class="text-center">TARGET</th>';
                    echo '<th class="text-center">REALISASI</th>';
                }
                ?>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'fixedColumns': {
                leftColumns: 2
            },
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan'
                <?php else: ?> 'searchPlaceholder': 'Employees Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "layout": {
                "topEnd": [
                    $("#data-actions")
                ]
            },
            "ajax": {
                "url": "<?= route('sales_activity.report.poin.harian.table.data.list') ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.periode_mulai = $(".filter #periode_mulai").val();
                    d.periode_selesai = $(".filter #periode_selesai").val();
                    d.id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
                    d.id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val();
                },
                "complete": function (data) {
                    $("#download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                render: function (data, type, full, meta) {
                    return "<div style='text-wrap:wrap !important; width:200px'>" + data + "</div>";
                },
                targets: 1
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                <?php
                if (COUNT($header) > 0) {
                    for ($x = 2; $x <= (COUNT($header) * 2) + 1; $x++) {
                        echo "$('td:eq(" . $x . ")', nRow).css({'text-align': 'center'});";
                    }

                    echo "$('td:eq(" . $x++ . ")', nRow)
                            .css({'text-align': 'center',
                                'background-color' : '#ccedff',
                                'border-top': '1px solid #fff',
                                'border-right': '1px solid #fff',
                                'border-left': '1px solid #fff'
                            });";

                    echo "$('td:eq(" . $x++ . ")', nRow)
                            .css({'text-align': 'center',
                                'background-color' : '#ccedff',
                                'border-top': '1px solid #fff',
                            });";
                } else {
                    echo "$('td:eq(2)', nRow).css({'text-align': 'center'});";
                    echo "$('td:eq(3)', nRow).css({'text-align': 'center'});";
                }
                ?>

                for (var i = 2; i <= <?= COUNT($header) * 2 ?>; i++) {
                    var jenis_izin = $('td:eq(' + i + ') span', nRow).text();
                    if ($.inArray(jenis_izin, ["libur", "cuti", "izin", "sakit"]) !== -1) {
                        $('td:eq(' + i + ')', nRow).addClass("bg-danger");
                    }
                }
            }
        });

        $("#download").click(function () {
            let periode_mulai = $(".filter #periode_mulai").val();
            let periode_selesai = $(".filter #periode_selesai").val();
            let id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
            let nm_group = !$(".filter #id_group").val() ? 'Semua Group' : $(".filter #id_group").select2('data')[0]['nm-group'];
            let id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val()
            let nm_karyawan = !$(".filter #id_karyawan").val() ? 'Semua Sales' : $(".filter #id_karyawan").select2('data')[0]['nm-karyawan'];

            urlExcel = "<?= route('sales_activity.report.poin.harian.download') ?>" +
                '?periode_mulai=' + periode_mulai +
                '&periode_selesai=' + periode_selesai +
                '&id_group=' + id_group +
                '&nm_group=' + nm_group +
                '&id_karyawan=' + id_karyawan +
                '&nm_karyawan=' + nm_karyawan;

            downloadFile(urlExcel, this);
        });

        $("#view-diagram").click(function () {
            list_datatable("diagram", this);
        });
    });
</script>