<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-8 mb-md-0 mb-1">
        <h5 class="dark-blue-color"><?= $judul ?></h5>
        <label style="color: #a7a7a7;"><?= $this->lang->line('ket_admin_absensi') ?></label>
    </div>
    <div class="content-header-right col-md-4 col-12">
        <button type="button" class="btn btn_tambah btn-success pull-right" onclick="tambah(this)">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div>
<hr>

<div class="table-responsive">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle" width="20">NO</th>
                <th class="text-center align-middle text-uppercase"><?= $this->lang->line('nama_karyawan') ?></th>
                <th class="text-center align-middle text-uppercase" width="50"><?= $this->lang->line('aksi') ?></th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
    </div>
</div>

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan'
                <?php else : ?> 'searchPlaceholder': 'Employees name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('pengaturan.admin.absensi.list.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(2)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
            }
        });
    });

    // START CRUD
    function tambah(e){
        $('#tampil_form').load("<?= route("pengaturan.admin.absensi.form.tambah") ?>", function() {
            $('#modal_form').modal('show');
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function hapus_form(e){
        $('#tampil_form').load("<?= route('pengaturan.admin.absensi.form.hapus') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
            $("#form_input #id_karyawan").prop("disabled", true);
            $("#form_input #id_group_m").prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    }

    function new_input(e){
        $("#form_input :input").prop("disabled", false);
        $("#form_input #id_karyawan").select2("val", "0");    
        $("#form_input #id_group_m").val(null).trigger("change"); 
        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').html('');
    }

    function simpan(e){
        $('#message').html("");
        var loading = Ladda.create(e);

        if ($("#form_input #id_karyawan").val() == '' || $("#form_input #id_karyawan").val() == '0') {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_karyawan') ?></font>");
            $("#form_input #id_karyawan").focus();
            return false;
        }

        loading.start();
        var param             = {};
            param.id          = $("#form_input #id").val();
            param.id_karyawan = $("#form_input #id_karyawan").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('pengaturan.admin.absensi.save') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'save') {
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();

        var param = {};
        param.id = $("#id").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('pengaturan.admin.absensi.delete') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
            },
            error: function() {
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }
    // END CRUD
</script>