<script type="text/javascript">

    $(function() {

        $(document).on('click','.btn_detail',function(){
            var id_aktivitas = $(this).attr("id");
            $('#modal_detail_aktivitas').modal('show');

            for (var i=0; i<markers.length; i++) {
                markers[i].setMap(null);
            }

            markers = []; // Reset the markers array
            lat_longs_map = []; // Reset the lat_longs_map array
            beaches = []; // Reset the beaches array

            $.get("<?= route("patroli.laporan.detail") ?>"+"/"+id_aktivitas, function(data){

                // SET MAPS
                arr = [];
                arr.push(data.lat);
                arr.push(data.long);
                arr.push(data.title);
                arr.push(data.index);
                beaches.push(arr);

                setMarkers(beaches);
                fitMapToBounds_map();

                // SET DETAIL AKTIVITAS
                $("#nama_karyawan").text(data.nama_karyawan);
                $("#jabatan").text(data.jabatan);
                $("#cabang1").text(data.cabang);
                $("#departemen1").text(data.departemen);
                $("#tgl").text(data.tgl);
                $("#jam").text(data.jam);
                $("#patroli").text(data.patroli);
                $("#keterangan").text(data.keterangan);
                $("#nm_lokasi").text(data.nm_lokasi);
                $("#foto_aktivitas").attr("src", data.foto_aktivitas);
            },"json");

        });
    });

    var map;
    var lat_longs_map = new Array();
    var markers = []; // Create a marker array to hold your markers
    var beaches = [];
    var mapCentre;

    function setMarkers(locations) {
        for (var i = 0; i < locations.length; i++) {
            var beach = locations[i];
            var myLatLng = new google.maps.LatLng(beach[0], beach[1]);
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                animation: google.maps.Animation.DROP,
                title: beach[2],
                zIndex: beach[3]
            });

            // Push marker to markers array
            markers.push(marker);

            // Push marker to lat_longs_map array
            lat_longs_map.push(marker.getPosition());

        }
    }

    function initialize() {
        var varcenter = new google.maps.LatLng(-0.4183772,117.4237542);
        var varZoom = 5.4;
        var mapOptions = {
            zoom: varZoom,
            center: varcenter,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }
        map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);

        setMarkers(beaches);
        fitMapToBounds_map();
    }

    function fitMapToBounds_map() {
        var bounds = new google.maps.LatLngBounds();

        if (lat_longs_map.length > 0) {
            for (var i=0; i<lat_longs_map.length; i++) {
                bounds.extend(lat_longs_map[i]);
            }
            map.fitBounds(bounds);
            map.setZoom(18)
        }
    }
    initialize();
</script>
<script>
    $(document).ready(function(){
      $('[data-toggle="tooltip"]').tooltip();
    });
</script>
<div class="row">
    <div class="col-md-12">
        <div class="float-md-right">
            <button type="button" id="btn_download" class="btn btn-info" data-toggle="tooltip" data-placement="top" title="Download berdasarkan grouping petugas" tglmulai="<?= $tgl_mulai ?>" tglselesai="<?= $tgl_selesai ?>" idkaryawan="0" idcabang="0" iddepartemen="0">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?> 1</button>
            <button type="button" id="btn_download2" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="Download berdasarkan grouping patroli" tglmulai="<?= $tgl_mulai ?>" tglselesai="<?= $tgl_selesai ?>" idkaryawan="0" idcabang="0" iddepartemen="0">
                <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?> 2</button>
        </div>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12">
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr class="bg-tr">
                    <th class="text-center" rowspan="2">NO</th>
                    <th class="text-center" rowspan="2"><?= strtoupper($this->lang->line('tgl')); ?></th>
                    <th class="text-center" colspan="3"><?= strtoupper($this->lang->line('jadwal')); ?></th>
                    <th class="text-left" rowspan="2"><?= strtoupper($this->lang->line('petugas')); ?></th>
                    <th class="text-center" rowspan="2"><?= strtoupper($this->lang->line('patroli')); ?></th>
                    <th class="text-left" rowspan="2"><?= strtoupper($this->lang->line('keterangan')); ?></th>
                    <th class="text-left" rowspan="2"><?= strtoupper($this->lang->line('lokasi')); ?></th>
                    <th class="text-center" rowspan="2"><?= strtoupper($this->lang->line('aksi')); ?></th>
                </tr>
                <tr>
                    <th class="text-left"><?= strtoupper($this->lang->line('nama_patroli')); ?></th>
                    <th class="text-center"><?= strtoupper($this->lang->line('mulai')); ?></th>
                    <th class="text-center"><?= strtoupper($this->lang->line('selesai')); ?></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>


<!-- START TAMPIL MODAL -->
<div id="modal_detail_aktivitas" class="modal fade in" data-keyboard="false" data-backdrop="static" aria-hidden="true">
    <div class="modal-dialog" style="max-width: 80%;">
        <div id="tampil_form" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"><?= $this->lang->line('detail_laporan') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <div class="col-md-4">
                        <h4><b><?= $this->lang->line('petugas') ?></b></h4>
                        <hr>
                    </div>
                    <div class="col-md-4">
                        <h4><b><?= $this->lang->line('laporan_pat') ?></b></h4>
                        <hr>
                    </div>
                    <div class="col-md-4">
                        <h4><b><?= $this->lang->line('jadwal') ?></b></h4>
                        <hr>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('name') ?></h5>
                        <label id="nama_karyawan"></label>
                    </div>
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('tgl') ?></h5>
                        <label id="tgl"></label>
                    </div>
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('name') ?></h5>
                        <label id="patroli"></label>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('cabang') ?></h5>
                        <label id="cabang1"></label>
                    </div>
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('waktu') ?></h5>
                        <label id="jam"></label>
                    </div>
                </div>

                <div class="row mt-1">
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('departemen') ?></h5>
                        <label id="departemen1"></label>
                    </div>
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('lokasi') ?></h5>
                        <label id="nm_lokasi"></label>
                    </div>
                    <div class="col-md-4">
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('jabatan'); ?></h5>
                        <label id="jabatan"></label>
                    </div>
                    <div class="col-md-4">
                        <h5><?= $this->lang->line('keterangan'); ?></h5>
                        <label id="keterangan"></label>
                    </div>
                    <div class="col-md-4">
                    </div>
                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-md-6 text-center thumbnail">
                        <h5><?= $this->lang->line('lokasi_patroli') ?></h5>
                        <div id="map_canvas" style="width:100%; height:350px;"></div>
                    </div>
                    <div class="col-md-6 text-center thumbnail">
                        <h5><?= $this->lang->line('poto_patroli') ?></h5>
                        <img id="foto_aktivitas" class="portrait" style="max-height:350px">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-close"></i> <?= $this->lang->line('button_form_tutup'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
                        'searching'     : true,
                        'paging'        : true,
                        'lengthChange'  : true,
                        'ordering'      : true,
                        'info'          : true,
                        'scrollX'       :true,
                        'scrollCollapse': true,
                        'language': {
                                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'Keterangan'
                                <?php else : ?> 'searchPlaceholder': 'Description'
                                <?php endif; ?>
                        },
                        "processing"  : true,
                        "serverSide"  : true,
                        "order"       : [],

                        "ajax"        : {
                                            "url": "<?= route('patroli.laporan.listdata')."/".$tgl_mulai."/".$tgl_selesai."/".$id_karyawan."/".$id_cabang."/".$id_departemen ?>",
                                            "type": "GET",
                                            "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                        },

                        "aoColumnDefs": [
                                            { "aTargets": [0], "bSortable": false},
                                            { "aTargets": [2], "bSortable": false},
                                            { "aTargets": [3], "bSortable": false},
                                            { "aTargets": [4], "bSortable": false},
                                            { "aTargets": [5], "bSortable": false},
                                            { "aTargets": [6], "bSortable": false},
                                            { "aTargets": [7], "bSortable": false},
                                            { "aTargets": [8], "bSortable": false},
                                            { "aTargets": [-1], "bSortable": false }
                                        ],
                        "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(1)', nRow).css({'text-align':'center','width':'100px'});
                            $('td:eq(2)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(3)', nRow).css({'text-align':'center','width':'50px'});
                            $('td:eq(4)', nRow).css({'text-align':'center','width':'50px'});
                            $('td:eq(5)', nRow).css({'text-align':'left','width':'150px'});
                            $('td:eq(6)', nRow).css({'text-align':'center','width':'50px'});
                            $('td:eq(9)', nRow).css({'text-align':'center','width':'50px'});
                        }

                });
    })
</script>