<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Target_poin_m extends CI_Model
{
    var $table = 'data_karyawan';

    function get_datatables($id_group_m = ""){
        $this->_get_datatables_query($id_group_m);

        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }

        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id_group_m = ""){
        $this->_get_datatables_query($id_group_m);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_group_m = ""){
        $this->_get_datatables_query($id_group_m);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($id_group_m = ""){
        $this->db->select("
            karyawan.id_karyawan,
            karyawan.nik,
            karyawan.nama_lengkap,
            karyawan.id_company,
            IF(poin.poin IS NULL, '-', poin.poin) AS poin,
            IF(poin.poin IS NULL, 'insert', 'update') AS action,
            approver.id_group_m,
            sgm.kode AS kode_group,
            sgm.nama AS nama_group
        ")
        ->from($this->table. ' AS karyawan')
        ->join('sales_target_poin_p as poin', 'poin.id_karyawan = karyawan.id_karyawan', 'LEFT')
        ->join('sales_approver as approver', 'approver.id_karyawan = karyawan.id_karyawan')
        ->join('sales_group_m as sgm', 'sgm.id_group_m = approver.id_group_m', 'LEFT')
        ->where("karyawan.id_company", $this->id_company)
        ->where("karyawan.flag_sales", "1")
        ->where_in("karyawan.status", ["1", "2", "3", "4"]);

        // filter id_group_m
        if($id_group_m != "all"){
            $this->db->where('approver.id_group_m', $id_group_m);
        }

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('approver.id_group_m', explode(',', $this->sales_admin_group));
            }
        }

        $column_search = array('nik' ,'nama_lengkap');
        $i = 0;
        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('', 'kode', 'nama', 'flag');
        if (isset($_GET['order'])) {
            // $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $order_by = array("karyawan.nama_lengkap" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function save($data=[], $id="", $status=""){
        if($status == 'update'){
            // PROSES UPDATE
            $user_update    = array('tgl_update'     => date("Y-m-d H:i:s"),
                                    'user_update'	=> $this->nik_karyawan. " - ". $this->nm_karyawan);

            $this->db->trans_start();

            $this->db->where('id_company', $this->id_company);
            $this->db->where("md5(CONCAT(id_karyawan,id_company))",$id);
            $this->db->update('sales_target_poin_p', array_merge($data,$user_update));
            
            $this->db->where('tgl_trx', date('Y-m-d'));
            $this->db->where('id_company', $this->id_company);
            $this->db->where("md5(CONCAT(id_karyawan,id_company))",$id);
            $this->db->update('sales_target_poin_trx', array_merge($data,$user_update));
            
            $this->db->trans_complete();
            if ($this->db->trans_status() === TRUE) {
                $this->db->trans_commit();
                return  __response_update(true);
            } else {
                $this->db->trans_rollback();
                return  __response_update(false);
            }
        }else{
            // PROSES SAVE
            $user_input = array('tgl_input'     => date("Y-m-d H:i:s"),
                                'user_input'    => $this->nik_karyawan. " - ". $this->nm_karyawan);

            $save = $this->db->insert('sales_target_poin_p', array_merge($data,$user_input));
            return  __response_save($save);
        }
    }
}