<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pot_absensi_m extends CI_Model
{
    protected $table = 'payroll_pot_absensi_p';

    function get_datatables()
    {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->select("jenis")->from($this->table);
        $this->db->where("id_company", $this->id_company);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query()
    {
        $this->db->select("
                            jenis,
                            flag_aktif,
                            flag_persentase_gapok,
                            persentase,
                            nominal_potongan,
                            menit,
                            kelipatan")
            ->from($this->table)
            ->where("id_company", $this->id_company);

        $column_search = array('');
        $i             = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_POST['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                } else {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if (isset($_POST['order'])) {
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else {
            $order_by = array("jenis" => "ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getCountJenis($id = null)
    {
        $this->db->select("jenis");
        $this->db->from($this->table);
        $this->db->where("md5(jenis)", $id);
        $this->db->where("id_company", $this->id_company);
        return $this->db->get()->num_rows();
    }

    public function update($data, $jenis)
    {
        $is_data = $this->getCountJenis($jenis);

        if ($is_data > 0) {
            $this->db->trans_start();

            $data["user_update"] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $data["tgl_update"]  = date("Y-m-d H:i:s");

            $this->db->update($this->table, $data, ["md5(jenis)" => $jenis, "id_company" => $this->id_company]);
            $this->logger->create_log('payroll_pot_absensi', 'edit', $this->db->last_query());

            $this->db->trans_complete();

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return __response_update(false);
            } else {
                $this->db->trans_commit();
                return __response_update(true);
            }
        } else {
            return __response_update(false);
        }
    }

    public function save_pph21($data, $for)
    {
        $this->db->trans_start();

        if ($for == 'store') {
            $data['user_input'] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $data['id_company'] = $this->id_company;
            $this->db->insert('payroll_pph21_p', $data);
            $this->logger->create_log('payroll_pot_pph', 'insert', $this->db->last_query());
        } else if ($for == 'update') {
            $data['user_update'] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
            $data['tgl_update']  = date('Y-m-d H:i:s');
            $this->db->update('payroll_pph21_p', $data, ['id_company' => $this->id_company]);
            $this->logger->create_log('payroll_pot_pph', 'edit', $this->db->last_query());
        } else {
            $message = ['message' => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gagal, terjadi kesalahan</font>'];
            return __response_update(false, $message);
        }

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            if ($for == 'store') {
                return __response_save(false);
            }
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            if ($for == 'store') {
                return __response_save(true);
            }
            return __response_update(true);
        }
    }

    public function getDataPengaturanPph21()
    {
        $select = $this->db->select('
                aktif,
                jenis,
                nm_pemotong,
                jenis_pemotong,
                npwp,
                no_ktp,
                id_tku,
                id_company
            ')
            ->from('payroll_pph21_p')
            ->where("id_company", $this->id_company)
            ->get()
            ->row();
        return $select;
    }
}
