<?php

class Detail_m extends CI_Model {

    var $table = "kpi_aspek_kinerja_trx";

    public function getDataById($id) {
        $this->db->select('ctt_exiting_role, ctt_career_development, ctt_diterima, tgl_approval, user_approval, tahun, bulan, id_karyawan, id_atasan, status');
        $this->db->from('kpi_trx');
        $this->db->where("md5(concat(id_karyawan, tahun, bulan)) = '$id'", '');
        return $this->db->get()->row();
    }

    public function getDataPerformanceById($id) {
        $this->db->from('kpi_aspek_kinerja_trx pi');
        $this->db->where('md5(pi.id_pi_trx)', $id);
        return $this->db->get()->row();
    }

    public function dataPerformanceIndikator($id, $data = null) {
        if($id == '') {
            if($data != null) {
                return [
                    'id_pi_trx'         => $data->id_pi_trx,
                    'id_karyawan'       => $data->id_karyawan,
                    'tahun'             => $data->tahun,
                    'bulan'             => $data->bulan,
                    'id_object'         => $data->id_object,
                    'nm_object'         => $data->nm_object,
                    'no_urut_object'    => $data->no_urut_object,
                    'nm_aspek_kinerja'      => $data->nm_aspek_kinerja,
                    'target'            => $data->target,
                    'bobot'             => $data->bobot,
                    'poin_1'            => $data->poin_1,
                    'poin_2'            => $data->poin_2,
                    'poin_3'            => $data->poin_3,
                    'poin_4'            => $data->poin_4,
                    'poin_5'            => $data->poin_5,
                    'no_urut_aspek_kinerja' => $data->no_urut_aspek_kinerja,
                    'id_company'        => $this->id_company,
                    'user_input'        => "$this->nik_karyawan - $this->nm_karyawan",
                ];
            } else {
                return [
                    'id_pi_trx'         => generate_id('id_pi_trx', $this->id_company),
                    'id_karyawan'       => $this->input->post('karyawan'),
                    'tahun'             => $this->input->post('tahun'),
                    'bulan'             => $this->input->post('bulan'),
                    'id_object'         => $this->input->post('obyektives'),
                    'nm_object'         => $this->input->post('namaObyektives'),
                    'no_urut_object'    => $this->input->post('noUrutObyektives'),
                    'nm_aspek_kinerja'      =>$this->input->post('performIndicator'),
                    'target'            => $this->input->post('target'),
                    'bobot'             => $this->input->post('bobot'),
                    'poin_1'            => $this->input->post('skor1'),
                    'poin_2'            => $this->input->post('skor2'),
                    'poin_3'            => $this->input->post('skor3'),
                    'poin_4'            => $this->input->post('skor4'),
                    'poin_5'            => $this->input->post('skor5'),
                    'no_urut_aspek_kinerja' => $this->getNoUrutIndikator(),
                    'id_company'        => $this->id_company,
                    'user_input'        => "$this->nik_karyawan - $this->nm_karyawan",
                ];
            }
        } else {
            return [
                'nm_aspek_kinerja' => $this->input->post('performIndicator'),
                'target'       => $this->input->post('target'),
                'bobot'        => $this->input->post('bobot'),
                'poin_1'       => $this->input->post('skor1'),
                'poin_2'       => $this->input->post('skor2'),
                'poin_3'       => $this->input->post('skor3'),
                'poin_4'       => $this->input->post('skor4'),
                'poin_5'       => $this->input->post('skor5'),
                'tgl_update'   => date('Y-m-d H:i:s'),
                'user_update'  => "$this->nik_karyawan - $this->nm_karyawan",
            ];
        }
    }

    public function getDataTrx($tahun = null, $bulan = null, $id_karyawan = null) {
        $this->db->from('kpi_trx');
        if($this->input->server('REQUEST_METHOD') == 'GET') {
            if($tahun == null) {
                $this->db->where('id_karyawan', $this->input->get('karyawan'));
                $this->db->where('tahun', $this->input->get('tahun'));
                $this->db->where('bulan', $this->input->get('bulan')); 
            } else {
                $this->db->where('id_karyawan', $id_karyawan);
                $this->db->where('tahun', $tahun);
                $this->db->where('bulan', $bulan);
            }          
        } elseif($this->input->server('REQUEST_METHOD') == 'POST') {
            $this->db->where('id_karyawan', $this->input->post('karyawan'));
            $this->db->where('tahun', $this->input->post('tahun'));
            $this->db->where('bulan', $this->input->post('bulan'));
        }
        return $this->db->get();
    }

    private function getDataAllTrx($id_karyawan) {
        $this->db->from('kpi_trx');
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('status !=', '5');
        $this->db->order_by('tahun', 'desc');
        $this->db->order_by('bulan', 'desc');
        return $this->db->get();
    }

    public function dataTrx($tahun = null, $bulan = null, $id_karyawan = null) {
        if($this->input->server('REQUEST_METHOD') == 'POST') {
            return [
                'id_karyawan' => $this->input->post('karyawan'),
                'tahun'       => $this->input->post('tahun'),
                'bulan'       => $this->input->post('bulan'),
                'status'      => '5',
                'id_atasan'   => $this->getIdAtasan(),
                'id_company'  => $this->id_company,
                'user_input'  => "$this->nik_karyawan - $this->nm_karyawan",
            ];
        } else {
            return [
                'id_karyawan' => $id_karyawan,
                'tahun'       => $tahun,
                'bulan'       => $bulan,
                'status'      => '5',
                'id_atasan'   => $this->getIdAtasan($id_karyawan),
                'id_company'  => $this->id_company,
                'user_input'  => "$this->nik_karyawan - $this->nm_karyawan",
            ];
        }
    }

    private function getNoUrutIndikator() {
        $karyawan   = $this->input->post('karyawan');
        $tahun      = $this->input->post('tahun');
        $bulan      = $this->input->post('bulan');
        $obyektives = $this->input->post('obyektives');
        
        $this->db->from('kpi_aspek_kinerja_trx');
        $this->db->where('id_karyawan', $karyawan);
        $this->db->where('tahun', $tahun);
        $this->db->where('bulan', $bulan);
        $this->db->where('id_object', $obyektives);
        $this->db->order_by('id_pi_trx', 'desc');
        $data = $this->db->get();
        if($data->num_rows() == 0) {
            return 1;
        } else {
            return $data->row()->no_urut_aspek_kinerja+1;
        }
    }

    public function getIdAtasan($id_karyawan = null) {
        $this->db->select('id_atasan');
        $this->db->from('kpi_approver_p');
        if($this->input->server('REQUEST_METHOD') == 'GET') {
            if($id_karyawan != null) {
                $this->db->where('id_karyawan', $id_karyawan);
            } else {
                $this->db->where('id_karyawan', $this->input->get('karyawan'));
            }
        } else {
            $this->db->where('id_karyawan', $this->input->post('karyawan'));
        }
        return $this->db->get()->row()->id_atasan;
    }

    private function getDataPerformanceExists($tahun, $bulan, $id_karyawan) {
        $this->db->select('pi.*');
        $this->db->from('kpi_aspek_kinerja_trx pi');
        $this->db->join('kpi_object_m object', 'object.id_object_m = pi.id_object');
        $this->db->where('pi.tahun', $tahun);
        $this->db->where('pi.bulan', $bulan);
        $this->db->where('pi.id_karyawan', $id_karyawan);
        $this->db->order_by('pi.no_urut_object', 'asc');
        $this->db->order_by('pi.no_urut_aspek_kinerja', 'asc');
        return $this->db->get();
    }

    public function totalSkorBelumDisetujui() {
        $id_karyawan = $this->input->get('karyawan');
        $tahun       = $this->input->get('tahun');
        $bulan       = $this->input->get('bulan');

        $data  = $this->getDataPerformanceExists($tahun, $bulan, $id_karyawan);
        $total = 0;
        foreach($data->result() as $row) {
            $total += ($row->bobot/100)*$row->actual_poin_approval;
        }
        return round($total, 2);
    }

    // insert kpi pada periode input jika belum ada datanya dari data periode sebelumnya (jika ada datanya)
    public function insertPrevKpi($data) 
    {
        $periodeTarget = periodeTarget($data['tahun'], $data['bulan']);
        $dataTrx       = $this->getDataTrx($data['tahun'], $data['bulan'], $data['data_karyawan']->id_karyawan);
        $dataAllTrx    = $this->getDataAllTrx($data['data_karyawan']->id_karyawan);
        if($periodeTarget['isPeriodeInput'] == true and $dataTrx->num_rows() == 0 and $dataAllTrx->num_rows() > 0) {
            $dataPerformanceIndikator = [];
            $dataPerformanceExist     = $this->getDataPerformanceExists($dataAllTrx->row()->tahun, $dataAllTrx->row()->bulan, $data['data_karyawan']->id_karyawan);
            $id_pi_trx                = '';
            $no_urut_aspek_kinerja        = 0;
            foreach($dataPerformanceExist->result() as $key => $row) {
                if($key == 0) {
                    $id_pi_trx         = generate_id('id_pi_trx', $this->id_company);
                    $no_urut_aspek_kinerja = 1;
                } else {
                    $id_pi_trx = generate_id_from_prev('id_pi_trx', $this->id_company, $id_pi_trx);
                    if($dataPerformanceIndikator[$key-1]['id_object'] == $row->id_object) {
                        // jika obyektives masih sama
                        $no_urut_aspek_kinerja = $dataPerformanceIndikator[$key-1]['no_urut_aspek_kinerja']+1;
                    } else {
                        $no_urut_aspek_kinerja = 1;
                    }
                }
                $row->id_pi_trx         = $id_pi_trx;
                $row->tahun             = $data['tahun'];
                $row->bulan             = $data['bulan'];
                $row->no_urut_aspek_kinerja = $no_urut_aspek_kinerja;
                
                $dataPerformanceIndikator[] = $this->dataPerformanceIndikator('', $row);
            }
            
            if(count($dataPerformanceIndikator) > 0) {
                $this->db->trans_start();
                $this->db->insert_batch('kpi_aspek_kinerja_trx', $dataPerformanceIndikator);
                $this->db->insert('kpi_trx', $this->dataTrx($data['tahun'], $data['bulan'], $data['data_karyawan']->id_karyawan));
                $this->db->trans_complete();
            }
        }
    }

    // datatables
    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("id_pi_trx")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", $this->input->get('karyawan'));
        $this->db->where("tahun", $this->input->get('tahun'));
        $this->db->where("bulan", $this->input->get('bulan'));
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($id_karyawan = null, $tahun = null, $bulan = null){
        $this->db->select("id_pi_trx,
            nm_object,
            no_urut_object,
            nm_aspek_kinerja,
            target,
            bobot,
            poin_1,
            poin_2,
            poin_3,
            poin_4,
            poin_5,
            no_urut_aspek_kinerja,
            actual_poin,
            actual_bukti, 
            actual_poin_approval")->from($this->table);
        $this->db->where("id_company",$this->id_company);
        if($id_karyawan != null) {
            $this->db->where("id_karyawan", $id_karyawan);
            $this->db->where("tahun", $tahun);
            $this->db->where("bulan", $bulan);
        } else {
            $this->db->where("id_karyawan", $this->input->get('karyawan'));
            $this->db->where("tahun", $this->input->get('tahun'));
            $this->db->where("bulan", $this->input->get('bulan'));
        }
        $this->db->order_by('no_urut_object', 'asc');
        $this->db->order_by('no_urut_aspek_kinerja', 'asc');
    }
    // end datatables

    public function download($id_karyawan, $tahun, $bulan) {
        $this->_get_datatables_query($id_karyawan, $tahun, $bulan);
        return $this->db->get();
    }

    public function get_data_kedisiplinan($id_karyawan="", $tahun="", $bulan=""){
        $this->db->select("jenis, jumlah, poin, bobot, skor")->from("kpi_aspek_kedisiplinan_trx");
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan", $id_karyawan);
        $this->db->where("tahun", $tahun);
        $this->db->where("bulan", $bulan);
        $this->db->order_by("FIELD(jenis, 'T', 'PC', 'IT', 'IPC', 'TAP', 'A')", '', true);
        return $this->db->get()->result();
    }
}
