<?php

class Home_m extends CI_Model {

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    private function _get_datatables_query($periode = null) {
        if($periode != null) {
            $periode = explode("-", $periode);
            $tahun   = $periode[0];
            $bulan   = (int)$periode[1];
        } else {
            $tahun = htmlentities($this->input->get('tahun'));
            $bulan = htmlentities($this->input->get('bulan'));
        }
        $karyawan = htmlentities($this->input->get('karyawan'));

        $this->db->select("kry.nama_lengkap, kry.nik, jab.nama as jabatan, trx.tgl_pengajuan, trx.status, kry.id_karyawan, score.skor_predikat, score.remark, trx.id_karyawan, trx.tahun, trx.bulan");
        $this->db->from('data_karyawan kry');
        $this->db->join('master_jabatan jab', 'kry.id_jabatan = jab.id_jabatan');
        $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan");
        $this->db->join('kpi_personal_score_trx score', 'score.id_karyawan = trx.id_karyawan and score.tahun = trx.tahun and score.bulan = trx.bulan', 'left');
        $this->db->where('trx.tahun', $tahun);
        $this->db->where('trx.bulan', $bulan);
        
        $this->db->where("kry.id_company",$this->id_company);
        if($karyawan != "") {
            $this->db->where('kry.id_karyawan', $karyawan);
        }

        $column_order = array(null,'kry.nama_lengkap','jab.nama', null, null, 'score.skor_ttl');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("trx.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function count_all(){
        $tahun    = htmlentities($this->input->get('tahun'));
        $bulan    = htmlentities($this->input->get('bulan'));
        $karyawan = htmlentities($this->input->get('karyawan'));

        $this->db->select("kry.id_karyawan");
        $this->db->from('data_karyawan kry');
        $this->db->join('kpi_trx trx', "trx.id_karyawan = kry.id_karyawan");
        if($karyawan != "") {
            $this->db->where('trx.id_karyawan', $karyawan);
        }
        $this->db->where('trx.tahun', $tahun);
        $this->db->where('trx.bulan', $bulan);
        $this->db->where("kry.id_company",$this->id_company);
        return $this->db->count_all_results();
    }

    public function download($periode) {
        $this->_get_datatables_query($periode);
        return $this->db->get();
    }

}