<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_keluarga_m extends CI_Model {
    var $table = 'data_keluarga';

    public function list_data($id_karyawan = null){
        $id_company = $this->id_company;
        $query = "SELECT id_keluarga,
                        nama,
                        tempat_lahir,
                        tanggal_lahir,
                        jenis_kelamin,
                        agama,
                        telepon,
                        pekerjaan,
                        hub_keluarga,
                        status_perkawinan,
                        nik,
                        no_bpjs,
                        pendidikan_terakhir,
                        tanggal_perkawinan,
                        status
                FROM data_keluarga 
                WHERE id_karyawan = ? 
                AND id_company = ?
                ORDER BY (CASE hub_keluarga

                                WHEN 'Ayah'
                                THEN 1
                                
                                WHEN 'Ibu'
                                THEN 2
                                
                                WHEN 'Suami'
                                THEN 3
                                
                                WHEN 'Istri'
                                THEN 4
                                
                                WHEN 'Anak'
                                THEN 5
                                
                                WHEN 'Saudara Kandung'
                                THEN 6
                                
                                END) ASC";
        return $this->db->query($query, array($id_karyawan,$id_company))->result();

    }

    public function getDataById($id_keluarga=null){
        $id_company = $this->id_company;
        $select = "SELECT id_keluarga,
                        nama,
                        tempat_lahir,
                        tanggal_lahir,
                        jenis_kelamin,
                        agama,
                        telepon,
                        pekerjaan,
                        hub_keluarga,
                        status_perkawinan,
                        nik,
                        no_bpjs,
                        pendidikan_terakhir,
                        tanggal_perkawinan,
                        status
                    FROM $this->table
                    WHERE md5(id_keluarga) = ?
                    AND id_company = ?";
        $query = $this->db->query($select,array($id_keluarga,$id_company))->row();
        return $query;
    }

    public function save_keluarga($data,$id = null){
        if($id != null){
            $this->db->where(array('md5(id_keluarga)'=>$id));
            $update = $this->db->update('data_keluarga',$data);
            return  __response_update($update);
        }else{
            $id_company = $this->session->userdata('id_company');
            $nextId = $this->fungsi->getNextId('data_keluarga','id_keluarga',$id_company,4);
            // $id_keluarga = array('id_keluarga' => $nextId);
            $nextId = $this->getNextId_keluarga();
            $save = $this->db->insert('data_keluarga', array_merge($data, $id_keluarga));
            return  __response_save($save);    
        }
        
    }

    public function delete($id=null){
        $this->db->where(array('md5(id_keluarga)'=>$id));
        $delete =$this->db->delete($this->table);
        return  __response_delete($delete);
    }

    public function getNextId_keluarga()
    {
        $gedId = $this->db->query("SELECT RIGHT(MAX(id_keluarga), 4) as id
                                    FROM data_keluarga_p
                                    WHERE id_company = '$this->id_company'
                                    AND LEFT(id_keluarga, '".strlen($this->id_company.date('Ym'))."') = CONCAT('".$this->id_company."',DATE_FORMAT(CURRENT_DATE(),'%Y%m'))")->row();

        if(!empty($gedId->id)){
                $nextid = $this->id_company.date('Ym').sprintf("%04d", ($gedId->id+1));
            }else{
                $gedId = $this->db->query("SELECT RIGHT(MAX(id_keluarga), 4) as id
                                    FROM data_keluarga
                                    WHERE id_company = '$this->id_company'
                                    AND LEFT(id_keluarga, '".strlen($this->id_company.date('Ym'))."') = CONCAT('".$this->id_company."',DATE_FORMAT(CURRENT_DATE(),'%Y%m'))")->row();

                if(!empty($gedId->id)){
                    $nextid = $this->id_company.date('Ym').sprintf("%04d", ($gedId->id+1));
                }else{
                    $nextid = $this->id_company.date('Ym').'0001';
                }
            }
            return $nextid;
    }

}