<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Jenis_perorangan extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/master/Jenis_perorangan_m');
    }

    public function list_data(){
        $list = $this->Jenis_perorangan_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = htmlspecialchars($field->nama);

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_jenis_perusahaan_m) . '" class="btn_edit fa fa-edit (alias)" onclick="edit(this)"> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_jenis_perusahaan_m) . '" class="btn_delete fa fa-trash" onclick="hapus_form(this)"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Jenis_perorangan_m->count_all(),
            "recordsFiltered" => $this->Jenis_perorangan_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Jenis_perorangan_m->getDataById($id);
		}
		$this->load->view('sales_activity/master/jenis_perorangan/form',$data);
    }

    public function save(){
        $id = $this->input->post('id_jenis_perusahaan_m');

        $data = array(
            'nama'       => $this->input->post('nama'),
            'flag_jenis' => "2",
            'id_company' => $this->id_company
        );

        $this->Jenis_perorangan_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id");
        $this->Jenis_perorangan_m->delete($id);
    }
}