<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan_pph extends MY_Controller{

	public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/laporan_pph/Laporan_pph_m', 'laporan_pph');
        $this->load->model('payroll/gaji/Komponen_m');
        $this->load->helper(['pph21', 'payroll']);
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel'));
    }

	public function index()
    {
        $data['judul'] = 'Laporan PPH21';
        $data['aktif'] = 'laporan_pph';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/laporan_pph/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data($bulan="00-0000", $cabang="all", $departemen="all", $karyawan="all")
    {
        $data['judul']                   = 'Laporan PPH21';
        $data['aktif']                   = 'laporan_pph';
        $data['bulan']                   = $bulan;
        $data['id_cabang']               = $cabang;
        $data['id_departemen']           = $departemen;
        $data['id_karyawan']             = $karyawan;
        $data['komponen_tunj_tetap']     = $this->Komponen_m->master_trx(periode($bulan), 'tetap', 'pendapatan', true);
        $data['komponen_pot_tetap']      = $this->Komponen_m->master_trx(periode($bulan), 'tetap', 'potongan', true);

        $this->load->view('payroll/laporan_pph/list_data', $data, false);
    }

    private function payroll_minus($num)
    {
        if (substr($num, 0, 1) == '-') {
            $num = substr($num, 1);
            return '('.number_format($num, 0, ',', ',').')';
        }
        return number_format($num, 0, ',', ',');
    }

    public function list_data($bulan="00-0000", $cabang="all", $departemen="all", $karyawan="all")
    {
        $bulan = periode($bulan);
        $list  = $this->laporan_pph->get_datatables($bulan, $cabang, $departemen, $karyawan);
        $data  = array();
        $no    = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->periode;
            $row[] = $field->nm_karyawan."<br><b>".$field->nik."</b>";
            $row[] = $field->no_ktp;
            $row[] = $field->npwp;
            $row[] = $field->nm_jabatan."<br><b>".$field->kd_jabatan."</b>";
            $row[] = $field->tanggungan;
            $row[] = $field->local_expat;
            $row[] = $field->mulai_kerja_bulan;
            $row[] = $field->akhir_kerja_bulan;

            $row[] = $this->payroll_minus($field->gapok);

            # PENGHASILAN BRUTO
            $sum_tunj = 0;
            $data_tunj_tetap_trx = $this->Komponen_m->tunj_tetap_trx($bulan, $field->id_karyawan, true);
            foreach($data_tunj_tetap_trx->result() as $val) {
                $row[] = cek_empty(number_format($val->nominal_tunjangan,0,",","."));
                $sum_tunj += $val->nominal_tunjangan;
            }
            $row[] = number_format($field->tunj_bpjs_kes,0,",",".");
            $sum_tunj += round($field->tunj_bpjs_kes);
            $row[] = number_format($field->tunj_bpjs_tk,0,",",".");
            $sum_tunj += round($field->tunj_bpjs_tk);

            $row[] = $this->payroll_minus($field->gapok+$sum_tunj);

            # PENGURANGAN
            $sum_pot = 0;
            $data_pot_tetap_trx = $this->Komponen_m->pot_tetap_trx($bulan, $field->id_karyawan, true);
            foreach($data_pot_tetap_trx->result() as $val) {
                $row[] = cek_empty(number_format($val->nominal_potongan,0,",","."));
                $sum_pot += $val->nominal_potongan;
            }
            $row[] = number_format($field->pot_bpjs_kes,0,",",".");
            $sum_pot += round($field->pot_bpjs_kes);
            $row[] = number_format($field->pot_bpjs_tk,0,",",".");
            $sum_pot += round($field->pot_bpjs_tk);

            $row[] = $this->payroll_minus($sum_pot);

            $row[] = $this->payroll_minus($field->jml_ph_neto_disetahunkan);
            $row[] = $this->payroll_minus($field->ptkp);
            $row[] = $this->payroll_minus($field->ttl_pkp_disetahunkan);
            $row[] = $this->payroll_minus($field->pph21_non_dtp);

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->laporan_pph->count_all($bulan, $cabang, $departemen, $karyawan),
            "recordsFiltered" => $this->laporan_pph->count_filtered($bulan, $cabang, $departemen, $karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function download_excel($bulan="00-0000", $cabang="all", $departemen="all", $karyawan="all")
    {
        $bulan = periode($bulan);
        // FILENAME
        $nama_bulan = substr($bulan, -2);
        if($karyawan != "all"){
            $nama_karyawan = $this->laporan_pph->nama_karyawan($karyawan);
            $filename      = "1721 I Bulan DTP-UU HPP ". $nama_bulan. " ". $nama_karyawan;
        }else{
            if ($departemen != "all") {
                $nama_cab = $this->laporan_pph->nama_cabang($cabang);
                $nama_dep = $this->laporan_pph->nama_departemen($departemen);
                $nama     = "1721 I Bulan DTP-UU HPP ". $nama_bulan. " Cabang ". $nama_cab . " Departemen " . str_replace("/","-",$nama_dep);
                $filename = $nama;
            } else {
                if($cabang != "all") {
                    $nama     = $this->laporan_pph->nama_cabang($cabang);
                    $filename = "1721 I Bulan DTP-UU HPP ". $nama_bulan. " Cabang ". $nama . " Semua Departemen";
                } else {
                    $nama     = "1721 I Bulan DTP-UU HPP ". $nama_bulan. " Semua Cabang";
                    $filename = $nama;
                }
            }
        }
        // get komponen pendapatan
        $komponen_tunj_tetap     = $this->Komponen_m->master_trx($bulan, 'tetap', 'pendapatan', true)->result();
        $komponen_pot_tetap      = $this->Komponen_m->master_trx($bulan, 'tetap', 'potongan', true)->result();

        // Load plugin PHPExcel nya
        include APPPATH.'third_party/PHPExcel/PHPExcel.php';

        // Panggil class PHPExcel nya
        $excel = new PHPExcel();
        // Settingan awal fil excel
        $excel->getProperties()
            ->setCreator('Absenku')
            ->setLastModifiedBy('Absenku')
            ->setTitle("Laporan PPH Absenku")
            ->setSubject("Laporan PPH")
            ->setDescription("Laporan PPH Absenku Profesioanal");
        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel

        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        $style_border_header = array(
            'borders' => array(
                'outline' => array(     'style' => PHPExcel_Style_Border::BORDER_DOUBLE),
                'vertical' => array(    'style' => PHPExcel_Style_Border::BORDER_THIN),
                'horizontal' => array(  'style' => PHPExcel_Style_Border::BORDER_THIN)
            )
        );

        $style_border_isi = array(
            'borders' => array(
                'outline' => array(     'style' => PHPExcel_Style_Border::BORDER_DOUBLE),
                'vertical' => array(    'style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        $style_border_footer = array(
            'borders' => array(
                'outline' => array(     'style' => PHPExcel_Style_Border::BORDER_THIN),
                'vertical' => array(    'style' => PHPExcel_Style_Border::BORDER_THIN),
            )
        );

        $style_center = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );

        $style_biru = array(
            'font'  => array(
                'color' => array('rgb' => '0000FF'),
            )
        );

        //SET WIDTH
        $excel->getActiveSheet()->getColumnDimension('A')->setWidth("5");
        $excel->getActiveSheet()->getColumnDimension('B')->setWidth("5");
        $excel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimension('D')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('E')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimension('G')->setWidth("6");
        $excel->getActiveSheet()->getColumnDimension('H')->setWidth("7");
        $excel->getActiveSheet()->getColumnDimension('I')->setWidth("6");
        $excel->getActiveSheet()->getColumnDimension('J')->setWidth("6");
        $excel->getActiveSheet()->getColumnDimension('K')->setWidth("15");
        // PENGHASILAN
        $column = 'K';
        $mergeCellBruto = 'K';
        if (count($komponen_tunj_tetap) > 0) {
            for ($i_tunj=0; $i_tunj < count($komponen_tunj_tetap); $i_tunj++) {
                $column++;
                $mergeCellBruto++;
                $excel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
                $excel->getActiveSheet()->mergeCells($column.'7:'.$column.'9');
            }
        }
        // BPJS KES, TK, & JUMLAH
        for ($i_tunj_bpjs=0; $i_tunj_bpjs < 3; $i_tunj_bpjs++) {
            $column++;
            $mergeCellBruto++;
            $excel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
            $excel->getActiveSheet()->mergeCells($column.'7:'.$column.'9');
        }
        $excel->getActiveSheet()->mergeCells('K6:'.$mergeCellBruto.'6');

        // PENGURANGAN
        $initialMergeCellNeto = $mergeCellBruto;
        $mergeCellNeto = $column;
        if (count($komponen_pot_tetap) > 0) {
            for ($i_pot=0; $i_pot < count($komponen_pot_tetap); $i_pot++) {
                $column++;
                $mergeCellNeto++;
                $excel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
                $excel->getActiveSheet()->mergeCells($column.'7:'.$column.'9');
            }
        }
        // BPJS KES, TK, & JUMLAH
        for ($i_pot_bpjs=0; $i_pot_bpjs < 3; $i_pot_bpjs++) {
            $column++;
            $mergeCellNeto++;
            $excel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
            $excel->getActiveSheet()->mergeCells($column.'7:'.$column.'9');
        }
        $initialMergeCellNeto++;
        $excel->getActiveSheet()->mergeCells($initialMergeCellNeto.'6:'.$mergeCellNeto.'6');

        //
        for ($i=0; $i < 4; $i++) {
            $column++;
            $excel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
            $excel->getActiveSheet()->mergeCells($column.'6:'.$column.'9');
        }

        $excel->getActiveSheet()->getRowDimension(10)->setRowHeight("12");

        // SETINGAN COLSPAN ROWSPAN
        $excel->getActiveSheet()->mergeCells('B6:B9');
        $excel->getActiveSheet()->mergeCells('C6:C9');
        $excel->getActiveSheet()->mergeCells('D6:D9');
        $excel->getActiveSheet()->mergeCells('E6:E9');
        $excel->getActiveSheet()->mergeCells('F6:F9');
        $excel->getActiveSheet()->mergeCells('G6:G9');
        $excel->getActiveSheet()->mergeCells('H6:H9');
        $excel->getActiveSheet()->mergeCells('I6:I9');
        $excel->getActiveSheet()->mergeCells('J6:J9');
        // penghasilan bruto
        $excel->getActiveSheet()->mergeCells('K7:K9');

        // TITLE HEADER
        $excel->setActiveSheetIndex(0)->setCellValue('C1', "Nama");
        $excel->setActiveSheetIndex(0)->setCellValue('C2', "NPWP");
        $excel->setActiveSheetIndex(0)->setCellValue('C3', "Alamat");
        $excel->setActiveSheetIndex(0)->setCellValue('C4', "Masa Pajak");
        $excel->setActiveSheetIndex(0)->setCellValue('F2', "DTP");
        $excel->setActiveSheetIndex(0)->setCellValue('L4', "REKAPITULASI GAJI PEGAWAI");

        $nama_bulan_indo = $this->fungsi->konversi_bulan($nama_bulan);
        $excel->setActiveSheetIndex(0)->setCellValue('D4', $nama_bulan_indo);
        $excel->getActiveSheet()->getStyle('D4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // TITLE HEADER TABEL
        $excel->setActiveSheetIndex(0)->setCellValue('B6', "NO");
        $excel->setActiveSheetIndex(0)->setCellValue('C6', "Nama Pegawai");
        $excel->setActiveSheetIndex(0)->setCellValue('D6', "NIK");
        $excel->setActiveSheetIndex(0)->setCellValue('E6', "NPWP");
        $excel->setActiveSheetIndex(0)->setCellValue('F6', "Jabatan");
        $excel->setActiveSheetIndex(0)->setCellValue('G6', "TGGN");
        $excel->setActiveSheetIndex(0)->setCellValue('H6', "Lokal/ Expat");
        $excel->setActiveSheetIndex(0)->setCellValue('I6', "Mulai Kerja Bulan ke");
        $excel->setActiveSheetIndex(0)->setCellValue('J6', "Akhir Kerja Bulan ke");

        $excel->setActiveSheetIndex(0)->setCellValue('K6', "Penghasilan Bruto");
        $excel->setActiveSheetIndex(0)->setCellValue('K7', "Gapok");
        $header_bpjs_tk_jumlah = array(
            'BPJS Kes.',
            'BPJS TK',
            'Jumlah'
        );
        $header_last = array(
            'Jumlah Ph Neto Setahun/ Disetahunkan',
            'PTKP',
            'PKP Setahun/ Disetahunkan',
            'PPH 21 sebulan'
        );
        $cellInColumn = 'K';
        // penghasilan
        if (count($komponen_tunj_tetap) > 0) {
            for ($i=0; $i < count($komponen_tunj_tetap); $i++) {
                $cellInColumn++;
                $excel->setActiveSheetIndex(0)->setCellValue($cellInColumn.'7', $komponen_tunj_tetap[$i]->nm_komponen);
            }
        }
        for ($i=0; $i < count($header_bpjs_tk_jumlah); $i++) {
            $cellInColumn++;
            $excel->setActiveSheetIndex(0)->setCellValue($cellInColumn.'7', $header_bpjs_tk_jumlah[$i]);
        }
        // pengurangan
        $cellPengurangan = $cellInColumn;
        $cellPengurangan++;
        $excel->setActiveSheetIndex(0)->setCellValue($cellPengurangan.'6', "Pengurangan");
        if (count($komponen_pot_tetap) > 0) {
            for ($i=0; $i < count($komponen_pot_tetap); $i++) {
                $cellInColumn++;
                $excel->setActiveSheetIndex(0)->setCellValue($cellInColumn.'7', $komponen_pot_tetap[$i]->nm_komponen);
            }
        }
        for ($i=0; $i < count($header_bpjs_tk_jumlah); $i++) {
            $cellInColumn++;
            $excel->setActiveSheetIndex(0)->setCellValue($cellInColumn.'7', $header_bpjs_tk_jumlah[$i]);
        }
        //
        for ($i=0; $i < count($header_last); $i++) {
            $cellInColumn++;
            $excel->setActiveSheetIndex(0)->setCellValue($cellInColumn.'6', $header_last[$i]);
        }

        // TITLE HEADER ANGKA
        // $excel->setActiveSheetIndex(0)->setCellValue('B10', "1");
        // $excel->setActiveSheetIndex(0)->setCellValue('C10', "2");
        // $excel->setActiveSheetIndex(0)->setCellValue('D10', "2a");

        // $excel->setActiveSheetIndex(0);
        // $columnLetters = range('E', $cellInColumn); // Array of column letters from E to Z
        // $row = 10; // Row number

        // $startValue = 3;
        // foreach ($columnLetters as $columnLetter) {
        //     $cellCoordinate = $columnLetter . $row;
        //     $excel->getActiveSheet()->setCellValue($cellCoordinate, $startValue);
        //     $startValue++;
        // }

        // $excel->setActiveSheetIndex(0)->setCellValue('AG10', "25");
        // $excel->setActiveSheetIndex(0)->setCellValue('AH10', "26");

        // WRAP TEXT HEADER
        $excel->getActiveSheet()->getStyle('H6:AH8')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)->setWrapText(true);

        # DATA PPH
        $list = $this->laporan_pph->get_datatables($bulan, $cabang, $departemen, $karyawan);
        $no = 1; // Untuk penomoran tabel, di awal set dengan 1
        $numrow = 12; // Set baris pertama untuk isi tabel adalah baris ke 6
        $maxRow = '';
        foreach ($list as $value) {
            $excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $no);
            $excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $value->nm_karyawan);
            $excel->setActiveSheetIndex(0)->setCellValueExplicit('D'.$numrow, $value->no_ktp);
            $excel->setActiveSheetIndex(0)->setCellValueExplicit('E'.$numrow, $value->npwp);
            $excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $value->nm_jabatan);
            $excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $value->tanggungan);
            $excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $value->local_expat);
            $excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $value->mulai_kerja_bulan);
            $excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, $value->akhir_kerja_bulan);

            // $excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, !empty($value->gapok) ? $value->gapok:'-');
            $excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, $value->gapok);
            $setCell = 'K';
            $sum_tunj = 0;
            $data_tunj_tetap_trx = $this->Komponen_m->tunj_tetap_trx($bulan, $value->id_karyawan, true);
            foreach($data_tunj_tetap_trx->result() as $val) {
                $setCell++;
                $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $val->nominal_tunjangan);
                $sum_tunj += !empty($val->nominal_tunjangan) ? $val->nominal_tunjangan : 0;
            }
            $setCell++;
            $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $value->tunj_bpjs_kes);
            $sum_tunj += !empty($value->tunj_bpjs_kes) ? $value->tunj_bpjs_kes : 0;
            $setCell++;
            $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $value->tunj_bpjs_tk);
            $sum_tunj += !empty($value->tunj_bpjs_tk) ? $value->tunj_bpjs_tk : 0;
            // jumlah
            $setCell++;
            $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, ($val->gapok+$sum_tunj));

            $sum_pot = 0;
            $data_pot_tetap_trx = $this->Komponen_m->pot_tetap_trx($bulan, $value->id_karyawan, true);
            foreach($data_pot_tetap_trx->result() as $val) {
                $setCell++;
                $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $val->nominal_potongan);
                $sum_pot += !empty($val->nominal_potongan) ? $val->nominal_potongan : 0;
            }
            $setCell++;
            $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $value->pot_bpjs_kes);
            $sum_pot += !empty($value->pot_bpjs_kes) ? $value->pot_bpjs_kes : 0;
            $setCell++;
            $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $value->pot_bpjs_tk);
            $sum_pot += !empty($value->pot_bpjs_tk) ? $value->pot_bpjs_tk : 0;
            // jumlah
            $setCell++;
            $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $sum_pot);

            //
            $setCellInColumn = array(
                $value->jml_ph_neto_disetahunkan,
                $value->ptkp,
                $value->ttl_pkp_disetahunkan,
                $value->pph21_non_dtp,
            );
            for ($i=0; $i < count($setCellInColumn); $i++) {
                $setCell++;
                $excel->setActiveSheetIndex(0)->setCellValue($setCell.$numrow, $setCellInColumn[$i]);
            }
            $maxRow = $setCell;

            $no++;
            $numrow++;

        }

        # BORDER KOLOM
        $excel->getActiveSheet()
            ->getStyle("B6:".$maxRow."10")
            ->applyFromArray($style_center);

        $excel->getActiveSheet()
            ->getStyle("B6:".$maxRow."9")
            ->applyFromArray($style_border_header);

        $excel->getActiveSheet()
            ->getStyle("B10:".$maxRow."10")
            ->applyFromArray($style_border_header);

        $excel->getActiveSheet()
            ->getStyle("B12:".$maxRow."". ($numrow-1))
            ->applyFromArray($style_border_isi);

        $excel->getActiveSheet()
            ->getStyle("B12:B". ($numrow-1))
            ->applyFromArray($style_center);

        $excel->getActiveSheet()
            ->getStyle("G12:J". ($numrow-1))
            ->applyFromArray($style_center);

        # FORMAT NUMBER
        $excel->getActiveSheet()
            ->getStyle("K12:".$maxRow.$numrow)
            ->getNumberFormat()
            ->setFormatCode("#,##");

        # FORMAT TEXT
        $excel->getActiveSheet()
            ->getStyle("D12:E". $numrow)
            ->getNumberFormat()
            ->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

        # KOLOM JUMLAH
        $excel->getActiveSheet()->mergeCells('C'.$numrow.':F'.$numrow);

        $excel->getActiveSheet()
            ->getStyle('B'.$numrow.':'.$maxRow.$numrow)
            ->applyFromArray($style_border_footer);

        // penjumlahan (sum)
        $excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, "JUMLAH");
        $excel->getActiveSheet()->setCellValue('K'.$numrow,'=SUM(K12'.':K'.($numrow-1).')');
        for ($i='L'; $i <= $maxRow; $i++) {
            $excel->getActiveSheet()->setCellValue($i.$numrow,'=SUM('.$i.'12'.':'.$i.($numrow-1).')');
        }
        # END KOLOM JUMLAH

        # PEWARNAAN TEXT
        $excel->getActiveSheet()->getStyle('C1:C4')->applyFromArray($style_biru);
        $excel->getActiveSheet()->getStyle('D4')->applyFromArray($style_biru);
        $excel->getActiveSheet()->getStyle('F2')->applyFromArray($style_biru);
        $excel->getActiveSheet()->getStyle('L4')->applyFromArray($style_biru);

        # FONT DAN UKURAN TEXT
        $excel->getActiveSheet()
            ->getStyle('A1:'.$maxRow.$numrow)
            ->getFont()
            ->setName('Arial')
            ->setSize(10);

        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        // Set judul file excel nya
        $excel->getActiveSheet(0)->setTitle("Laporan PPH");
        $excel->setActiveSheetIndex(0);

        // Proses file excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename='.$filename.'.xlsx'); // Set nama file excel nya
        header('Cache-Control: max-age=0');
        $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $write->save('php://output');
    }
}
