<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Master_gapok extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/gapok/Master_gapok_m', 'model');
        $this->load->library('form_validation');
    }

    public function index()
    {
        $data['judul']   = 'Master Gapok';
        $data['aktif']   = 'master_gapok';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/master_gapok/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data()
    {
        $list = $this->model->get_datatables();
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->nm_karyawan . '<br><b>' . $field->nik . '</b>';
            $row[] = $field->nm_cabang . '<br><b>' . $field->kd_cabang . '</b>';
            $row[] = number_format($field->nominal, 0, ',', '.');
            $row[] = ($field->flag_pot_absensi == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';

            $btn_edit  = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_karyawan) . '" class="btn_edit fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="HAPUS"><i id="' . md5($field->id_karyawan) . '" class="btn_delete fa fa-trash"></i></a>';

            $row[] = $btn_edit . ' ' . $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null)
    {
        if ($id == null) {
            $this->load->view('payroll/master_gapok/form');
        } else {
            $data['data'] = $this->model->getDataById($id);
            $this->load->view('payroll/master_gapok/form', $data);
        }
    }

    public function save()
    {
        $id_karyawan      = $this->input->post('id_karyawan');
        $nominal          = $this->input->post('nominal_gapok');
        $flag_pot_absensi = $this->input->post('flag_pot_absensi');

        $data = array(
            'id_karyawan'      => $id_karyawan,
            'nominal'          => str_replace('.', '', $nominal),
            'flag_pot_absensi' => $flag_pot_absensi
        );

        $this->model->save($data);
    }

    public function update()
    {
        $nominal = $this->input->post('nominal_gapok');
        $flag_pot_absensi = $this->input->post('flag_pot_absensi');

        $data = array(
            'nominal'          => str_replace('.', '', $nominal),
            'flag_pot_absensi' => $flag_pot_absensi
        );

        $this->model->update($data);
    }

    public function delete()
    {
        $id = $this->input->post('id_karyawan');
        $this->model->delete($id);
    }
}
