<style>
    .datepicker-months .datepicker-switch {
        visibility: hidden;
    }

    .datepicker-title {
        transform: translateY(10px);
        position: relative;
        top: 5px;
    }

    .datepicker-months .prev,
    .datepicker-months .next {
        visibility: hidden;
    }
</style>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Demografi Pelanggan</h5>
    </div>
</div>

<div class="filter mt-2">
    <div class="row">
        <div class="col-md-2">
            <label class="font-weight-bold"><?= $this->lang->line('tahun'); ?></label>
            <input type="text" id="tahun" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('Y') ?>" onchange="onchange_tahun_bulan()">
        </div>
        <div class="col-md-2">
            <label class="font-weight-bold">Bulan</label>
            <input type="text" id="bulan" data-bulan="" class="form-control bg-white" style="cursor: pointer;" autocomplete="off" spellcheck="false" placeholder="Semua Bulan" onchange="onchange_tahun_bulan()" readonly>
            <span class="input-close-btn" style="margin-top: 13px">&times;</span>
        </div>

        <?php if ($this->fungsi->cek_adm_satu_grup() == false): ?>
            <div class="col-md-3">
                <label class="font-weight-bold"><?= $this->lang->line('group_area'); ?></label>
                <select class="form-control" id="id_group_m" style="width: 100%"></select>
            </div>
        <?php endif; ?>

        <div class="col-md-1 align-self-end">
            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>

<div class="table-responsive mt-4">
    <div id="data-actions" class="pull-right ml-1">
        <button id="download" type="button" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>

    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle" style="width: 10px !important;">NO</th>
                <th class="text-left align-middle">PELANGGAN</th>
                <th class="text-center align-middle" style="width: 100px !important;">JUMLAH</th>
                <th class="text-center align-middle" style="width: 150px !important;">NOMINAL</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function () {
        dropdown_tahun();
        dropdown_bulan();
        dropdown_filter_group_area()

        $("#btn_filter").on("click", function () {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function () {
                loading.stop();
            });
        });

        // Toggle visibility of close button
        $('.input-close-btn').on('click', function () {
            $(".filter #bulan").val("");
            $(".filter #bulan").data("bulan", "")
            toggleCloseButton($(".filter #bulan"));
            onchange_tahun_bulan();
        });

        // Initialize visibility based on initial input value
        toggleCloseButton($(".filter #bulan"));
    });

    function dropdown_tahun() {
        $(".filter #tahun").inputmask({
            'alias': 'datetime',
            'inputFormat': 'yyyy'
        });

        $(".filter #tahun").datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
        });
    }

    function dropdown_bulan() {
        $(".filter #bulan").datepicker({
            title: "Pilih Bulan",
            format: "MM",
            viewMode: "months",
            minViewMode: "months",
            orientation: 'bottom',
            autoclose: true,
            language: '<?= $this->code_lang ?>'
        }).change(function (e) {
            const months = <?= $this->lang->line('array_bulan') ?>;
            $(e.currentTarget).data("bulan", (months.indexOf(e.currentTarget.value) + 1));
            toggleCloseButton($(e.currentTarget));
        });

        $('.filter #bulan').datepicker('setDate', new Date());
    }

    function dropdown_filter_group_area() {
        var tahun = $(".filter #tahun").val() ? $(".filter #tahun").val() : '0000';
        var bulan = $(".filter #bulan").data("bulan") ? $(".filter #bulan").data("bulan") : 'all';

        $(".filter #id_group_m").select2({
            placeholder: "Semua Group",
            allowClear: true,
            ajax: {
                url: '<?= route("sales_activity.demografi.dropdown.group.area") ?>' + '?tahun=' + tahun + '&bulan=' + bulan,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function onchange_tahun_bulan() {
        $(".filter #id_group_m").val('').trigger('change');
        dropdown_filter_group_area();
    }
</script>

<script>
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama Pelanggan'
                <?php else: ?> 'searchPlaceholder': 'Customer Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "layout": {
                "topEnd": [
                    "search",
                    $("#data-actions")
                ]
            },
            "ajax": {
                "url": "<?= route('sales_activity.demografi.pelanggan.nama.pelanggan.list.data') ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.tahun = $(".filter #tahun").val() ? $(".filter #tahun").val() : '0000';
                    d.bulan = $(".filter #bulan").data("bulan") ? $(".filter #bulan").data("bulan") : 'all';
                    d.id_group_m = $(".filter #id_group_m").val() ? $(".filter #id_group_m").val() : 'all';
                },
                "complete": function (data) {
                    $("#download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                "aTargets": [0],
                "bSortable": false
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(2)', nRow).css({
                    'text-align': 'center',
                });
                $('td:eq(3)', nRow).css({
                    'text-align': 'right',
                });

                // Footer Total
                if (aData[4] == "_colspan") {
                    $("td:eq(0)", nRow).css({
                        'display': 'none'
                    });
                    $("td:eq(1)", nRow).css({
                        'text-align': 'center'
                    });
                    $(nRow).children('td:eq(1)').attr('colspan', 2);

                    $('td:eq(1)', nRow).css({
                        'background-color': '#1c77d4',
                        'color': '#fff',
                        'border-top': '1px solid #fff',
                        'border-right': '1px solid #fff'
                    });

                    for (var i = 2; i <= 3; i++) {
                        $('td:eq(' + i + ')', nRow).css({
                            'background-color': '#ccedff',
                            'color': '#000',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });
                    }
                }
            }
        });

        $("#download").click(function () {
            var tahun = $(".filter #tahun").val() ? $(".filter #tahun").val() : '0000';
            var bulan = $(".filter #bulan").data("bulan") ? $(".filter #bulan").data("bulan") : 'all';
            var id_group_m = $(".filter #id_group_m").val() ? $(".filter #id_group_m").val() : 'all';
            var nama_group = $(".filter #id_group_m").val() ? $(".filter #id_group_m").select2('data')[0]['nama_group'] : 'all';

            urlExcel = "<?= route('sales_activity.demografi.pelanggan.nama.pelanggan.download') ?>" + '?tahun=' + tahun + '&bulan=' + bulan + '&id_group_m=' + id_group_m + '&nama_group=' + nama_group;
            downloadFile(urlExcel, this);
        });
    });
</script>