<form>
    <table id="list_data_aspek_kinerja" class="table table-striped table-bordered" width="100%">
        <thead style="font-family: Poppins SemiBold;">
            <tr>
                <th class="align-middle" rowspan=2>Obyektif</th>
                <th class="align-middle" rowspan=2>Performa Indikator</th>
                <th width=75 rowspan=2 class="_center align-middle">Target</th>
                <th width=75 rowspan=2 class="_center align-middle">Bobot</th>
                <th class="align-middle" colspan=5>Skoring</th>
                <th class="_center align-middle" width=100 rowspan=2>Aktual</th>
                <th class="align-middle" width=100 rowspan=2>Keterangan</th>
                <th class="_center align-middle" width=100 rowspan=2>Approval</th>
            </tr>
            <tr>
                <th width=100 class="_center">1</th>
                <th width=100 class="_center">2</th>
                <th width=100 class="_center">3</th>
                <th width=100 class="_center">4</th>
                <th width=100 class="_center">5</th>
            </tr>
        </thead>
        <tbody></tbody>
        <!-- <tfoot>
            <tr height=50>
                <th class="align-middle" colspan=3 style="font-family: 'Poppins Bold';">Total</th>
                <th class="align-middle" style="font-family: 'Poppins Bold';">0%</th>
                <th class="align-middle" colspan=8></th>
            </tr>
        </tfoot> -->
    </table>
    <div class="row mt-2">
        <div id="message" class="col-md-10"></div>
        <div id="div_draft" class="col-md-2 text-right"></div>
    </div>
</form>
<script>
    $(function() {
        list_data = $('#list_data_aspek_kinerja').DataTable({
            searching: false,
            ordering : false,
            paging   : false,
            info     : false,
            scrollY  : false,
            scrollX  : true,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            columnDefs: [
                { targets: '_center', className: "text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.approval.detail.aspek-kinerja.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    d.karyawan = $('#karyawan').val();
                    d.tahun    = $('#tahun').val();
                    d.bulan    = $('#bulan').val();
                },
                complete: function(data) {
                    var pembungkus = $(".div_pembungkus_js_menu_context")
                    if(pembungkus == null || pembungkus == undefined){
                        // jalankan selanjutnya
                    }else{
                        var outerHeight = $('.body_laporan').outerHeight();
                        outerHeight = outerHeight * 80 / 100;
                        pembungkus.css('height', outerHeight);
                        adjust_size();
                    }
                },
            },
            // footerCallback: function(row, data) {
            //     var total = 0;
            //     data.forEach((item) => total = total + parseInt(item[3].replace("%", "")));
            //     this.api().column(3).footer().innerHTML = total+"%";
            // },
            drawCallback: function() {
                const modal = $('#modal_form').hasClass("show");
                const message = $('#tampil_form #message').html();
                if(modal == true && message == '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Performance indikator belum dilengkapi</font>') {
                    var   rules = {};
                    const total = $("select[name^='actual']").length;
                    for(i = 0; i < total; i++) {
                        rules["actual["+i+"]"] = {selectKpiApv: true};
                    }
                    
                    $('form').validate({
                        rules: rules
                    });
                    $('form').valid();
                }

                button('draft');
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                if (aData[12] == "colspan-total"){
                    $(nRow).children("td:eq(0)").attr('colspan', 3);
                    $(nRow).children("td:eq(3)").attr('colspan', 8);

                    var td_hilang = "td:eq(2),td:eq(3),td:eq(4),td:eq(5),td:eq(6),td:eq(7),td:eq(8),td:eq(9),td:eq(10),td:eq(11),td:eq(12)";
                    $(td_hilang, nRow).css({
                        'display': 'none'
                    });

                    $("td:eq(0),td:eq(1)", nRow).css({
                        'text-align': 'center',
                        'font-family': 'Poppins Bold'
                    });
                }
            }
        });
    });

    function adjust_size(){
        list_data.columns.adjust();
    }
    
    $(document).off('submit', 'form');
    $(document).on('submit', 'form', function(e) {
        $('form #message').html('');
        e.preventDefault();
        
        const l = Ladda.create(document.querySelector('#simpan'));
        const data = "&karyawan="+$('#karyawan').val()+"&tahun="+$('#tahun').val()+"&bulan="+$('#bulan').val()+"&jabatan="+$('#jabatan').val();
        l.start();
        $.post("<?= route('kpi.approval.detail.aspek-kinerja.save') ?>", $(this).serialize()+data, function(result) {
            $('form #message').html(result.message);
            l.stop();
        }, 'json');
    });
</script>