<style>
    .custom-loader {
        width: 25px;
        height: 25px;
        border-radius: 50%;
        border: 4px solid;
        border-color: #E4E4ED;
        border-right-color: #1c77d4;
        animation: s2 1s infinite linear;
    }

    @keyframes s2 {
        to {
            transform: rotate(1turn)
        }
    }

    .periode_tgl{
        width: 150px;
        height: 30px;
    }
</style>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Periode Approval KPI</h5>
    </div>
</div> 
<hr>

<div class="filter mt-2">
    <div class="row">
        <div class="col-md-1 align-self-center">
            <label class="font-weight-bold"><?= $this->lang->line('tahun'); ?></label>
        </div>
        <div class="col-md-3">
            <input type="text" id="tahun" class="form-control" autocomplete="off" placeholder="yyyy" spellcheck="false" value="<?= date('Y') ?>">
        </div>
        <div class="col-md-1">
            <button type="button" id="btn_filter" class="ladda-button btn btn-primary" data-style="expand-left">FILTER</button>
        </div>
    </div>
</div>

<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center align-middle">Bulan</th>
                <th class="text-center align-middle">Tanggal Mulai</th>
                <th class="text-center align-middle">Tanggal Berakhir</th>
                <th class="text-center align-middle">Aksi</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function() {
        dropdown_tahun();
        list_data();

        $("#btn_filter").on("click", function() {
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function() {
                loading.stop();
            });
        });
    });

    function dropdown_tahun() {
        $(".filter #tahun").inputmask({
            'alias': 'datetime',
            'inputFormat': 'yyyy'
        });

        $(".filter #tahun").datepicker({
            format: "yyyy",
            viewMode: "years",
            orientation: 'bottom',
            minViewMode: "years",
            autoclose: true,
        });
    }

    function list_data(){
        list_data = $('#list_data').DataTable({
            'searching': false,
            'paging': false,
            'lengthChange': true,
            'ordering': true,
            'info': false,
            'scrollX': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('kpi.periode.approval.data') ?>",
                "type": "GET",
                "data": {
                    tahun: function() {
                        return $(".filter #tahun").val()
                    },
                },
                "complete": function(data) {
                    reconfigure(data);
                    periode_tgl();
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0,1,2,3],
                    "bSortable": false
                }
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '300px'
                });

                $('td:eq(1)', nRow).css({
                    'text-align': 'center',
                });

                $('td:eq(2)', nRow).css({
                    'text-align': 'center',
                });

                $('td:eq(3)', nRow).css({
                    'text-align': 'center',
                    'width': '100px'
                });
            }
        });
    }

    function edit(e){
        var row = $(e).closest('tr');
        row.find("input").toggleClass("hidden");
        row.find("span").toggleClass("hidden");
        e.closest('td').querySelector('#save').className = "";
        e.closest('td').querySelector('#edit').className = "hidden";
    }
    
    function batal(e){
        var row = $(e).closest('tr');
        row.find("input").toggleClass("hidden");
        row.find("input").attr("data-old");
        row.find("span").toggleClass("hidden");
        
        e.closest('td').querySelector('#save').className = "hidden";
        e.closest('td').querySelector('#edit').className = "";
    }

    function save(e){
        const row = e.closest('tr');
        const inputs = row.querySelectorAll('input');

        var params = {};
        params.id = $(e).attr('id');
        let periode = [];
        for (let index = 0; index < inputs.length; index++) {
            periode.push(inputs[index].value);
        }
        params.periode = periode;

        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.periode.approval.save') ?>",
            data: params,
            dataType: 'JSON',
            beforeSend: function() {
                loading_start(row, inputs);
            },
            success: function(result) {
                loading_stop(row, inputs);
                if (result.success == true) {
                    list_data.ajax.reload();
                } else {
                    batal(e);
                    showMsg(result.message, false);
                }
            },
            error: function() {
                batal(e);
                loading_stop(row, inputs);
                showMsg('error', false);
            }
        });
    }
    
    function loading_start(row, selects) {
        var loading = row.querySelector('.custom-loader');

        row.querySelector('#save').className = "hidden";
        loading.className = "custom-loader";
        selects.forEach(element => {
            element.disabled = true;
        });
    }

    function loading_stop(row, selects) {
        var loading = row.querySelector('.custom-loader');

        row.querySelector('#edit').className = "";
        loading.className = "custom-loader hidden";
        selects.forEach(element => {
            element.disabled = false;
        });
    }

    function periode_tgl() {
        $('.periode_tgl').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            orientation: 'bottom',
            language: 'id',
        });
    }
</script>