<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= $id_karyawan ?>">
    <input type="hidden" id="id_sertifikat" class="form-control" value="<?= ((isset($data)) ? md5($data->id_sertifikat) : '') ?>">

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('nama_sertifikat_pelatihan') ?> <i class="text-danger">*</i></label>
                <input type="text" id="nama_sertifikat" class="form-control" value="<?= ((isset($data)) ? $data->nama_sertifikat : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('penyelenggara') ?> <i class="text-danger">*</i></label><br>
                <input type="text" id="penyelenggara" class="form-control" value="<?= ((isset($data)) ? $data->penyelenggara : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('tgl_berlaku') ?> <i class="text-danger">*</i></label>
                <?php
                if (isset($data)) {
                    if ($data->tgl_berlaku != "0000-00-00") {
                        $tgl_berlaku = date('d-m-Y', strtotime($data->tgl_berlaku));
                    } else {
                        $tgl_berlaku = "";
                    }
                } else {
                    $tgl_berlaku = "";
                }
                ?>
                <input type="text" id="tgl_berlaku" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tgl_berlaku ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('tgl_berakhir') ?> <i class="text-danger">*</i></label>
                <?php
                if (isset($data)) {
                    if ($data->tgl_berakhir != "0000-00-00") {
                        $tgl_berakhir = date('d-m-Y', strtotime($data->tgl_berakhir));
                    } else {
                        $tgl_berakhir = "";
                    }
                } else {
                    $tgl_berakhir = "";
                }
                ?>
                <input type="text" id="tgl_berakhir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tgl_berakhir ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('deskripsi') ?> <i class="text-danger">*</i></label><br>
                <input type="text" id="deskripsi" class="form-control" value="<?= ((isset($data)) ? $data->deskripsi : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Upload File <i class="text-danger">*</i></label>
                <?php
                if (empty($data->file)) {
                    $file = "";
                } else {
                    $file = $this->config->item('base_image') . 'imagebiodata?_t=file&_d=' . $data->file;
                }
                ?>
                <input type="file" name="sertifikat" id="sertifikat" class="dropify file" data-default-file="<?= $file ?>" data-allowed-file-extensions="jpg png jpeg">
                <input type="hidden" name="sertifikat_lama" id="sertifikat_lama" value="<?= $data->file ?>">
            </div>
        </div>
    </div>

</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save_sertifikat ladda-button" id="btn_save_sertifikat" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        datepicker();
        $('.dropify').dropify(
            <?php if ($this->code_lang == 'id') { ?> {
                    messages: {
                        'default': 'Seret dan lepas atau klik disini',
                        'replace': 'Seret dan lepas atau klik disini',
                        'remove': 'Hapus',
                        'error': 'Ooops, terjadi kesalahaan.'
                    },
                    error: {
                        'fileSize': 'The file size is too big ({{ value }} max).',
                        'minWidth': 'The image width is too small ({{ value }}}px min).',
                        'maxWidth': 'The image width is too big ({{ value }}}px max).',
                        'minHeight': 'The image height is too small ({{ value }}}px min).',
                        'maxHeight': 'The image height is too big ({{ value }}px max).',
                        'imageFormat': 'Format file tidak diperbolehkan ({{ value }} only).'
                    }
                }
            <?php } ?>
        );

        sertifikat = $('#form_input #sertifikat').dropify();

        sertifikat.on('dropify.afterClear', function(event, element) {
            $("#form_input #sertifikat_lama").val("");
        });
    });
</script>
