<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Master_ttd_m extends CI_Model {
    var $table = 'pkwt_direktur';
    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query($leveluser);
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }

    private function _get_datatables_query(){
        $this->db->select("id_karyawan,nm_karyawan,nm_jabatan,path_ttd")
                ->where("id_company",$this->id_company)
                ->from($this->table);

        $column_search = array('nm_karyawan');

        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        // $column_order = array('');
        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->select("id_karyawan,nm_karyawan,nm_jabatan,path_ttd")
                                ->where("id_company",$this->id_company)
                                ->where("MD5(id_karyawan)",$id)
                                ->from($this->table)
                                ->get()
                                ->row();
        return $select;
    }

    public function save($data=[], $id=''){
        $cek_id_karyawan = $this->_cek_id_karyawan($data['id_karyawan'], $id);

        if(!empty($cek_id_karyawan)){
            	$message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i> Data Tandatangan Direksi Sudah Ada</font>');
				return __response_save(false,$message);
        }else{
            if($id != ''){
                // PROSES UPDATE
                $user_update    = array('tgl_update'     => date("Y-m-d H:i:s"),
                                        'user_update'	=> $this->nik_karyawan. " - ". $this->nm_karyawan);
    
                $this->db->where("md5(id_karyawan)",$id);
                $this->db->where('id_company', $this->id_company);
                $update = $this->db->update('pkwt_direktur', array_merge($data,$user_update));
                return  __response_update($update);
    
            }else{
                // PROSES SAVE
                $user_input     = array('tgl_input'     => date("Y-m-d H:i:s"),
                                        'user_input'	=> $this->nik_karyawan. " - ". $this->nm_karyawan);
    
                $save = $this->db->insert('pkwt_direktur', array_merge($data,$user_input));
                return  __response_save($save);
            }
        }
    }

    public function delete($id=null){
        $query = $this->db->select('path_ttd')
							->from('pkwt_direktur')
							->where('MD5(id_karyawan)', $id)
							->where('id_company', $this->id_company)
							->get()
							->row();

        $path_ttd = $this->config->item('base_upload').$query->path_ttd;

        $this->db->where("md5(id_karyawan)",$id);
        $this->db->where('id_company', $this->id_company);
        $delete = $this->db->delete('pkwt_direktur');
        if($delete){
            unlink($path_ttd);
            $message = '<font color="#FFFFF"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data berhasil dihapus</font>';
			return __response_delete(true,["message"=>$message]);
        }else{
            $message = '<font color="#FFFFF"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal dihapus</font>';
			return __response_delete(false,["message"=>$message]);
        }
    }

    private function _cek_id_karyawan($id_karyawan='', $id=''){
        if(!empty($id)){
            $this->db->where('MD5(id_karyawan) !=', $id);
        }

        $query = $this->db->select('id_karyawan')
							->from('pkwt_direktur')
							->where('id_karyawan', $id_karyawan)
							->where('id_company', $this->id_company)
							->get()
							->row()
							->id_karyawan;
		return $query;
    }

}