<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Akun_reimburse_m extends CI_Model {
    var $table = 'reimbursement_akun';

    function get_datatables($cabang = null){
        $this->_get_datatables_query($cabang);
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $id_company = $this->session->userdata('id_company');

        $this->db->select("
                        reimbursement_akun.id_akun,
                        reimbursement_akun.kode_akun,
                        reimbursement_akun.nama_akun")
                ->from($this->table)
                ->where('reimbursement_akun.id_company',$id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $id_company = $this->session->userdata('id_company');

        $this->db->select("reimbursement_akun.id_akun,
                        reimbursement_akun.kode_akun,
                        reimbursement_akun.nama_akun")
                ->from("reimbursement_akun")
                ->where('reimbursement_akun.id_company',$id_company);

        $column_search = array('reimbursement_akun.kode_akun','reimbursement_akun.nama_akun');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode GET

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('',
                            'reimbursement_akun.kode_akun',
                            'reimbursement_akun.nama_akun');

        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        }
        else{
            $order_by = array("reimbursement_akun.id_akun"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $id_company = $this->session->userdata('id_company');
        $select = $this->db->select("reimbursement_akun.id_akun,
                                    reimbursement_akun.kode_akun,
                                    reimbursement_akun.nama_akun")
                            ->from("reimbursement_akun")
                            ->where("MD5(reimbursement_akun.id_akun) ",$id)
                            ->where("reimbursement_akun.id_company",$id_company)
                            ->get()
                            ->row();
        return $select;
    }

    public function save($data,$id = null){
        $id_company = $this->session->userdata('id_company');
        $kode = $data['kode_akun'];
        $nama = $data['nama_akun'];
        if($id != null){
            $data['user_update'] = $this->nik_karyawan." - ".$this->nm_karyawan;
            $data['tgl_update']  = date('Y-m-d h:i:s');
            
            $cek_kode = $this->db->select("kode_akun")
                                    ->from("reimbursement_akun")
                                    ->where("kode_akun",$kode)
                                    ->where("md5(id_akun) !=",$id)
                                    ->where("id_company",$id_company)
                                    ->get();

            $cek_nama = $this->db->select("nama_akun")
                                    ->from("reimbursement_akun")
                                    ->where("nama_akun",$nama)
                                    ->where("md5(id_akun) !=",$id)
                                    ->where("id_company",$id_company)
                                    ->get();
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode akun sudah digunakan</font>');
                return __response_update(false,$message);
            }else if($cek_nama->num_rows() > 0){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama akun sudah digunakan</font>');
                return __response_update(false,$message);
            }else{
                $this->db->where(array('md5(id_akun)'=>$id, 'id_company'=>$id_company));
                $update = $this->db->update($this->table,$data);
                $this->logger->create_log('reimburse_akun', 'edit', $this->db->last_query());
                return  __response_update($update);
            }

        }else{
            $data['user_input'] = $this->nik_karyawan." - ".$this->nm_karyawan;;
            $cek_kode = $this->db->select("kode_akun")
                                    ->from("reimbursement_akun")
                                    ->where("kode_akun",$kode)
                                    ->where("id_company",$id_company)
                                    ->get();

            $cek_nama = $this->db->select("nama_akun")
                                    ->from("reimbursement_akun")
                                    ->where("nama_akun",$nama)
                                    ->where("id_company",$id_company)
                                    ->get();
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode akun sudah digunakan</font>');
                return __response_save(false,$message);
            }else if($cek_nama->num_rows() > 0){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama akun sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id_akun',$id_company,4);
                $id_akun = array('id_akun' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data,$id_akun));
                return __response_save($save);
            }
        }
    }

    public function delete($id=null){
        $this->db->where(array('md5(id_akun)'=>$id));
        $delete =$this->db->delete($this->table);
        $this->logger->create_log('reimburse_akun', 'delete', $this->db->last_query());
        return  __response_delete($delete);

    }

}