<?php

if(!function_exists('periodeTarget')) {
    function periodeTarget($tahun = null, $bulan = null) {
        $CI =& get_instance();
        $CI->load->model('kpi/user/team/home_m');

        $periode = $CI->home_m->periodeTarget($tahun, $bulan);
        if($periode->num_rows() == 0) {
            return ['isPeriodeExist' => false, 'isPeriodeInput' => false, 'tahun' => null, 'bulan' => null, 'periodeMulai' => null, 'periodeSelesai' => null ];
        } else {
            $response                   = ['isPeriodeExist' => true];
            $tglSekarang                = date('Y-m-d');
            $periode                    = $periode->row();
            $response['periodeMulai']   = indo_date($periode->periode_mulai);
            $response['periodeSelesai'] = indo_date($periode->periode_selesai);
            if($tglSekarang >= $periode->periode_mulai and $tglSekarang <= $periode->periode_selesai) {
                $response['isPeriodeInput'] = true;
                $response['tahun'] = $periode->tahun;
                $response['bulan'] = $periode->bulan;
            } else {
                $response['isPeriodeInput'] = false;
                $response['tahun']          = null;
                $response['bulan']          = null;
            }
            return $response;
        }
    }
}

if(!function_exists('statusTarget')) {
    function statusTarget($status) {
        if($status == '') {
            return '-';
        } elseif($status == '5') {
            return "<span class='badge badge-custom-warning' style='font-size: 100%; font-family: Poppins SemiBold;'>Draft</span>";
        }  else {
            return "<span class='badge badge-custom-success' style='font-size: 100%; font-family: Poppins SemiBold;'>Published</span>";
        }
    }
}

if(!function_exists('statusActual')) {
    function statusActual($status) {
        if($status == '6') {
            return "<span class='badge badge-custom-secondary' style='font-size: 100%; font-family: Poppins SemiBold;'>Baru</span>";
        } elseif($status == '7') {
            return "<span class='badge badge-custom-warning' style='font-size: 100%; font-family: Poppins SemiBold;'>Draft</span>";
        } elseif($status == '1') {
            return "<span class='badge badge-custom-primary' style='font-size: 100%; font-family: Poppins SemiBold;'>Diajukan</span>";
        } elseif($status == '4') {
            return "<span class='badge badge-custom-success' style='font-size: 100%; font-family: Poppins SemiBold;'>Approved</span>";
        } elseif($status == '9') {
            return "<span class='badge badge-custom-ungu' style='font-size: 100%; font-family: Poppins SemiBold;'>Diterima</span>";
        }
    }
}

if(!function_exists('detailData')) {
    function detailData($id) {
        $CI =& get_instance();
        $CI->load->model('karyawan_m');

        if(strpos($id, "-") !== false) {
            $temp = explode("-", $id);
            if(count($temp) > 2) {
                $temp = [str_replace("-".$temp[count($temp)-1], "", $id), $temp[count($temp)-1]];
            }
            $tahun       = substr($temp[1], 0, 4);
            $bulan       = substr($temp[1], 4);
            $bulanString = $bulan;
            if(strlen($bulanString) == 1) {
                $bulanString = "0".$bulanString;
            }

            $result['periode']       = indo_date("$tahun-$bulanString-01", "F Y");
            $result['data_karyawan'] = $CI->karyawan_m->getDataById(md5($temp[0]));
            $result['tahun']         = $tahun;
            $result['bulan']         = $bulan;
            $result['terima']        = false;
            $result['existing_role'] = '';
            $result['career_dev']    = '';
            $result['ctt_terima']    = '';
            $result['tgl_approval']  = '';
            $result['user_approval'] = '';
            $result['status']        = '';
        } else {
            $CI->load->model('kpi/user/team/detail_m');
            $data = $CI->detail_m->getDataById($id);

            $tahun       = $data->tahun;
            $bulan       = $data->bulan;
            $bulanString = $bulan;
            if(strlen($bulanString) == 1) {
                $bulanString = "0".$bulanString;
            }

            $result['periode']       = indo_date("$tahun-$bulanString-01", "F Y");
            $result['data_karyawan'] = $CI->karyawan_m->getDataById(md5($data->id_karyawan));
            $result['tahun']         = $tahun;
            $result['bulan']         = $bulan;
            $result['terima']        = $data->status == '4' || $data->status == '9' ? true : false;
            $result['existing_role'] = $data->ctt_exiting_role;
            $result['career_dev']    = $data->ctt_career_development;
            $result['ctt_terima']    = $data->ctt_diterima;
            $result['tgl_approval']  = $data->status == '4' || $data->status == '9' ? indo_date($data->tgl_approval) : '';
            $result['user_approval'] = $data->user_approval;
            $result['status']        = $data->status;
        }

        return $result;
    }
}

if(!function_exists('periode')) {
    function periode($tahun, $bulan) {
        $CI =& get_instance();
        if($tahun == null) {
            $tahun = htmlentities($CI->input->get('tahun'));
            $bulan = htmlentities($CI->input->get('bulan'));
            return indo_date($tahun."-".$bulan."-01", "F Y");
        } else {
            return indo_date($tahun."-".$bulan."-01", "F Y");
        }
    }
}

if(!function_exists('isPeriodeApv')) {
    function isPeriodeApv($tahun = null, $bulan = null) {
        $CI =& get_instance();
        $CI->load->model('kpi/user/approval/home_m');

        $periode     = $CI->home_m->periodeApv($tahun, $bulan);
        $tglSekarang = date('Y-m-d');
        if($periode->num_rows() == 0) {
            return false;
        } else {
            if($periode->row()->periode_mulai <= $tglSekarang and $periode->row()->periode_selesai >= $tglSekarang) {
                return true;
            } else {
                return false;
            }
        }
    }
}

if(!function_exists('selectActual')) {
    function selectActual() {
        return [
            '0' => 'Pilih',
            '1' => 1,
            '2' => 2,
            '3' => 3,
            '4' => 4,
            '5' => 5,
        ];
    }
}

if(!function_exists('actual')) {
    function actual($data, $indek, $dataTrx, $approver, $id) {
        $CI =& get_instance();
        $CI->load->helper('kpi/kpi');

        if(isPeriodeApv() and $approver == $dataTrx->id_atasan and in_array($dataTrx->status, ['1', '8'])) {
            if($id == "id_aspek_kepribadian" || $id == "id_aspek_kepribadian_m") {
                return form_dropdown("actual[$indek]", selectActual(), $data->actual_poin_approval, "class='form-control text-center' onchange=\"ratingKepribadian($indek, this.value)\"").form_input(['name' => 'id[]', 'style' => 'display:none;'], $data->{$id});
            } else {
                return form_dropdown("actual[$indek]", selectActual(), $data->actual_poin_approval, "class='form-control text-center'").form_input(['name' => 'id[]', 'style' => 'display:none;'], $data->{$id});
            }
        } else {
            return $data->actual_poin_approval == '0' ? '' : $data->actual_poin_approval;
        }
    }
}

if(!function_exists('belumDisetujui')) {
    function belumDisetujui($status) {
        return !in_array($status, ['4', '9']);
    }
}

if(!function_exists('skor')) {
    function skor($data) {
        if($data->skor_predikat == null) {
            return "-";
        } else {
            return "$data->skor_predikat - $data->remark";
        }
    }
}

if(!function_exists('status')) {
    function status($id) {
        if($id == '1') {
            return "Diajukan";
        } elseif($id == '4') {
            return "Approved";
        }  elseif($id == '5') {
            return "Draft Target";
        } elseif($id == '6') {
            return "Publish Target";
        } elseif($id == '7') {
            return "Draft Actual";
        } elseif($id == '8') {
            return "Draft Approval";
        } elseif($id == '9') {
            return "Diterima";
        }
    }
}

if(!function_exists('validasiPeriodeInput')) {
    function validasiPeriodeInput($periode) {
        $CI =& get_instance();
        if($periode['isPeriodeExist']) {
            return "<span class='badge badge-primary-periode p-2'><i class='fa fa-info-circle'></i>&nbsp;&nbsp;".$CI->lang->line('kpi_input_period')." : ".$periode['periodeMulai']." ".$CI->lang->line('s/d')." ".$periode['periodeSelesai']."</span>";
        } else {
            return "<span class='badge badge-primary-periode p-2'><i class='fa fa-info-circle'></i>&nbsp;&nbsp;".$CI->lang->line('kpi_input_period_not_set')."</span>";
        }
    }
}

if(!function_exists('validasiPeriodeApv')) {
    function validasiPeriodeApv($tahun, $bulan) {
        $CI =& get_instance();
        $CI->load->model('kpi/user/approval/home_m');
        $periode     = $CI->home_m->periodeApv($tahun, $bulan);
        $tglSekarang = date('Y-m-d');
        if($periode->num_rows() == 0) {
            return "<span class='badge badge-primary-periode p-2'><i class='fa fa-info-circle'></i>&nbsp;&nbsp;Periode approval KPI belum diset</span>";
        } else {
            return "<span class='badge badge-primary-periode p-2'><i class='fa fa-info-circle'></i>&nbsp;&nbsp;Periode approval KPI : ".indo_date($periode->row()->periode_mulai)." s/d ".indo_date($periode->row()->periode_selesai)."</span>";
        }
    }
}