<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dropdown extends MY_Controller {

    public function pkwt_komp_tunj(){
        $search = $this->input->get("q");

        $this->db->select('id_komponen, nm_komp, no_urut');
        $this->db->where('id_company',  $this->id_company);
        $this->db->group_start();
        $this->db->like('nm_komp', $search);
        $this->db->group_end();
        $this->db->order_by('no_urut', 'ASC');

        $result = $this->db->get('pkwt_komp_m')->result();

        $json = [];
        foreach ($result as $rows) {
            $json[] = [ 'id'=>$rows->id_komponen,
                        'text'=>$rows->nm_komp];
        }
        echo json_encode($json);
    }

    public function tunjangan(){
        $search = $this->input->get("q");

        $this->db->select('nm_komp, id_komponen, no_urut');
        $this->db->where('id_company', $this->id_company);
        $this->db->like('nm_komp', $search);
        $this->db->order_by('no_urut', 'ASC');

        $result = $this->db->get('pkwt_komp_m')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_komponen, 'text'=>$rows->nm_komp, 'urutan' => $rows->no_urut];
        }
        echo json_encode($json);
    }

    public function template(){
        $search = $this->input->get("q");

        $this->db->select('nama, id_template, parameter, template');
        $this->db->where('id_company', $this->id_company);
        $this->db->like('nama', $search);
        $this->db->order_by('id_template', 'DESC');

        $result = $this->db->get('pkwt_template_m')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_template, 'text'=>$rows->nama, 'parameter' => $rows->parameter, 'template' => $rows->template];
        }
        echo json_encode($json);
    }

    public function direktur(){
        $search = $this->input->get("search");

        $this->db->join('master_jabatan', 'master_jabatan.id_jabatan = data_karyawan.id_jabatan');
        if($this->input->get("belum_diinput") == "true") {
            $this->db->select('data_karyawan.id_karyawan, data_karyawan.nik, data_karyawan.nama_lengkap');
            $this->db->join('pkwt_direktur', 'pkwt_direktur.id_karyawan = data_karyawan.id_karyawan', 'left');
            $this->db->where('pkwt_direktur.id_karyawan is null', null);
        } else {
            $this->db->select('data_karyawan.id_karyawan, data_karyawan.nik, pkwt_direktur.nm_karyawan as nama_lengkap');
            $this->db->join('pkwt_direktur', 'pkwt_direktur.id_karyawan = data_karyawan.id_karyawan');
        }
        $this->db->where('data_karyawan.id_company', $this->id_company);
        $this->db->where('master_jabatan.level_user', '4');
        $this->db->group_start();
        $this->db->like('data_karyawan.nama_lengkap', $search);
        $this->db->group_end();
        $this->db->order_by('data_karyawan.nama_lengkap', 'ASC');

        $result = $this->db->get('data_karyawan')->result();
        $json = [];
        foreach ($result as $rows) {
            $json[] = ['id'=>$rows->id_karyawan, 'text'=>$rows->nama_lengkap];
        }
        echo json_encode($json);
    }
}