<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Bobot extends MY_Controller {

    public function __construct()
	{
		parent::__construct();
		$this->load->model('kpi/admin/pengaturan/Bobot_m', 'model');
	}

    public function index()
    {
        $this->load->view('kpi/admin/pengaturan/bobot/home');
		$this->load->view('kpi/admin/pengaturan/bobot/js');

    }

    public function list_data(){
		$list = $this->model->get_datatables();
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row   = array();
			$row[] = $no;
			$row[] = $field->nama_jabatan. '<BR><b>'. $field->nama_usergroup. '</b>';

			if($field->action == "insert"){
				$row[] = "-";
				$row[] = "-";
				$row[] = "-";
			}else{
				$row[] = $field->bobot_aspek_kinerja. ' %';
				$row[] = $field->bobot_aspek_kepribadian. ' %';
				$row[] = $field->bobot_aspek_kedisiplinan. ' %';
			}
			$row[] = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> 
						<i id="' . md5($field->id_jabatan) . '" class="btn_edit fa fa-edit (alias) " onclick="edit(this)" data-action="'.$field->action.'"></i>
					</a>';
	
			$data[] = $row;
		}
	
		$output = array(
			"draw"            => $_GET['draw'],
			"recordsTotal"    => $this->model->count_all(),
			"recordsFiltered" => $this->model->count_filtered(),
			"data"            => $data
		);
	
		$output = __response($this->MY_response, $output);
	
		echo json_encode($output);
	}

	public function form($id = ""){
		$data = [];
		if(!empty($id)){
			$data['data'] = $this->model->getDataById($id);
		}

		$this->load->view('kpi/admin/pengaturan/bobot/form',$data);
	}

	public function update(){
		$id      = $this->input->post('id_jabatan');
		$action  = $this->input->post('action');
		$bobot_1 = $this->input->post('bobot_aspek_kinerja');
		$bobot_2 = $this->input->post('bobot_aspek_kepribadian');
		$bobot_3 = $this->input->post('bobot_aspek_kedisiplinan');

		$total_bobot = $bobot_1 + $bobot_2 + $bobot_3;
		if($total_bobot != 100){
            $message = array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Total bobot harus 100 %</font>');
            return __response_save(false, $message);
        }

		$data = array(
			'bobot_aspek_kinerja'      => $this->input->post('bobot_aspek_kinerja'),
			'bobot_aspek_kepribadian'  => $this->input->post('bobot_aspek_kepribadian'),
			'bobot_aspek_kedisiplinan' => $this->input->post('bobot_aspek_kedisiplinan'),
			'id_company'               => $this->id_company,
		);

		$this->model->save($data, $id, $action);
	}
}