<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">PKWT</a>
                        </li>
                        <li class="breadcrumb-item active">Import PKWT
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('pkwt.home') ?>">
                    <button type="button" class="btn_tambah btn btn-secondary">
                        <i class="fa fa-arrow-left"></i> Kembali
                    </button>
                </a>
            </div>
        </div>
    </div>
    
    <hr>

    <div class="row">
        <div class="col-md-3">
            <div class="form-group">
                <label>Upload File <span class="text-danger">*</span></label>
                <input type="file" name="file" id="file" class="form-control">
            </div>
        </div>
        <div class="col-md-3 align-self-end">
            <div class="form-group">
                <button type="button" id="btn_import_pkwt" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-upload"></i> Import Data PKWT</button>
                <button type="button" id="btn_form_template" class="btn btn-primary"><i class="fa fa-download"></i> Unduh Template</button>
            </div>
        </div>
        <div class="col align-self-end">
            <div class="form-group">
                <label id="message_import"></label>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div id="content" class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-success btn_simpan_semua" id="simpan_all"><i class="fa fa-save"></i> Simpan Semua Data</button>
                        <button class="btn btn-danger btn_hapus_semua" id="hapus_all"><i class="fa fa-trash"></i> Hapus Semua Draft</button>
                    </div>
                    <div class="col-md-6 text-right">
                        <button class="btn btn-warning btn-sm" title="Data tidak ditemukan"></button> <span>Data sudah ada</span>
                        <button class="btn btn-danger btn-sm" title="Data Kosong"></button> <span>Data tidak lengkap</span>
                    </div>
                </div>
                <div class="row mt-1">
                    <div class="col-md-12 table-responsive">
                        <table id="list_data_draft_pkwt" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="text-center">NO</th>
                                    <th class="text-center">NAMA KARYAWAN</th>
                                    <th class="text-center">JABATAN</th>
                                    <th class="text-center">CABANG<br>DEPARTEMEN</th>
                                    <th class="text-center">TANGGAL<br>HUBUNGAN KERJA</th>
                                    <th class="text-center">AKSI</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_form_pkwt" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div id="tampil_form_pkwt" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_hapus_pkwt" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form_hapus" class="modal-content">
            <input type="hidden" id="id_pkwt">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus_pkwt ladda-button" id="btn_hapus_pkwt" data-style="expand-left">HAPUS</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_alert_pkwt" class="modal fade in">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div id="tampil_alert_pkwt" class="modal-content">
            <div class="card-body text-center">
                <i id="icon_success" class="fa fa-check-circle text-success fa-9x" aria-hidden="true" style="font-size: 9em;"></i>
                <i id="icon_fail" class="fa fa-times-circle text-danger fa-9x" aria-hidden="true" style="font-size: 9em;"></i>
                <p id="keterangan_alert" class="mt-2 font-weight-bold"></p>
                <button class="btn btn-primary mt-2" data-dismiss="modal" style="width: 120px !important;">OK</button>
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_hapus" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right tombol">
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    function dropdown_template() {
        $("#template").select2({
            placeholder   : "Pilih Template",
            allowClear    : true,
            dropdownParent: $('#tampil_form'),
            ajax          : {
                url: '<?= route("dropdown.pkwt.template") ?>',
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }
    
    $(function() {
        list_data_draft_pkwt = $('#list_data_draft_pkwt').DataTable({
                    'searching'   : false,
                    'searchDelay' : 250,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : false,
                    'info'        : true,
                    'scrollX'     : true,
                    'stateSave'   : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('pkwt.import.list.data') ?>",
                                        "type": "GET",
                                        "data"  : function (d) {
                                            delete d.columns;
                                        },
                                        "complete" : function(data){
                                                reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(4)', nRow).css({'text-align':'center'});
                            $('td:eq(5)', nRow).css({'text-align':'center'});

                            if(aData[6] == 3) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#FFF9EI'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #F2C94C'});
                            } else if(aData[6] == 2) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#FFF1F1'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #EB5757'});
                            } else if(aData[6] == 4) {
                                $(nRow).find('td:not(:last)').css({'background-color': '#DEFBE6'});
                                $(nRow).find('td:eq(0)').css({'border-left': '5px solid #27AE60'});
                            }
                    }
        });

        $(document).on('click','#btn_form_template',function(){
            $('#tampil_form').load("<?= route('pkwt.import.form.template') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Unduh Template PKWT");
                $(".btn_unduh").addClass("btn_unduh btn btn-success");
                $(".btn_unduh").append('<i class="fa fa-download"></i> ');
                $(".btn_unduh").append('UNDUH');
                dropdown_template();
            });
        });

        $(document).on('click','.btn_edit_pkwt',function(){
            event.preventDefault();
            $('#tampil_form_pkwt').load("<?= route('pkwt.import.form.edit') ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form_pkwt').modal('show');
                $(".title").text("Form Update Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        // BUTTON SAVE
        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message_form').html("");
            var loading = Ladda.create(this);

            var valid_tgl_pkwt          =  document.getElementById("form_input_tanggal_pkwt").value;
            var valid_tgl_pkwt_mulai    =  document.getElementById("form_input_tanggal_mulai").value;
            var valid_tgl_pkwt_selesai  =  document.getElementById("form_input_tanggal_selesai").value;

            if(valid_tgl_pkwt==""){
                $('#message_form').show();
                $('#message_form').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal pkwt harus diisi</font>");
                $("#form_input_tanggal_pkwt").focus();
                return false;
            }else if(valid_tgl_pkwt_mulai==""){
                $('#message_form').show();
                $('#message_form').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal mulai kontrak harus diisi</font>");
                $("#form_input_tanggal_pkwt").focus();
                return false;
            }else if(valid_tgl_pkwt_selesai==""){
                $('#message_form').show();
                $('#message_form').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal selesai kontrak harus diisi</font>");
                $("#form_input_tanggal_selesai").focus();
                return false;
            }

            const parameter = $('input[name^="param_"]').toArray();
            for(let i = 0; i < parameter.length; i++) {
                if(parameter[i].value == ""){
                    const name = parameter[i].name.replace("param_", "");
                    $('#message_form').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> "+name+" harus diisi</font>");
                    $("input[name='param_"+name+"']").focus();
                    return false;
                }
            }

            loading.start();
        
            var param = {};
            param.id_pkwt           =  document.getElementById("form_input_id_pkwt").value;
            param.id_karyawan       =  document.getElementById("form_input_id_karyawan").value;
            param.flag              =  document.getElementById("form_input_flag").value;
            param.tgl_pkwt          =  valid_tgl_pkwt;
            param.tgl_pkwt_mulai    =  valid_tgl_pkwt_mulai;
            param.tgl_pkwt_selesai  =  valid_tgl_pkwt_selesai;
            param.draft_pkwt_parameter = $("#form_input_draft_pkwt_parameter").val();
            for(let i = 0; i < parameter.length; i++) {
                param[parameter[i].name] = parameter[i].value;
            }
            $.ajax({
                type: 'POST',
                url: "<?= route('pkwt.import.update') ?>",
                data: param,
                dataType:'JSON',
                success: function(result) {
                    loading.stop();
                    $('#message_form').show();
                    $('#message_form').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message_form').show();
                    $('#message_form').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // BUTTON DELETE
            $(document).on('click','.btn_delete_pkwt',function(){
                event.preventDefault();
                var id_pkwt = $(this).attr('id');
                $("#modal_hapus_pkwt #id_pkwt").val(id_pkwt);
                $("#modal_hapus_pkwt .card-body").show();
                $("#modal_hapus_pkwt .card-footer").show();
                $('#modal_hapus_pkwt').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $(".btn_hapus_pkwt").removeClass("btn_hapus_pkwt").addClass("btn_hapus_pkwt btn btn-danger");
            });

            $(document).on('click','.btn_hapus_pkwt',function(){
            var loading = Ladda.create(this);
            loading.start();
            id_pkwt = $("#modal_hapus_pkwt #id_pkwt").val();
            $.ajax({
                type: 'POST',
                url: "<?= route('pkwt.import.delete') ?>",
                data: 'id_pkwt='+id_pkwt,
                dataType:'JSON',
                success: function(result){
                    loading.stop();
                    $('#modal_hapus_pkwt').modal('hide');
                    $('#modal_alert_pkwt').modal('show');
                    $('#modal_alert_pkwt #icon_success').hide();
                    $('#modal_alert_pkwt #icon_fail').show();
                    $('#modal_alert_pkwt #keterangan_alert').html("Data Draft PKWT telah berhasil dihapus");
                    setTimeout(function() {
                        $('#modal_alert_pkwt').modal('hide');
                    }, 3000);
                },
                error:function(){
                    loading.stop();
                    $("#modal_hapus_pkwt .card-body").hide();
                    $("#modal_hapus_pkwt .card-footer").hide();
                    $("#modal_hapus_pkwt .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // UPLOAD EXCEL KE DATA TEMP
        $(document).on('click', '#btn_import_pkwt', function(){
            var loading = Ladda.create(this);
            $('#message_import').html("");

            if(document.getElementById("file").files.length == "0"){
                $('#message_import').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> File belum diupload</font>");
                $('#file').focus();
                return false;
            }

            loading.start();

            var data = new FormData();
            data.append('file',$('#file').prop('files')[0]);

            $.ajax({
                type: 'POST',
                url: "<?= route('pkwt.import.preview') ?>",
                data: data,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(result){
                    loading.stop();
                    if(result.success) {
                        $('#file').val('');
                    }
                    $('#message_import').show();
                    $('#message_import').html(result.message);
                },
                error: function(){
                    loading.stop();
                    $('#message_import').show();
                    $('#message_import').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // BUTTON & ACTION SAVE ALL
        $(document).on('click','.btn_simpan_semua',function(){
            var id = $(this).attr('id');
            $('#modal_hapus').modal('show');
            $(".title").text("Apakah anda ingin menyimpan semua data ini?");
            $("#modal_hapus .card-body").show();
            $("#modal_hapus .card-footer").show();
            $(".tombol").empty();
            $(".tombol").append('<button class="btn_save_semua btn btn-primary ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>');

            $('.btn_save_semua').on('click',function(){
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?= route('pkwt.import.simpan.semua') ?>",
                    data: 'id='+id,
                    dataType:'JSON',
                    success: function(result){
                        $("#modal_hapus .card-body").hide();
                        $("#modal_hapus .card-footer").hide();
                        $("#modal_hapus .title").html(result.message);
                        loading.stop();
                    },
                    error:function(){
                        loading.stop();
                        $("#modal_hapus .card-body").hide();
                        $("#modal_hapus .card-footer").hide();
                        $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan atau format tidak sesuai</strong></font>');
                    }
                });
            });
        });

        // BUTTON MENGHAPUS DATA TEMP
        $(document).on('click','.btn_hapus_semua',function(){
            $('#modal_hapus').modal('show');
            $(".title").text("Apakah anda ingin menghapus semua data ini?");
            $("#modal_hapus .card-body").show();
            $("#modal_hapus .card-footer").show();
            $(".tombol").empty();
            $(".tombol").append('<button class="btn_delete_semua btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');

            //btn_delete
            $('.btn_delete_semua').on('click',function(){
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?=  route('pkwt.import.delete.semua') ?>",
                    dataType:'JSON',
                    success: function(result){
                        $("#modal_hapus .card-body").hide();
                        $("#modal_hapus .card-footer").hide();
                        $("#modal_hapus .title").html(result.message);
                        loading.stop();
                    },
                    error:function(){
                        loading.stop();
                        $("#modal_hapus .card-body").hide();
                        $("#modal_hapus .card-footer").hide();
                        $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
        });
    });
</script>