<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="form_input_approval_semua" class="card-body" disabled>
    <input type="hidden" name="nm_direktur" id="nm_direktur" value="<?= $direktur->nm_direktur ?>">
    <input type="hidden" name="path_ttd" id="path_ttd" value="<?= $direktur->path_ttd ?>">

    <div class="row">
        <div class="col-md-4"><label>Approval</label></div>
        <div class="col-md-8">
            <div class="row">
                <div class="col-md-6">
                    <section class="light">
                        <label id="label">
                            <input type="radio" id="verifikasi_all" name="verifikasi_all" value="4" checked>
                            <span class="design"></span>
                            <span class="text">Setuju</span>
                        </label>
                    </section>
                </div>
                <div class="col-md-6">
                    <section class="light">
                        <label id="label">
                            <input type="radio" id="verifikasi_all" name="verifikasi_all" value="3">
                            <span class="design"></span>
                            <span class="text">Tolak</span>
                        </label>
                    </section>
                </div>
            </div>
        </div>
    </div>

    <div id="div_ket_tolak" class="row mt-2" style="display:none">
        <div class="col-md-4"><label>Keterangan Tolak</label></div>
        <div class="col-md-8">
            <textarea id="ket_tolak" rows="5" style="width:100%;"></textarea>
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-md-4"><label>Nama Direktur</label></div>
        <div class="col-md-8">
            <select name="ttd_direktur" id="ttd_direktur" class="form-control" style="width: 100%"></select>
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-md-12">
            <label>Tandatangan Direktur</label><br>
            <img id="image_ttd" src="<?= $this->config->item('base_image').'image?_t=file&_d='.$direktur->path_ttd ?>" class="portrait" height="200px">
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message_approval_semua"></div>
        </div>
        <div class="col-md-5 text-right">
            <button class="btn btn-primary btn_submit_approve_all ladda-button" data-style="expand-left">SUBMIT SEMUA</button>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $("#form_input_approval_semua #ttd_direktur").select2({
            placeholder: 'Pilih Tandatangan Direktur',
            allowClear: true,
            dropdownParent: $('#form_input_approval_semua'),
            ajax: {
                url: "<?= route('dropdown.pkwt.direktur') ?>",
                data: function (params) {
                    var query = {
                        search: params.term,
                        belum_diinput: false
                    }

                    // Query parameters will be ?search=[term]&belum_diinput=false
                    return query;
                },
                dataType: 'json',
                processResults: function (data) {
                    // Transforms the top-level key of the response object from 'items' to 'results'
                    return {
                        results: data
                    };
                }
            }
        });

        // ONCHANGE TTD DIREKTUR
        $("#form_input_approval_semua #ttd_direktur").change(function(){
            var id_karyawan = $(this).val();
            $.ajax({
                type: 'GET',
                url: '<?= route("pkwt.verifikasi.onchange.path.ttd") ?>'+'?id_karyawan='+id_karyawan,
                dataType: 'json',
                success: function(result){
                    if(result.success){
                        $("#form_input_approval_semua #path_ttd").val(result.data.path_ttd);
                        
                        var base_image = '<?= $this->config->item('base_image') ?>image?_t=file&_d=' + result.data.path_ttd;
                        $("#form_input_approval_semua #image_ttd").attr("src", base_image);
                    } else {
                        var base_image = '<?= $this->config->item('base_image') ?>image?_t=file&_d=';
                        $("#form_input_approval_semua #image_ttd").attr("src", base_image);
                    }
                }
            })
        });
    });

    $(document).on('click','input[name=verifikasi_all]:checked',function(){
        var status = $(this).val();
        if(status == "4"){
            $('#form_input_approval_semua #div_ket_tolak').hide();
        }else{
            $('#form_input_approval_semua #div_ket_tolak').show();
        }
    });
</script>