<script type="text/javascript">
    $(function() {
        if (sessionStorage.getItem("back_button") == "true") {
            restore_session();
        } else {
            list_data();
        }
    });

    function list_data() {
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/pengguna_aktif" ?>");
    }

    $(document).on('click', '#btn_tabs_jabatan', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/jabatan" ?>");
    });

    $(document).on('click', '#btn_tabs_pengguna_aktif', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/pengguna_aktif" ?>");
    });

    $(document).on('click', '#btn_tabs_pendidikan', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/pendidikan" ?>");
    });

    $(document).on('click', '#btn_tabs_lokasi', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/lokasi" ?>");
    });

    $(document).on('click', '#btn_tabs_device', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/device" ?>");
    });

    $(document).on('click', '#btn_tabs_face', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/facerecognition" ?>");
    });

    $(document).on('click', '#btn_tabs_camera', function() {
        clear_session_search();
        $('#tab_content').load("<?= route('master.karyawan.tabs') . "/camera" ?>");
    });

    //btn_hapus
    $(document).on('click', '.btn_delete', function() {
        var id_karyawan = $(this).attr('id');
        $("#modal_karyawan #id_karyawan").val(id_karyawan);
        $("#modal_karyawan .card-body").show();
        $("#modal_karyawan .card-footer").show();
        $('#modal_karyawan').modal('show');
        $(".title").text("Apakah Anda ingin menghapus data ini?");
        $(".btn_hapus").removeClass("btn_hapus").addClass("btn_hapus btn btn-danger");
    });
    //btn_hapus

    //btn_delete
    $(document).on('click', '.btn_hapus', function() {
        var loading = Ladda.create(this);
        loading.start();
        id_karyawan = $("#modal_karyawan #id_karyawan").val();
        $.ajax({
            type: 'POST',
            url: "<?= route('master.karyawan.delete') ?>",
            data: 'id_karyawan=' + id_karyawan,
            dataType: 'JSON',
            success: function(result) {
                loading.stop();
                $("#modal_karyawan .card-body").hide();
                $("#modal_karyawan .card-footer").hide();
                $("#modal_karyawan .title").html(result.message);
            },
            error: function() {
                loading.stop();
                $("#modal_karyawan .card-body").hide();
                $("#modal_karyawan .card-footer").hide();
                $("#modal_karyawan .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    });
    //btn_delete

    // save filter session menggunakan session storage
    function save_filter_session() {
        var tab_active = $('.nav-tabs li a.active').attr('id');
        var list_filter = ['karyawan', 'jabatan', 'cabang', 'departemen', 'jenis_kelamin'];

        sessionStorage.setItem("tab_active", tab_active);
        list_filter.forEach(function(value) {
            var temp = $('#' + value).val();
            if (temp != null) {
                sessionStorage.setItem(value, temp);
            }
        });
        save_filter_session_tambahan(tab_active);
        sessionStorage.setItem("dt_length", list_data.page.len());
        sessionStorage.setItem("dt_paging_current", list_data.page.info().page); //start from index 0
    }

    function save_filter_session_tambahan(tab_active) {
        // menyimpan session storage selain di list filter
        if (tab_active == "btn_tabs_jabatan") {
            sessionStorage.setItem("status", $('#status').val());
        } else if (tab_active == "btn_tabs_pendidikan") {
            sessionStorage.setItem("pendidikan_terakhir", $('#pendidikan_terakhir').val());
        } else if (tab_active == "btn_tabs_lokasi") {
            sessionStorage.setItem("lock_lokasi", $('#lock_lokasi').val());
        } else if (tab_active == "btn_tabs_device") {
            sessionStorage.setItem("lock_device", $('#lock_device').val());
        } else if (tab_active == "btn_tabs_face" || tab_active == "btn_tabs_camera") {
            sessionStorage.setItem("lock_facerecognition", $('#lock_facerecognition').val());
        }
    }

    function save_filter_session_search(jenis, id) {
        sessionStorage.setItem("search_jenis", jenis);
        sessionStorage.setItem("search_id", id);
    }

    function restore_session() {
        restore_tab_session();
    }

    function restore_tab_session() {
        // restore tab active
        var id = sessionStorage.getItem("tab_active");
        var param_url = id.replace("btn_tabs_", "");
        if (param_url == "face") {
            param_url = "facerecognition";
        }

        $("#" + id).trigger("click");
        $('#tab_content').load("<?= site_url('master/karyawan/tabs') ?>/" + param_url, function() {
            var search_id = sessionStorage.getItem("search_id");
            if (search_id != null) {
                restore_search_session();
                restore_filter_session();
                restore_filter_session_tambahan(id);
            }
        });
    }

    function restore_filter_session() {
        // restore filter
        if (sessionStorage.getItem("search_jenis") == "filter") {
            var list_filter = ['jabatan', 'cabang', 'departemen', 'jenis_kelamin'];
            list_filter.forEach(function(value) {
                var temp_value = sessionStorage.getItem(value);
                if (temp_value != null) {
                    if (value == 'jenis_kelamin') {
                        $('#jenis_kelamin').val(temp_value);
                    } else {
                        select2_preselect(value, temp_value);
                    }
                }
            });
        }
    }

    function restore_search_session() {
        // restore cari
        if (sessionStorage.getItem("search_jenis") == "cari") {
            var list_filter = ['karyawan'];
            list_filter.forEach(function(value) {
                var temp_value = sessionStorage.getItem(value);
                if (temp_value != null) {
                    select2_preselect(value, temp_value);
                }
            });
        }
    }

    function clear_session_search() {
        sessionStorage.removeItem("search_id");
        sessionStorage.removeItem("search_jenis");
    }

    function restore_filter_session_tambahan(tab_active) {
        // mengembalikan session storage selain di list filter
        var id = "";
        var value = "";
        if (tab_active == "btn_tabs_jabatan") {
            id = "status";
            value = sessionStorage.getItem(id);
        } else if (tab_active == "btn_tabs_pendidikan") {
            id = "pendidikan_terakhir";
            value = sessionStorage.getItem(id);
        } else if (tab_active == "btn_tabs_lokasi") {
            id = "lock_lokasi";
            value = sessionStorage.getItem(id);
        } else if (tab_active == "btn_tabs_device") {
            id = "lock_device";
            value = sessionStorage.getItem(id);
        } else if (tab_active == "btn_tabs_face" || tab_active == "btn_tabs_camera") {
            id = "lock_facerecognition";
            value = sessionStorage.getItem(id);
        }
        $("#" + id).val(value);
    }

    function select2_preselect(id, value) {
        var tempSelect = $('#' + id);
        $.ajax({
            type: 'GET',
            url: '<?= site_url("dropdown/preselect") ?>/' + id + '/' + value,
            dataType: "json"
        }).then(function(data) {
            // create the option and append to Select2
            var option = new Option(data.text, data.id, true, true);
            tempSelect.append(option).trigger('change');
        });
    }

    function set_default_page() {
        if (sessionStorage.getItem("dt_paging_current") != null) {
            list_data.page(parseInt(sessionStorage.getItem("dt_paging_current"))).draw('page');
        }

        // clear session
        if (sessionStorage.getItem("back_button") == "true") {
            // simpan temp search
            var search_id = sessionStorage.getItem("search_id");
            var search_jenis = sessionStorage.getItem("search_jenis");

            sessionStorage.clear();
            if (search_id != null) {
                sessionStorage.setItem("search_id", search_id);
                sessionStorage.setItem("search_jenis", search_jenis);
            }
        }
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <?php
                if (in_array($this->session->userdata("level_user"), ['1'])) {
                ?>
                    <a href="<?= route('master.karyawan.bagan.organisasi.home') ?>" target="_blank" class="btn btn-warning text-white mr-5"><i class="fa fa-ellipsis-h"></i> BAGAN ORGANISASI</a>
                    <a href="<?= route('karyawan.import.home') ?>">
                        <button class="btn btn-success"><i class="fa fa-upload"></i> <?= $this->lang->line('button_import_karyawan') ?></button>
                    </a>

                    <a href="<?= route('master.karyawan.tambah') ?>" class="btn_tambah btn btn-biru text-white"><i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?></a>

                <?php
                }
                ?>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="nav-tabs-boxed">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item"><a href="#" id="btn_tabs_pengguna_aktif" class="nav-link active" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-user-circle-o"></i> <?= $this->lang->line('pengguna_aktif') ?></h6>
                        </a></li>
                    <li class="nav-item"><a href="#" id="btn_tabs_pendidikan" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-file-text"></i> <?= $this->lang->line('pendidikan') ?></h6>
                        </a></li>
                    <li class="nav-item"><a href="#" id="btn_tabs_lokasi" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-map-marker"></i> <?= $this->lang->line('lock_lokasi_absensi') ?></h6>
                        </a></li>
                    <li class="nav-item"><a href="#" id="btn_tabs_device" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-mobile-phone"></i> <?= $this->lang->line('lock_device') ?></h6>
                        </a></li>
                    <li class="nav-item"><a href="#" id="btn_tabs_face" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-user"></i> <?= $this->lang->line('lock_face_recognition') ?></h6>
                        </a></li>
                    <li class="nav-item"><a href="#" id="btn_tabs_camera" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-camera"></i> <?= $this->lang->line('default_kamera') ?></h6>
                        </a></li>
                    <li class="nav-item"><a href="#" id="btn_tabs_jabatan" class="nav-link" data-toggle="tab" role="tab">
                            <h6><i class="fa fa-suitcase"></i> Status</h6>
                        </a></li>
                </ul>
            </div>
            <div class="row mt-2">
                <div id="tab_content" class="col-md-12"></div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_karyawan" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content">
            <input type="hidden" id="id_karyawan">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"><?= $this->lang->line('button_form_hapus') ?></button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
