<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Kepala_departemen_m extends CI_Model {
    var $table = 'p_kedep';
    public function __construct(){
        parent::__construct();
    }

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){

        if($this->level_user == "5") {
            $this->db->where("p_kedep.id_cabang",$this->id_cabang);
        }
        $this->db->select("p_kedep.id");
        $this->db->join('data_karyawan', 'data_karyawan.id_karyawan = p_kedep.id_karyawan');
        $this->db->where("p_kedep.id_company", $this->id_company);
        $this->db->where("data_karyawan.status IN ('1','2','3','4')");
        $this->db->group_by('p_kedep.id_karyawan');
        $this->db->from($this->table);

        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){

        if($this->level_user == "5") {
            $this->db->where("p_kedep.id_cabang",$this->id_cabang);
        }

        $this->db->select("p_kedep.id,
                            p_kedep.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            p_kedep.id_cabang, 
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,
                            p_kedep.id_departemen,
                            master_departemen.kode as kode_departemen,
                            master_departemen.nama as nama_departemen,
                            count(p_kedep.id_departemen) as jumlah_departemen,
                            p_kedep.flag");
        $this->db->join('master_cabang', 'master_cabang.id_cabang = p_kedep.id_cabang');
        $this->db->join('master_departemen', 'master_departemen.id_departemen = p_kedep.id_departemen');
        $this->db->join('data_karyawan', 'data_karyawan.id_karyawan = p_kedep.id_karyawan');
        $this->db->where("p_kedep.id_company", $this->id_company);
        $this->db->where("data_karyawan.status IN ('1','2','3','4')");
        $this->db->group_by('p_kedep.id_karyawan');
        $this->db->from($this->table);

        

        $column_search = array('data_karyawan.nik',
                                'data_karyawan.nama_lengkap',
                                'master_cabang.kode',
                                'master_cabang.nama',
                                'master_departemen.kode',
                                'master_departemen.nama');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','data_karyawan.nik','data_karyawan.nama_lengkap');
    
        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } 
        else{
            $order_by = array("data_karyawan.nik"=>"ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getKaryawan($id_karyawan=null){
        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            master_cabang.id_cabang,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang");
        $this->db->join('master_cabang', 'master_cabang.id_cabang = p_kedep.id_cabang');
        $this->db->join('data_karyawan', 'data_karyawan.id_karyawan = p_kedep.id_karyawan');
        $this->db->where("p_kedep.id_company", $this->id_company);
        $this->db->where("md5(p_kedep.id_karyawan)", $id_karyawan);
        $this->db->group_by('p_kedep.id_karyawan');
        $this->db->from($this->table);
        
        $query = $this->db->get();
        return $query->row();
    }

    public function getDataDepartemen($id_karyawan = null){
        $query = $this->db->select("master_departemen.id_departemen,
                                    master_departemen.kode, 
                                    master_departemen.nama, 
                                    p_kedep.flag")
                        ->from("p_kedep")
                        ->join("master_departemen","master_departemen.id_departemen = p_kedep.id_departemen")
                        ->where("MD5(p_kedep.id_karyawan)",$id_karyawan)
                        ->order_by("master_departemen.kode ASC")
                        ->get()
                        ->result();

        return $query;
    }

    public function update($data_insert=null, $id_karyawan=null){
        $this->db->trans_start();

        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan",$id_karyawan);
        $this->db->where("flag","0");
        $this->db->delete($this->table);
        $this->logger->create_log('pengaturan_kepala_departemen', 'delete', $this->db->last_query());

        if(!empty($data_insert)){
            $this->db->insert_batch($this->table, $data_insert);
            $this->logger->create_log('pengaturan_kepala_departemen', 'tambah', $this->db->last_query());
        }

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE){
            $this->db->trans_rollback();
            return  __response_update(false);
        }else{
            $this->db->trans_commit();
            return  __response_update(true);
        }
    }
}